/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValuePacket;
import X10Gimli.Value.ValueString;
import java.util.ArrayList;

public class RECORDGateway
extends InputOutputGateway {
    private boolean isRecording = false;
    private StringBuffer sBuf;

    public RECORDGateway() {
        this.setName("RECORD");
    }

    public boolean initialize(Value id) {
        if (id == null) {
            Debug.log(1, "\"Successfully activated recording gateway.\"");
            return true;
        }
        Debug.error(100, "\"No parameters expected for recording gateway.\"");
        return false;
    }

    public void sendPacket(Packet p) {
        p.unpackData();
        if (p.getType().equals("RECORD")) {
            if (p.getValue("COMMAND").getValueString() == "START") {
                if (!this.isRecording) {
                    Debug.log(1, "\"Recording of output has started...\"");
                    this.sBuf = new StringBuffer();
                    this.isRecording = true;
                }
            } else if (p.getValue("COMMAND").getValueString() == "STOP" && this.isRecording) {
                Debug.log(1, "\"Recording of output has ended...\"");
                System.out.println(this.sBuf.toString());
                p.setFlags((byte)1);
                p.setTags(new ArrayList());
                p.setValues(new ArrayList());
                p.setSource("");
                p.setDest("");
                p.addSegment("RETURN", new ValueString(this.sBuf.toString()));
                this.inputReceived(p);
            }
        } else if (this.isRecording && !p.getType().equals("X10GIMLI")) {
            this.sBuf.append("sendpacket(");
            this.sBuf.append(new ValuePacket(p).toString());
            this.sBuf.append(");\r\n");
        }
    }
}

