/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.X10addressPacket;
import X10Gimli.System.Packet.X10functionPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueX10;
import X10Gimli.X10.X10Data;
import X10Gimli.X10.X10Queue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class CM11AGateway
extends InputOutputGateway
implements SerialPortEventListener {
    private SerialPort port;
    private InputStream inputStream;
    private OutputStream outputStream;
    private static final int ST_READY = 0;
    private static final int ST_POLL = 1;
    private static final int ST_RECEIVE = 2;
    private static final int ST_TIMERDOWNLOAD = 3;
    private static final int ST_ENABLERING = 4;
    private static final int ST_DISABLERING = 5;
    private static final int ST_EEPROMMACRODOWNLOAD = 6;
    private static final int ST_EXTENDED = 7;
    private static final int ST_STANDARD = 8;
    private static final int ST_SEND = 9;
    private static final int ST_ACK = 10;
    private static final int ST_POWERFAIL = 11;
    private int iState = 0;
    private int iChecksum = 0;
    private int[] bOutBytes;
    private int iCurrent;
    private int[] bInBytes;
    private BooleanWrapper outputResponse;
    private boolean moreDebug = false;
    private X10Queue requeue = new X10Queue();

    public CM11AGateway() {
        this.sSource = "CM11A";
    }

    public boolean initialize(Value portname) {
        if (portname instanceof ValueString) {
            String port = ((ValueString)portname).getString();
            try {
                if (CommPortIdentifier.getPortIdentifier((String)port) == null) {
                    Debug.log(1, "\"Unable to access port for CM11A.\"");
                    boolean bl = false;
                    return bl;
                }
            }
            catch (NoSuchPortException e) {
                Debug.log(1, "\"Port name not found to start CM11A.\"");
                boolean bl = false;
                return bl;
            }
            this.initPort(port);
            Debug.log(1, "\"Successfully activated CM11A.\"");
            return true;
        }
        Debug.log(1, "\"String port name required to activate CM11A.\"");
        return false;
    }

    private void initPort(String portName) {
        try {
            this.port = (SerialPort)CommPortIdentifier.getPortIdentifier((String)portName).open("CM11AGateway", 2000);
            this.port.setSerialPortParams(4800, 8, 1, 0);
            this.inputStream = this.port.getInputStream();
            this.outputStream = this.port.getOutputStream();
            this.port.addEventListener((SerialPortEventListener)this);
            this.port.notifyOnDataAvailable(true);
        }
        catch (NoSuchPortException noSuchPortException) {
        }
        catch (PortInUseException portInUseException) {
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
        }
        catch (IOException iOException) {
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void timeoutWait() {
        new Thread(new Runnable(){

            public void run() {
                BooleanWrapper bw = CM11AGateway.this.outputResponse;
                try {
                    Thread.sleep(4000L);
                }
                catch (Exception e) {
                    Debug.printCallStack("Interrupted sleep in timeout thread.", e);
                }
                if (!bw.b) {
                    CM11AGateway.this.iState = 0;
                    CM11AGateway.this.flushInput();
                    Debug.error(301, String.valueOf(String.valueOf(new StringBuffer("Timeout waiting for CM11A to handle output [").append(bw.output).append("].  Resetting gateway to default state."))));
                }
                bw = null;
            }
        }).start();
        Thread.yield();
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        this.nextByte();
                    }
                    break;
                }
                catch (Exception e) {
                    Debug.printCallStack("Exception reading serial port input.", e);
                }
            }
        }
    }

    protected void sendPacket(Packet packet) {
        if ((packet = packet.getPacketType()) instanceof X10addressPacket || packet instanceof X10functionPacket) {
            try {
                while (this.iState != 0) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                Debug.printCallStack("Exception while waiting for ready state of CM11A.", e);
            }
            this.iState = 8;
            int func = 0;
            int device = 0;
            int dims = 0;
            int maxdims = 0;
            if (packet instanceof X10addressPacket) {
                X10addressPacket ap = (X10addressPacket)packet;
                this.bOutBytes = new int[2];
                device = ap.getX10().getDeviceCode();
                char house = ap.getX10().getHouseCode();
                this.bOutBytes[0] = 4;
                this.bOutBytes[1] = X10Data.houseCodeToByte(house) << 4 | X10Data.deviceCodeToByte(device);
                this.iChecksum = 0;
                this.iState = 9;
                this.outputResponse = new BooleanWrapper(this, false);
                this.outputResponse.output = "ADDR ".concat(String.valueOf(String.valueOf(ap.getX10().toString())));
                this.timeoutWait();
                this.sendBytes(this.bOutBytes);
            } else if (packet instanceof X10functionPacket) {
                X10functionPacket fp = (X10functionPacket)packet;
                this.bOutBytes = new int[2];
                func = fp.getCommand().getCommand();
                char house = fp.getX10().getHouseCode();
                if (fp.getDims() != null) {
                    dims = fp.getDims().getNumber();
                }
                maxdims = 22;
                this.bOutBytes[0] = dims * 100 / maxdims * 22 / 100 << 3 | 6;
                this.bOutBytes[1] = X10Data.houseCodeToByte(house) << 4 | func;
                this.iChecksum = 0;
                this.iState = 9;
                this.outputResponse = new BooleanWrapper(this, false);
                this.outputResponse.output = String.valueOf(String.valueOf(new StringBuffer("FUNC ").append(fp.getX10().getHouseCode()).append(" ").append(fp.getCommand().toString())));
                this.timeoutWait();
                this.sendBytes(this.bOutBytes);
            }
        } else if (packet.getType() == "CM11A" && packet.getValue("DEBUG") != null) {
            this.moreDebug = packet.getValue("DEBUG").getBoolean();
        }
    }

    private void setClock() {
        Calendar now = Calendar.getInstance();
        this.setClock(now.get(11), now.get(12), now.get(13), now.get(2), now.get(5), now.get(7), 'A', false, false, false);
    }

    private void setClock(int hour, int minute, int second, int month, int day, int dayOfWeek, char houseCode, boolean clearBatteryTimer, boolean clearMonitoredStatus, boolean purgeTimer) {
        this.iState = 3;
        this.bOutBytes = new int[7];
        int next = 0;
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be between 0 and 23, inclusive.");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be between 0 and 59, inclusive.");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Second must be between 0 and 59, inclusive.");
        }
        this.bOutBytes[0] = 155;
        this.bOutBytes[1] = second;
        int minutes = hour * 60 + minute;
        this.bOutBytes[2] = (hour * 60 + minute) % 120;
        this.bOutBytes[3] = (hour * 60 + minute - (hour * 60 + minute) % 120) / 120;
        this.bOutBytes[4] = X10Data.dayOfYear(month, day) & 0xFF;
        switch (dayOfWeek) {
            case 1: {
                next = 1;
                break;
            }
            case 2: {
                next = 2;
                break;
            }
            case 3: {
                next = 4;
                break;
            }
            case 4: {
                next = 8;
                break;
            }
            case 5: {
                next = 16;
                break;
            }
            case 6: {
                next = 32;
                break;
            }
            case 7: {
                next = 64;
                break;
            }
        }
        if (X10Data.dayOfYear(month, day) > 255) {
            next |= 0x80;
        }
        this.bOutBytes[5] = next;
        next = X10Data.houseCodeToByte(houseCode) << 4;
        if (clearBatteryTimer) {
            next |= 4;
        }
        if (clearMonitoredStatus) {
            next |= 1;
        }
        if (purgeTimer) {
            next |= 2;
        }
        this.bOutBytes[6] = next;
        this.iChecksum = 0;
        this.iState = 9;
        this.outputResponse = new BooleanWrapper(this, false);
        this.sendBytes(this.bOutBytes);
    }

    private void resend() {
        if (!this.requeue.isEmpty()) {
            this.iState = 9;
            this.bOutBytes = (int[])this.requeue.get();
            this.sendBytes(this.bOutBytes);
        }
    }

    private void nextByte() {
        char c = '\u0000';
        try {
            c = (char)this.inputStream.read();
            if (this.moreDebug) {
                Debug.log(2, "CM11A Read: ".concat(String.valueOf(String.valueOf(Debug.hexByte((byte)c)))));
            }
        }
        catch (Exception e) {
            Debug.printCallStack("Exception in reading next byte from input stream.", e);
        }
        this.nextInByte(c);
    }

    private void send(int b) {
        try {
            this.outputStream.write(b);
            if (this.moreDebug) {
                Debug.log(2, "CM11A Write: ".concat(String.valueOf(String.valueOf(Debug.hexByte((byte)b)))));
            }
            this.iChecksum += b;
        }
        catch (IOException e) {
            Debug.printCallStack("Exception during serial port write.", e);
        }
    }

    private void sendByte(int b) {
        this.send(b);
    }

    private void sendBytes(int[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.send(b[i]);
        }
    }

    private void flushInput() {
        try {
            while (this.inputStream.available() > 0) {
                this.inputStream.read();
            }
        }
        catch (Exception e) {
            Debug.printCallStack("Exception in flushing input.", e);
        }
    }

    private void nextInByte(int c) {
        switch (this.iState) {
            case 0: {
                this.flushInput();
                if (c == 165) {
                    if (this.moreDebug) {
                        Debug.log(2, "CM11A(READY): Power fail.  Resetting CM11A clock.");
                    }
                    this.iState = 11;
                    this.outputResponse = new BooleanWrapper(this, false);
                    this.outputResponse.output = "TERMPOLL CLCK";
                    this.timeoutWait();
                    this.sendByte(195);
                    this.setClock();
                    break;
                }
                if (c != 90) break;
                if (this.moreDebug) {
                    Debug.log(2, "CM11A(READY): CM11A requesting to upload input.");
                }
                this.iState = 1;
                this.outputResponse = new BooleanWrapper(this, false);
                this.outputResponse.output = "TERMPOLL RECV";
                this.timeoutWait();
                this.sendByte(195);
                break;
            }
            case 1: {
                if (this.moreDebug) {
                    Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("CM11A(POLL): Preparing to receive ").append(c).append(" bytes."))));
                }
                this.bInBytes = new int[c];
                this.iCurrent = 0;
                this.iState = 2;
                break;
            }
            case 2: {
                if (this.iCurrent < this.bInBytes.length) {
                    this.bInBytes[this.iCurrent] = c;
                    ++this.iCurrent;
                }
                if (this.iCurrent != this.bInBytes.length) break;
                if (this.moreDebug) {
                    Debug.log(2, "CM11A(RECEIVE): Received all bytes.  Decoding input.");
                }
                this.decodeBytes();
                this.iState = 0;
                this.resend();
                break;
            }
            case 9: {
                if (c == (this.iChecksum & 0xFF)) {
                    if (this.moreDebug) {
                        Debug.log(2, "CM11A(SEND): Received correct checksum.");
                    }
                    this.iState = 10;
                    this.outputResponse.b = true;
                    this.sendByte(0);
                    break;
                }
                if (c == 90 || c == 165) {
                    if (this.moreDebug) {
                        Debug.log(2, "CM11A(SEND): CM11A not ready.  Requeueing output.  Entering ready state.");
                    }
                    this.requeue.put(this.bOutBytes);
                    this.iState = 0;
                    this.nextInByte(c);
                    break;
                }
                if (this.moreDebug) {
                    Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("CM11A(SEND): Received incorrect checksum.  Expecting ").append(Debug.hexByte((byte)(this.iChecksum & 0xFF))).append(".  Resending."))));
                }
                this.iState = 9;
                this.iChecksum = 0;
                this.outputResponse.b = true;
                this.outputResponse = new BooleanWrapper(this, false);
                this.outputResponse.output = "RESEND";
                this.timeoutWait();
                this.sendBytes(this.bOutBytes);
                break;
            }
            case 10: {
                if (c == 85) {
                    if (this.moreDebug) {
                        Debug.log(2, "CM11A(ACK): Ok acknowledment received.");
                    }
                    this.iState = 0;
                    this.resend();
                    break;
                }
                if (c == 90 || c == 165) {
                    if (this.moreDebug) {
                        Debug.log(2, "CM11A(SEND): CM11A never sent Ok.  Entering ready state.");
                    }
                    this.iState = 0;
                    this.nextInByte(c);
                    break;
                }
                if (this.moreDebug) {
                    Debug.log(2, "CM11A(ACK): Incorrect acknowledgement received.");
                }
                this.iState = 10;
            }
        }
    }

    private void decodeBytes() {
        int mask = 1;
        int fcount = 0;
        char housecode = '\u0000';
        int func = 0;
        int dims = 0;
        int device = 0;
        int b1 = 0;
        int b2 = 0;
        if (this.bInBytes != null) {
            int count = this.bInBytes.length;
            int data = this.bInBytes[this.bInBytes.length - count];
            --count;
            while (count != 0) {
                int cb = this.bInBytes[this.bInBytes.length - count];
                housecode = X10Data.byteToHouseCode((byte)(cb >> 4 & 0xF));
                if ((data & mask) != 0) {
                    func = cb & 0xF;
                    if (func == 4 || func == 5 || func == 10 || func == 11) {
                        mask <<= 1;
                        cb = this.bInBytes[this.bInBytes.length - --count];
                        dims = cb * 100 / 212;
                    } else if (func == 7) {
                        b1 = this.bInBytes[this.bInBytes.length - count];
                        b2 = this.bInBytes[this.bInBytes.length - count];
                        mask <<= 2;
                        count -= 2;
                    }
                    ValueNumber dimValue = null;
                    if (dims != 0) {
                        dimValue = new ValueNumber(dims);
                    }
                    this.inputReceived(new X10functionPacket(new ValueX10(housecode, 0), new ValueCommand(func), dimValue));
                } else {
                    device = X10Data.byteToDeviceCode((byte)(cb & 0xF));
                    this.inputReceived(new X10addressPacket(new ValueX10(housecode, device)));
                }
                mask <<= 1;
                --count;
                ++fcount;
            }
        }
        this.bInBytes = null;
    }

    static {
        ST_READY = 0;
        ST_POLL = 1;
        ST_RECEIVE = 2;
        ST_TIMERDOWNLOAD = 3;
        ST_ENABLERING = 4;
        ST_DISABLERING = 5;
        ST_EEPROMMACRODOWNLOAD = 6;
        ST_EXTENDED = 7;
        ST_STANDARD = 8;
        ST_SEND = 9;
        ST_ACK = 10;
        ST_POWERFAIL = 11;
    }

    class BooleanWrapper {
        boolean b;
        String output = "";

        BooleanWrapper(CM11AGateway this$0, boolean b) {
            this.b = b;
        }
    }
}

