/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command.Function;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.Interface.Gateway.TCPGateway;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueType;
import java.net.InetAddress;
import java.util.ArrayList;

public class TcpconnectCommand
extends FuncCommand {
    public ValueType execute(EnvironmentSmall env) {
        super.execute(env);
        SystemModel m = env.getSystemModel();
        if ((this.getNumParams() == 0 || this.getNumParams() == 2) && m != null) {
            if (this.getNumParams() == 2) {
                ValueString ip = this.getStringParam(0);
                ValueNumber port = this.getNumberParam(0);
                ArrayList g = m.getInputGateways();
                int size = g.size();
                for (int i = 0; i < size; ++i) {
                    Object o = g.get(i);
                    if (!(o instanceof TCPGateway)) continue;
                    TCPGateway t = (TCPGateway)o;
                    Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("Attempting to connect to ").append(ip.getString()).append(" on port ").append(port.getNumber()).append("..."))));
                    try {
                        t.connect(InetAddress.getByName(ip.getString()), port.getNumber());
                        continue;
                    }
                    catch (Exception e) {
                        Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Unable to create connection to ").append(ip.getString()).append("."))));
                    }
                }
            } else if (this.getNumParams() == 0) {
                ArrayList g = m.getInputGateways();
                int size = g.size();
                for (int i = 0; i < size; ++i) {
                    Object o = g.get(i);
                    if (!(o instanceof TCPGateway)) continue;
                    TCPGateway t = (TCPGateway)o;
                    t.autoConnectThread();
                }
            }
        } else {
            Debug.error(100, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting none or 2 parameters for ").append(this.toString()).append("."))));
        }
        return null;
    }
}

