
/*
 * Copyright (c) 1998, 1999 Semiotek Inc. All Rights Reserved.
 *
 * This software is the confidential intellectual property of
 * of Semiotek Inc.; it is copyrighted and licensed, not sold.
 * You may use it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation. If you 
 * do not want to use the GPL, you may still use the software after
 * purchasing a proprietary developers license from Semiotek Inc.
 *
 * This software is provided "as is", with NO WARRANTY, not even the 
 * implied warranties of fitness to purpose, or merchantability. You
 * assume all risks and liabilities associated with its use.
 *
 * See the attached License.html file for details, or contact us
 * by e-mail at info@semiotek.com to get a copy.
 */


package org.webmacro.resource;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Enumeration;
import java.security.MessageDigest;
import org.webmacro.util.*;

/**
  * Represents a web user. You do not normally create user objects 
  * directly, instead you get them from a UserDB. A user is a place
  * to store objects related to a particular user, so it has a 
  * dictionary like API.
  */
public interface User
{

   /**
     * Set this users password to the submitted string. Setting a users 
     * password to null prevents them from being authenticated.
     */
   public void setPassword(String password);

   /**
     * Get the name of this user. When the UserDB (or ResourceBroker)
     * requests a user, this is the string that is used to retrieve 
     * the correct User object. It should be a short identifying 
     * string, although there is no inherent length limitation.
     */
   public String getName();

   /**
     * Check whether the supplied authorization key authenticates
     * this user or not. In the current implementation it checks 
     * whether a digest of the authKey matches a digest of the 
     * authKey originally used to create the user.
     */
   public boolean authenticate(String authKey);

   /**
     * Get an enumeration of the elements stored in this User
     */
   public Enumeration elements();

   /**
     * Get an object stored in this user's storage area
     */
   public Object get(String key);

   /**
     * Store an object in the user's storage area
     */
   public Object put(String key, Object value);

   /**
     * Remove an object from the user's storage area
     */
   public Object remove(String key);

   /**
     * How many objects are stored in the user?
     */
   public int size() ;

   /**
     * Are there any object stored in the user?
     */
   public boolean isEmpty();

   /**
     * Return a string representation of this user suitable for debugging
     */
   public String toString();


}
