/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Observable;
import java.util.Observer;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceRevokedException;
import org.webmacro.broker.ResourceUnavailableException;
import org.webmacro.util.InvalidArgumentException;

public abstract class ResourceEvent
extends EventObject
implements Observer,
PropertyChangeListener {
    private final String type;
    private final String name;
    private Object resource;
    private boolean valid = true;
    private boolean notfound = true;
    boolean deleted = false;
    boolean accessed = true;

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized void set(Object object) throws ResourceRevokedException, InvalidArgumentException {
        this.accessed = true;
        if (object == null) {
            throw new InvalidArgumentException("Cannot set to null value");
        }
        if (!this.valid || this.resource != null) {
            throw new ResourceRevokedException(this + " has been revoked: " + this.resource);
        }
        this.notfound = false;
        this.resource = object;
        this.notifyAll();
    }

    final synchronized void revoke(String string) {
        this.valid = false;
        this.resource = string;
        this.notifyAll();
    }

    public final void update() {
        this.accessed = true;
    }

    public final void update(Observable observable, Object object) {
        this.accessed = true;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.accessed = true;
    }

    public final String toString() {
        return "Resource[" + this.type + ", " + this.name + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized Object getValue() throws ResourceRevokedException, ResourceUnavailableException {
        block6: {
            this.accessed = true;
            try {
                if (!this.valid || this.resource != null) break block6;
                ResourceBroker resourceBroker = (ResourceBroker)this.getSource();
                resourceBroker.blocked(this);
                while (true) {
                    if (!this.valid || this.resource != null) {
                        this.accessed = true;
                        break;
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
        }
        if (this.valid) {
            return this.resource;
        }
        if (this.notfound) {
            throw new ResourceUnavailableException(this + " not found: " + this.resource);
        }
        throw new ResourceRevokedException(this + " has been revoked: " + this.resource);
    }

    public final boolean isAvailable() {
        return this.valid && this.resource != null;
    }

    public final boolean isRevoked() {
        return !this.valid;
    }

    public final boolean isSettable() {
        return this.valid && this.resource == null;
    }

    abstract void providerSet(ResourceProvider var1) throws ResourceUnavailableException, InterruptedException;

    void providerSave(ResourceProvider resourceProvider) {
        resourceProvider.resourceSave(this);
    }

    protected ResourceEvent(ResourceBroker resourceBroker, String string, String string2, Object object) throws InvalidArgumentException {
        super(resourceBroker);
        this.type = string.intern();
        this.name = string2.intern();
        this.resource = object;
        if (object == null || string == null || string2 == null || resourceBroker == null) {
            throw new InvalidArgumentException("Arguments cannot be null.");
        }
    }

    ResourceEvent(ResourceBroker resourceBroker, String string, String string2) throws InvalidArgumentException {
        super(resourceBroker);
        this.type = string.intern();
        this.name = string2.intern();
        this.resource = null;
        if (string == null || string2 == null || resourceBroker == null) {
            throw new InvalidArgumentException("Arguments cannot be null.");
        }
    }
}

