package com.unipro.products.smgui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class represents "Settings" dialog. It is used to manage SMS Manager settings.
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class PortSettingsDialog
    extends JDialog {
    JPanel rootPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel contentPanel = new JPanel();
    JPanel buttonsPanel = new JPanel();
    JComboBox portName = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JComboBox portBaud = new JComboBox();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public PortSettingsDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            jbInit();
            pack();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PortSettingsDialog() {
        this(null, "", false);
    }

    private void jbInit() throws Exception {
        rootPanel.setLayout(borderLayout1);
        buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        buttonsPanel.setMinimumSize(new Dimension(0, 40));
        buttonsPanel.setPreferredSize(new Dimension(0, 40));
        buttonsPanel.setLayout(null);
        contentPanel.setBorder(BorderFactory.createEtchedBorder());
        contentPanel.setLayout(gridBagLayout1);
        this.setResizable(false);
        this.setTitle("Port settings");
        jLabel1.setText("COM-port");
        jLabel2.setText("Baud rate");

        portName.setMinimumSize(new Dimension(70, 21));
        portName.setPreferredSize(new Dimension(70, 21));

        String currentPortName = SMGUIApplication.settings.getPortName();
        for (int i = 0; i < Settings.PORT_NAMES.length; i++) {
            portName.addItem(Settings.PORT_NAMES[i]);
            if (Settings.PORT_NAMES[i].equals(currentPortName)) {
                portName.setSelectedItem(Settings.PORT_NAMES[i]);
            }
        }

        portBaud.setMinimumSize(new Dimension(70, 21));
        portBaud.setPreferredSize(new Dimension(70, 21));
        String currentPortBaud = SMGUIApplication.settings.getPortBaud();
        for (int i = 0; i < Settings.PORT_BAUDS.length; i++) {
            String baud = Settings.PORT_BAUDS[i];
            portBaud.addItem(baud);
            if (baud.equals(currentPortBaud)) {
                portBaud.setSelectedItem(baud);
            }
        }

        okButton.setBounds(new Rectangle(69, 9, 85, 25));
        okButton.setText("Connect");
        okButton.addActionListener(new SettingsDialog_okButton_actionAdapter(this));
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new
            SettingsDialog_cancelButton_actionAdapter(this));
        cancelButton.setBounds(new Rectangle(159, 9, 73, 25));
        getContentPane().add(rootPanel);
        rootPanel.add(contentPanel, BorderLayout.CENTER);
        contentPanel.add(portName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL,
            new Insets(5, 0, 0, 100), 0, 0));
        rootPanel.add(buttonsPanel, BorderLayout.SOUTH);
        buttonsPanel.add(okButton, null);
        buttonsPanel.add(cancelButton, null);
        contentPanel.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            , GridBagConstraints.WEST, GridBagConstraints.NONE,
            new Insets(5, 29, 0, 38), 0, 0));
        contentPanel.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            , GridBagConstraints.WEST, GridBagConstraints.NONE,
            new Insets(12, 29, 3, 37), 0, 0));
        contentPanel.add(portBaud, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            , GridBagConstraints.WEST, GridBagConstraints.NONE,
            new Insets(12, 2, 0, 98), 0, 0));
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        dispose();
    }

    void okButton_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setPortName( (String)this.portName.
                                              getSelectedItem());
        SMGUIApplication.settings.setPortBaud( (String)this.portBaud.
                                              getSelectedItem());
        this.setCursor(new Cursor(Cursor.WAIT_CURSOR));
        try {
            SMGUIApplication.refreshSMSManager();

            dispose();
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(),
                                          "Error",
                                          JOptionPane.ERROR_MESSAGE);
        } finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

}

class SettingsDialog_cancelButton_actionAdapter
    implements java.awt.event.ActionListener {
    PortSettingsDialog adaptee;

    SettingsDialog_cancelButton_actionAdapter(PortSettingsDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.cancelButton_actionPerformed(e);
    }
}

class SettingsDialog_okButton_actionAdapter
    implements java.awt.event.ActionListener {
    PortSettingsDialog adaptee;

    SettingsDialog_okButton_actionAdapter(PortSettingsDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.okButton_actionPerformed(e);
    }
}