package com.unipro.products.smgui;

import java.io.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import edu.stanford.ejalbert.*;

/**
 * This class represents "About" dialog. It shows the author name and other info.
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class MainFrame_AboutBox
    extends JDialog
    implements ActionListener {

    JPanel panel1 = new JPanel();
    JPanel panel2 = new JPanel();
    JPanel insetsPanel1 = new JPanel();
    JPanel insetsPanel2 = new JPanel();
    JPanel insetsPanel3 = new JPanel();
    JButton button1 = new JButton();
    JLabel imageLabel = new JLabel();
    JLabel label1 = new JLabel();
    JLabel label2 = new JLabel();
    JLabel label3 = new JLabel();
    JLabel label4 = new JLabel();
    ImageIcon image1 = new ImageIcon();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    GridLayout gridLayout1 = new GridLayout();
    String product = "";
    String version = "Version: " + SMGUIApplication.APPLICATION_VERSION;
    String copyright = "Copyright (c) 2003";
    String comments = "";
    JLabel label5 = new JLabel();
    //JLabel label6 = new JLabel();
    public MainFrame_AboutBox(Frame parent) {
        super(parent);
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //Component initialization
    private void jbInit() throws Exception {
        image1 = new ImageIcon(com.unipro.products.smgui.MainFrame.class.
                               getResource("unipro-logo.gif"));
        imageLabel.setIcon(image1);
        this.setTitle("About");
        panel1.setLayout(borderLayout1);
        panel2.setLayout(borderLayout2);
        insetsPanel1.setLayout(flowLayout1);
        insetsPanel2.setLayout(flowLayout1);
        insetsPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gridLayout1.setRows(6);
        gridLayout1.setColumns(1);
        label1.setText("<html>Author: <b>UniPro Mobiles</b></html>");
        label2.setAlignmentX((float) 0.0);
        label2.setText(version);
        label3.setText(copyright);
        label4.setToolTipText("Visit our site");
        label4.setText(
            "<html><a href=''>" + SMGUIApplication.MOBILES_URL + "</a></html>");
        label4.addMouseListener(new MainFrame_AboutBox_label4_mouseAdapter(this));
        insetsPanel3.setLayout(gridLayout1);
        insetsPanel3.setBorder(BorderFactory.createEmptyBorder(10, 60, 10, 10));
        button1.setText("Ok");
        button1.addActionListener(this);
        label5.setText("This application is supplied with SMlib.");
        //label6.setText("<html>Programming: <a href=''>Alexey Skorokhodov</a></html>");
        //label6.addMouseListener(new MainFrame_AboutBox_label6_mouseAdapter(this));
        //label6.setToolTipText("Write me :)   alskor@nbsp.nsk.su");
        //label6.setAlignmentX((float) 0.0);
        insetsPanel2.add(imageLabel, null);
        panel2.add(insetsPanel2, BorderLayout.WEST);
        this.getContentPane().add(panel1, null);
    insetsPanel3.add(label5, null);
        insetsPanel3.add(label1, null);
    insetsPanel3.add(label4, null);
        //insetsPanel3.add(label6, null);
        insetsPanel3.add(label2, null);
        insetsPanel3.add(label3, null);
        panel2.add(insetsPanel3, BorderLayout.CENTER);
        insetsPanel1.add(button1, null);
        panel1.add(insetsPanel1, BorderLayout.SOUTH);
        panel1.add(panel2, BorderLayout.NORTH);
        setResizable(true);
    }

    //Overridden so we can exit when window is closed
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            cancel();
        }
        super.processWindowEvent(e);
    }

    //Close the dialog
    void cancel() {
        dispose();
    }

    //Close the dialog on a button event
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == button1) {
            cancel();
        }
    }

    void label4_mouseClicked(MouseEvent e) {
        try {
            BrowserLauncher.openURL(SMGUIApplication.MOBILES_URL);
        } catch (IOException ex) {
            System.err.println(ex);
        }
    }

    void label4_mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(Cursor.HAND_CURSOR));
    }

    void label4_mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }

    void label1_mouseClicked(MouseEvent e) {
        try {
            BrowserLauncher.openURL("mailto:alskor@nbsp.nsk.su");
        } catch (IOException ex) {
            System.err.println(ex);
        }
    }

    void label1_mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(Cursor.HAND_CURSOR));
    }

    void label1_mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }
}

class MainFrame_AboutBox_label4_mouseAdapter
    extends java.awt.event.MouseAdapter {
    MainFrame_AboutBox adaptee;

    MainFrame_AboutBox_label4_mouseAdapter(MainFrame_AboutBox adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseClicked(MouseEvent e) {
        adaptee.label4_mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        adaptee.label4_mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        adaptee.label4_mouseExited(e);
    }
}

class MainFrame_AboutBox_label6_mouseAdapter
    extends java.awt.event.MouseAdapter {
    MainFrame_AboutBox adaptee;

    MainFrame_AboutBox_label6_mouseAdapter(MainFrame_AboutBox adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseClicked(MouseEvent e) {
        adaptee.label1_mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        adaptee.label1_mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        adaptee.label1_mouseExited(e);
    }
}