/*
 * Decompiled with CFR 0.152.
 */
package installator;

import installator.InstallatorParameters;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InstallatorData {
    private static final char jarsSeparator = ';';
    public String jdkPath = null;
    public String homePath = String.valueOf(String.valueOf(new StringBuffer("C:").append(File.separator).append("SMLib")));
    public String jarPath = String.valueOf(String.valueOf(new StringBuffer("C:").append(File.separator).append("SMLib")));
    public String docPath = String.valueOf(String.valueOf(new StringBuffer("C:").append(File.separator).append("SMLib").append(File.separator).append("doc")));
    public String guiPath = String.valueOf(String.valueOf(new StringBuffer("C:").append(File.separator).append("SMLib").append(File.separator).append("gui")));
    public String errorMessage = "";
    public InstallatorParameters p = null;

    public InstallatorData(InstallatorParameters installatorParameters) {
        this.p = installatorParameters;
    }

    private boolean checkJDK(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            this.errorMessage = " Choosen JDK directory does not exist ";
            return false;
        }
        File file2 = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("jre").append(File.separator).append("lib"))));
        File file3 = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("jre").append(File.separator).append("bin"))));
        if (!file2.isDirectory() || !file3.isDirectory()) {
            this.errorMessage = " Choosen JDK directory does not appropriate for installation java COMM API ";
            return false;
        }
        return true;
    }

    public boolean installCommAPI() {
        if (this.jdkPath == null) {
            return false;
        }
        if (!this.checkJDK(this.jdkPath)) {
            return false;
        }
        if (!this.copyFileToDir(InstallatorParameters.commJar(), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.jdkPath))).append(File.separator).append("jre").append(File.separator).append("lib").append(File.separator).append("ext"))))) {
            return false;
        }
        if (!this.copyFileToDir(InstallatorParameters.commJavax(), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.jdkPath))).append(File.separator).append("jre").append(File.separator).append("lib"))))) {
            return false;
        }
        return this.copyFileToDir(InstallatorParameters.commDll(), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.jdkPath))).append(File.separator).append("jre").append(File.separator).append("bin"))));
    }

    public boolean installJar() {
        if (this.p == null) {
            return false;
        }
        String string = InstallatorParameters.getJar();
        if (!this.copyFileToDir(string, this.jarPath)) {
            return false;
        }
        String string2 = InstallatorParameters.getReadme();
        return this.copyFileToDir(string2, this.jarPath);
    }

    public boolean installDoc() {
        if (this.p == null) {
            return false;
        }
        String string = InstallatorParameters.getDoc();
        return this.copyDirToDir(string, this.docPath);
    }

    public boolean installGui() {
        if (this.p == null) {
            return false;
        }
        String string = InstallatorParameters.getGui();
        return this.copyFileToDir(string, this.guiPath);
    }

    public boolean writeBat() {
        String string = InstallatorParameters.getGuiBat();
        string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.guiPath))).append(File.separator).append(string)));
        String string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.jdkPath))).append(File.separator).append("bin").append(File.separator).append("java")));
        String string3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.guiPath))).append(File.separator).append("SMGUI.jar").append(';').append(this.jdkPath).append(File.separator).append("jre").append(File.separator).append("lib").append(File.separator).append("ext").append(File.separator).append("comm.jar").append(';').append(this.jarPath).append("smlib.jar")));
        if (this.jdkPath.indexOf(32) != -1) {
            string2 = String.valueOf(String.valueOf(new StringBuffer("\"").append(string2).append("\"")));
        }
        if (this.guiPath.indexOf(32) != -1 || this.jarPath.indexOf(32) != -1 || this.jdkPath.indexOf(32) != -1) {
            string3 = String.valueOf(String.valueOf(new StringBuffer("\"").append(string3).append("\"")));
        }
        String string4 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(" -cp ").append(string3).append(" com.unipro.products.smgui.SMGUIApplication")));
        try {
            FileWriter fileWriter = new FileWriter(string, false);
            fileWriter.write(string4);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            this.errorMessage = " I/O exception occurs ";
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private boolean copyFileToDir(String string, String string2) {
        if (string == null || string2 == null) {
            this.errorMessage = " Name is null ";
            return false;
        }
        File file = new File(string);
        if (!file.isFile()) {
            this.errorMessage = " There is no such file ".concat(String.valueOf(String.valueOf(string)));
            return false;
        }
        File file2 = new File(string2);
        if (!file2.isDirectory() && !file2.mkdirs()) {
            this.errorMessage = " Can not create directory ".concat(String.valueOf(String.valueOf(string2)));
            return false;
        }
        File file3 = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file2.getAbsolutePath()))).append(File.separator).append(file.getName()))));
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3.getAbsolutePath(), false));
            FileReader fileReader = new FileReader(file);
            while (((InputStream)bufferedInputStream).available() > 0) {
                ((OutputStream)bufferedOutputStream).write(((InputStream)bufferedInputStream).read());
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.errorMessage = " I/O exception occurs ";
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private boolean copyDirToDir(String string, String string2) {
        if (string == null || string2 == null) {
            this.errorMessage = " Name is null ";
            return false;
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.isDirectory()) {
            this.errorMessage = " There is no such directory ".concat(String.valueOf(String.valueOf(string)));
            return false;
        }
        if (!file2.isDirectory() && !file2.mkdirs()) {
            this.errorMessage = " Can not create directory ".concat(String.valueOf(String.valueOf(string2)));
            return false;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                String string3 = file3.getName();
                this.copyDirToDir(file3.getAbsolutePath(), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file2.getAbsolutePath()))).append(File.separator).append(string3))));
                continue;
            }
            if (!file3.isFile()) continue;
            this.copyFileToDir(file3.getAbsolutePath(), file2.getAbsolutePath());
        }
        return true;
    }

    static {
        jarsSeparator = (char)59;
    }
}

