/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagDATE: will output the actual date
 *              You can add or substract (+ or -) any date like 
 *              minute (mi), hour (hh), day (dd), month (mm) or year (yy)
 * 
 * History: - Creation nh
 *          - Added more functionality
 *
 * @author nh
 * @version 1.2
 * @see PRePMain, TagList, PRePTag, PRePTagCode
 */
package com.delec.prep;
import java.io.*;
import java.util.*;

public class PRePTagDATE extends PRePTagCode
{
	/**
	 * value of the tag
	 */
	String value;

	/**
	 * Constructor 
	 */
	public PRePTagDATE()
	{
		super("DATE");
	}

	/**
	 * @param Session contains TagList and PrintWriter
	 */
	public void compile(Session session)
	{
		Date date = new Date();
		Calendar calendar = Calendar.getInstance();
		PRePTag tagNewValue = session.getTagList().find("ARG1");
		String strNewValue;
		PrintWriter pWriter = session.getPrintWriter();

		if ( tagNewValue != null )
		{
			strNewValue = tagNewValue.getValue();
			String strPattern = "";
			char chIndex;
			int iDigit = 0;
			String strDigit = "";
			boolean bAdd = true;
			int iState = 1;
			for ( int i = 0; i  < strNewValue.length(); i++ )
			{
				chIndex = strNewValue.charAt(i);
				switch ( iState )
				{
					case 1:
						switch ( chIndex )
						{
							case '+':
								bAdd = true;
								iState = 2;
								break;
							case '-':
								bAdd = false;
								iState = 2;
								break;
							default:
								strPattern = strPattern+chIndex;
								iState = 2;
								break;
						}
						break;
					case 2:
						if ( strPattern.length() < 2 )
						{
							strPattern = strPattern+chIndex;
							iState = 2;
						}
						else
						{
							strDigit = strDigit+chIndex;
							iState = 3;
						}
						break;
					case 3:
						strDigit = strDigit+chIndex;
						iState = 3;
						break;
					default:
						session.getExceptionList().addElement(new PRePException(this, "DATE-TAG not valid!"));
						break;
				}
			}

			calendar.setTime(date);

			try
			{
				Integer integer = new Integer(strDigit);      

				iDigit = integer.intValue();
				if ( bAdd )
				{
					if ( strPattern.equals("mi") )
					{
						calendar.add(Calendar.MINUTE, iDigit);
					}
					else if ( strPattern.equals("hh") )
					{
						calendar.add(Calendar.HOUR, iDigit);
					}
					else if ( strPattern.equals("dd") )
					{
						calendar.add(Calendar.DATE, iDigit);
					}
					else if ( strPattern.equals("mm") )
					{
						calendar.add(Calendar.MONTH, iDigit);
					}
					else if ( strPattern.equals("yy") )
					{
						calendar.add(Calendar.YEAR, iDigit);
					}
					else
					{
						session.getExceptionList().addElement(new PRePException(this, "date not valid"));
					}
				}
				else
				{
					if ( strPattern.equals("mi") )
					{
						calendar.add(Calendar.MINUTE, -iDigit);
					}
					else if ( strPattern.equals("hh") )
					{
						calendar.add(Calendar.HOUR, -iDigit);
					}
					else if ( strPattern.equals("dd") )
					{
						calendar.add(Calendar.DATE, -iDigit);
					}
					else if ( strPattern.equals("mm") )
					{
						calendar.add(Calendar.MONTH, -iDigit);
					}
					else if ( strPattern.equals("yy") )
					{
						calendar.add(Calendar.YEAR, -iDigit);
					}
					else
					{
						session.getExceptionList().addElement(new PRePException(this, "date not valid"));
					}
				}
			}
			catch ( Exception e )
			{
			}
			date = calendar.getTime();
			pWriter.print(date.toString());
			pWriter.flush();
		}
		else
		{
			pWriter.print(date.toString());
			pWriter.flush();
		}
	}
}

