/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
* PReP Version 1.0
*
* PRePMain: Main class of the PReP. 
*           defines the TagList, gets the file(s) and sets the PrintWriter.
*
* History: - Creation nh
*
* @author nh
* @version 1.0
*/
package com.delec.prep;
import java.io.*;
import com.delec.global.dbms.*;

public class PRePMain
{
	protected PRePTagText tag;
	protected Session session;
	protected SQLServe sqlServe = new SQLServe();
	protected static ConnectionPool cp = null;


	/**
	 * Constructor without an argument which defines a new TagList
	 */
	public PRePMain()
	{
		session = new Session();
		session.setPRePMain(this);
	}

	/**
	 * set the PrintWriter
	 * @param PrintWriter specified PrintWriter
	 */
	public void setWriter(PrintWriter pwriter)
	{
		session.setPrintWriter(pwriter);
	}

	public SQLServe getSQLServe()
	{
		return sqlServe;
	}

	public Session getSession()
	{
		return session;
	}

	public void setSQLServe(SQLServe sqlServe)
	{
		this.sqlServe = sqlServe;
	}

	public void setSession(Session session)
	{
		this.session = session;
	}


	/**
	 * checks wheter the first String as argument is null and the line begins
	 * with the second argument
	 * @param String a line of the specified file
	 * @param String the string the line is compared to
	 * @return true if the first argument is not null and begins with the
	 *         second argument
	 */
	protected boolean isOk(String strLine, String strAsked)
	{
		boolean boOk = false;
		if ( strLine == null )
		{
			boOk = false;
		}
		else if ( strLine.startsWith(strAsked) )
		{
			boOk = true;
		}
		else
		{
			boOk = false;
		}
		return boOk;
	}
	/**
	 * gets the next line from the defined file
	 * @param BufferedReader 
	 * @return the next line
	 */
	protected String getNextLine(BufferedReader bReader)
	{
		PRePPreparse pPreparse = new PRePPreparse();

		//PREPARSE

		String strLine = pPreparse.preparse(bReader);
		return strLine;
	}
	/**
	 * gets the file which is specified with the argument
	 * @param String name of the file
	 * @return null if the file does not exist
	 */
	protected File getFile(String strArg)
	{

		//System.out.println("get file "+strArg);

		PRePTagText ptt = new PRePTagText("dummy");
		ptt.setValue(strArg.substring(1));

		StringWriter sw = new StringWriter();
		PrintWriter oldPW = session.getPrintWriter();

		session.setPrintWriter(new PrintWriter(sw));

		ptt.compile(session);

		String strFileName = sw.toString();

		session.setPrintWriter(oldPW);

		return new File(strFileName);

	}
	/**
	 * gets names and values from the file
	 * @param File
	 */
	public void putFile(File file)
	{

		FileReader fReader = null;
		BufferedReader bReader = null;
		try
		{
			fReader = new FileReader(file);

			bReader = new BufferedReader(fReader);

			if ( fReader == null || bReader == null )
			{
				System.out.println("File is null: "+file.toString());
			}

			String strLine = getNextLine(bReader);

			while ( strLine.equals("") )
			{
				strLine = getNextLine(bReader);
			}

			boolean ok = isOk(strLine, "#");

			while ( ok )
			{
				File newFile = getFile(strLine);
				putFile(newFile);
				strLine = getNextLine(bReader);
				ok = isOk(strLine, "#");
			}

			ok = isOk(strLine, "*");
			String name = "";
			String value = null;

			while ( strLine != null )
			{

				if ( strLine.startsWith("*") )
				{
					name = strLine.substring(1);
					name = name.trim()+'\r'+'\n';
					strLine = getNextLine(bReader);
					value = "";
					try
					{
						boolean bStart = true;
						while ( strLine != null && !strLine.startsWith("*") )
						{
							if ( bStart )
							{
								bStart = false;
							}
							else
							{
								value += "\r\n";
							}
							value+= strLine;
							strLine = getNextLine(bReader);
						}
					}
					catch ( Exception e )
					{
						session.getExceptionList().addElement(new PRePException(this, "'failed to get the next line from the reader'"+e));
					}
					if ( value.trim() != null && value.trim() != "" )
					{
						putField(name, value);  
					}
				}
				else
				{
					strLine = getNextLine(bReader);
				}       
				ok = isOk(strLine, "*");
			}
			bReader.close();
			fReader.close();
		}
		catch ( Exception e )
		{
			session.getExceptionList().addElement(new PRePException(this, "'failed to create a new reader: '"+file.toString()+" "+e));
		}
	}
	/**
	 * gets a name and a value from somewhere else (commandline e.g.),
	 * creates a tag and stores it in the TagList
	 * @param String name of the tag
	 * @param String value of the tag 
	 */
	public void putField(String name, String value)
	{
		tag = new PRePTagText(name);
		tag.setValue(value);
		session.getTagList().addElement(tag);
	}

	/**
	 * sets the connection to the specified database with the given
	 * informations
	 * @param String database driver
	 * @param String URL
	 * @param String username
	 * @param String password
	 */
	public void setDatabaseConnection(String strJDBCDRIVER, String strURL, String strDBUSER, String strDBPWD) 
	{

		/*SQLServe sqlserveDummy = session.getSQLServe();
	 
		if (sqlserveDummy == null) // no SQLServe set in session
		  {
			session.setSQLServe(sqlServe);
		  }
	 */
		if ( cp == null )
		{

			cp = (ConnectionPool)session.get(ConnectionPool.SESSION_NAME);

			if ( cp == null )
			{
				cp = new ConnectionPool();
				try
				{
					cp.initialize(strJDBCDRIVER, strURL, strDBUSER, strDBPWD);
				}
				catch ( Exception e )
				{
					System.out.println("Exception occurred while initialising cp: "+e);
				}
				session.put(ConnectionPool.SESSION_NAME, cp);
			}
		}
		else
		{
			session.remove(ConnectionPool.SESSION_NAME);
			session.put(ConnectionPool.SESSION_NAME, cp);
		}
	}

	/**
	 * compiles the TagList in the specified PrintWriter
	 * @param PrintWriter 
	 */
	public void output(PrintWriter pwClient)
	{
		setWriter(pwClient);
		output();
	}

	/**
	 * compiles the TagList in the specified PrintWriter
	 */
	public void output()
	{
		session.getTagList().compile("__TEMPLATE__", session);
	}

	/** get the value of a tag from the tag list
	 * @param String the name of the Tag
	 * @return String the value of the requested tag or <em>null</em> if tag does not exist
	  */
	public String getValue(String strTagName)
	{
		PRePTag tag = session.getTagList().find(strTagName);
		if ( tag == null )
		{
			return null;
		}
		return tag.getValue();
	}

	/** add a prep tag to the tag list.
	**/
	public void putField(PRePTag pt)
	{
		session.getTagList().addElement(pt);
	}

	public void destroy()
	{
		session = null;
		sqlServe = null;
	}
}

