/*
 * Decompiled with CFR 0.152.
 */
package com.kashif.utils;

import com.kashif.utils.ArgumentParser;
import com.kashif.utils.BadArgumentsException;
import com.kashif.utils.CheckPath;
import com.kashif.utils.KWhereFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class KWhere {
    private static ArgumentParser parser = null;
    public static final double VERSION_NUM = 2.0;
    public static final int MIN_ARGS_LENGTH = 1;
    public static final int MAX_ARGS_LENGTH = 5;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String ARG_HELP = "-h";
    public static final String ARG_VERSION = "-v";
    public static final String ARG_PREPEND_CLASSPATH = "-cp";
    public static final String ARG_PRINT_CLASSPATH = "-p";
    public static final String ARG_VERIFY_CLASSPATH = "-verify";
    public static final String ARG_CHECK_DUPLICATES = "-dup";
    public static final String ARG_SEARCH_PROPERTYFILES = "-prop";
    public final long MODE_NORMAL_SEARCH = 0L;
    public final long MODE_PACKAGE_SEARCH = 1L;
    public final long MODE_SEARCH = 16L;
    public final long MODE_VERIFY_CLASSPATH = 256L;
    public final long MODE_CHECK_DUPLICATES = 4096L;
    public final long MODE_VERSION = 65536L;
    public final long MODE_HELP = 0x100000L;
    public final long MODE_PRINT_CLASSPATH = 0x1000000L;
    public final long MODE_PREPEND_CLASSPATH = 0x10000000L;
    public final long MODE_SEARCH_PROPERTYFILES = 0x100000000L;
    public final String EXTENSION_JAVA_CLASS_FILE = ".class";
    public final String EXTENSION_JAVA_PROPERTIES_FILE = ".properties";
    public final String EXTENSION_ZIP_FILE = ".zip";
    public final String EXTENSION_JAR_FILE = ".jar";
    public static Vector classFilesList = new Vector();
    private long mode = 0L;
    private String searchFileName = null;
    private String searchFileExtension = null;
    private boolean isFound = false;

    private boolean isPropertiesFile(File file) {
        String fileName = file.getAbsolutePath();
        int index = fileName.lastIndexOf(".");
        String extension = fileName.substring(index);
        return ".properties".equals(extension);
    }

    public void setSearchFileName(String o) {
        this.searchFileName = o;
    }

    public String getSearchFileName() {
        return this.searchFileName;
    }

    public void setSearchFileExtension(String o) {
        this.searchFileExtension = o;
    }

    private static void usage() {
        System.out.println("Usage --> KWhere [-h] [-v] [-prop fileName] [-cp classPath or -p [-verify] [-dup]] [fileName]");
        KWhere.exit();
    }

    public String getSearchFileExtension() {
        return this.searchFileExtension;
    }

    private void search(String className, File file) {
        if (file.isDirectory()) {
            String[] list = file.list(new KWhereFileFilter(this.getSearchFileExtension()));
            int i = 0;
            while (i < list.length) {
                File subDir = new File(file.getAbsolutePath() + File.separator + list[i]);
                this.search(className, subDir);
                ++i;
            }
        } else if (file.isFile()) {
            this.fileSearch(className, file);
        }
    }

    private static void exit() {
        System.exit(1);
    }

    private boolean isEqual(String className, String fileName) {
        String searchFileExtension = this.getSearchFileExtension();
        int index = className.lastIndexOf("*");
        if (-1 == index) {
            if (className.endsWith(searchFileExtension)) {
                if (0L == this.getMode()) {
                    return fileName.equals(className);
                }
                if (1L == this.getMode()) {
                    return fileName.endsWith(className);
                }
            } else {
                if (0L == this.getMode()) {
                    return fileName.equals(className + searchFileExtension);
                }
                if (1L == this.getMode()) {
                    return fileName.endsWith(className + searchFileExtension);
                }
            }
        } else {
            if (index == 0) {
                String post = className.substring(index + 1);
                return fileName.endsWith(post + searchFileExtension);
            }
            if (index == className.length() - 1) {
                String pre = className.substring(0, index);
                return -1 != fileName.lastIndexOf(pre) && fileName.endsWith(searchFileExtension);
            }
            String pre = className.substring(0, index);
            String post = className.substring(index + 1);
            return -1 != fileName.lastIndexOf(pre) && fileName.endsWith(post + searchFileExtension);
        }
        return false;
    }

    KWhere() {
    }

    private void setMode(long i) {
        this.mode = i;
    }

    private long getMode() {
        return this.mode;
    }

    private static void help() {
        System.out.println(ARG_HELP + "\thelp");
        System.out.println(ARG_SEARCH_PROPERTYFILES + "\tsearches properties files");
        System.out.println(ARG_PREPEND_CLASSPATH + "\tuses the next argument as the classpath");
        System.out.println(ARG_PRINT_CLASSPATH + "\tprints out classpath being used.");
        System.out.println(ARG_VERSION + "\tprints out the version number of KWhere");
        System.out.println(ARG_VERIFY_CLASSPATH + "\tchecks for invalid or non-existent entries in classpath");
        System.out.println(ARG_CHECK_DUPLICATES + "\tchecks for duplicates in the classpath");
        System.out.println();
        System.out.println("KWhere supports wildcard and package-based searches");
        System.out.println();
        KWhere.usage();
    }

    private void startProcessing() {
        String className;
        long mode = this.getMode();
        if ((mode & 0x100000L) > 0L) {
            KWhere.help();
        }
        if ((mode & 0x10000L) > 0L) {
            KWhere.version();
            KWhere.exit();
        }
        if ((mode & 0x1000000L) > 0L) {
            this.setSearchFiles(System.getProperty("java.class.path"));
            this.printClassPath();
            className = parser.getArgValue(ARG_PRINT_CLASSPATH);
            if (className != null) {
                this.beginSearch(className);
            }
        }
        if ((mode & 0x10000000L) > 0L) {
            String classFileList = parser.getArgValue(ARG_PREPEND_CLASSPATH);
            if (classFileList == null) {
                System.out.println("Bad arguments. You must specify the classpath to be search with the -cp flag");
                System.out.println();
                KWhere.help();
            }
            this.setSearchFiles(classFileList);
        }
        if ((mode & 0x10L) > 0L) {
            if (classFilesList.size() == 0) {
                this.setSearchFiles(System.getProperty("java.class.path"));
            }
            if ((className = this.getSearchFileName()) == null) {
                System.out.println("Bad arguments. You must specify the class file to be searched.");
                System.out.println();
                KWhere.help();
            }
            this.beginSearch(className);
        }
        long resVerify = mode & 0x100L;
        long resDuplicate = mode & 0x1000L;
        if (resVerify > 0L || resDuplicate > 0L) {
            String[] args = null;
            args = resVerify > 0L && resDuplicate > 0L ? new String[2] : (resDuplicate > 0L ? new String[2] : new String[1]);
            int i = 0;
            if (resVerify > 0L) {
                args[i++] = new String(ARG_PREPEND_CLASSPATH);
            }
            if (resDuplicate > 0L) {
                args[i++] = new String(ARG_PREPEND_CLASSPATH);
                args[i] = new String(ARG_CHECK_DUPLICATES);
            }
            CheckPath.run(args);
        }
    }

    private boolean isClassFile(File file) {
        String fileName = file.getAbsolutePath();
        int index = fileName.lastIndexOf(".");
        String extension = fileName.substring(index);
        return ".class".equals(extension);
    }

    private void beginSearch(String className) {
        if (!this.isPackageBasedSearch(className)) {
            this.mode = 0L;
        } else {
            this.mode = 1L;
            className = className.replace('.', '/');
        }
        this.start(className);
    }

    private boolean isPackageBasedSearch(String className) {
        int posDotClass;
        int posDot = className.indexOf(".");
        return posDot != (posDotClass = className.indexOf(".class"));
    }

    public static void main(String[] args) {
        KWhere.copyright();
        Vector<String> possibleArgs = new Vector<String>();
        possibleArgs.addElement(ARG_HELP);
        possibleArgs.addElement(ARG_CHECK_DUPLICATES);
        possibleArgs.addElement(ARG_PREPEND_CLASSPATH);
        possibleArgs.addElement(ARG_PRINT_CLASSPATH);
        possibleArgs.addElement(ARG_VERSION);
        possibleArgs.addElement(ARG_VERIFY_CLASSPATH);
        possibleArgs.addElement(ARG_SEARCH_PROPERTYFILES);
        parser = new ArgumentParser("-", possibleArgs, 1, 5);
        try {
            parser.parseArgs(args);
        }
        catch (BadArgumentsException e) {
            System.out.println();
            System.out.println(e.getMessage());
            KWhere.help();
        }
        KWhere kwhere = new KWhere();
        kwhere.handleArguments(parser);
        kwhere.startProcessing();
    }

    private void fileSearch(String className, File file) {
        if (this.isArchive(file)) {
            this.searchArchive(className, file);
        } else if (this.isClassFile(file) || this.isPropertiesFile(file)) {
            this.checkClass(className, file);
        }
    }

    private void printClassPath() {
        System.out.println("*********************** Using classpath *******************");
        Enumeration e = classFilesList.elements();
        while (e.hasMoreElements()) {
            System.out.println((String)e.nextElement());
        }
        System.out.println("********************************************************");
        System.out.println();
    }

    private void checkClass(String className, File file) {
        String fileName = null;
        if (0L == this.getMode()) {
            fileName = this.getClassNameFromPath(file.getName(), "/");
        } else if (1L == this.getMode()) {
            fileName = file.getPath().replace('\\', '/');
        }
        if (this.isEqual(className, fileName)) {
            System.out.println("Found in " + file.getPath());
            this.isFound = true;
        }
    }

    private void start(String className) {
        Enumeration e = classFilesList.elements();
        while (e.hasMoreElements()) {
            String tempfileName = (String)e.nextElement();
            String fileName = tempfileName.endsWith(File.separator) ? tempfileName.substring(0, tempfileName.length() - 1) : tempfileName;
            this.search(className, new File(fileName));
        }
        if (!this.isFound) {
            System.out.println(className + " was not found in the classpath");
        }
    }

    private boolean isArchive(File file) {
        int index;
        String fileName = file.getAbsolutePath();
        String extension = fileName.substring(index = fileName.lastIndexOf("."));
        return ".zip".equals(extension) || ".jar".equals(extension);
    }

    private void setSearchFiles(String classFileString) {
        classFilesList.removeAllElements();
        StringTokenizer strTokenizer = new StringTokenizer(classFileString, PATH_SEPARATOR);
        while (strTokenizer.hasMoreElements()) {
            classFilesList.addElement((String)strTokenizer.nextElement());
        }
    }

    private static void version() {
        System.out.println("Version: " + 2.0);
    }

    private static void copyright() {
        System.out.println("Java Class Location Utility.");
        System.out.println("Copyright (C) Kashif Noorani 2000. All Rights Reserved.");
        System.out.println("Uses System Classpath. Bugs -> kashif@alumni.washington.edu");
        System.out.println();
    }

    private void handleArguments(ArgumentParser parser) {
        Vector v = parser.getAllUnpairedArgs();
        if (v != null && v.size() > 0) {
            if (parser.isArgumentPresent(ARG_HELP)) {
                this.setMode(this.getMode() | 0x100000L);
                return;
            }
            if (parser.isArgumentPresent(ARG_VERSION)) {
                this.setMode(this.getMode() | 0x10000L);
                return;
            }
            if (parser.isArgumentPresent(ARG_CHECK_DUPLICATES)) {
                this.setMode(this.getMode() | 0x1000L);
            }
            if (parser.isArgumentPresent(ARG_VERIFY_CLASSPATH)) {
                this.setMode(this.getMode() | 0x100L);
            }
        }
        if ((v = parser.getAllUnpairedValues()) != null && v.size() == 1) {
            this.setMode(this.getMode() | 0x10L);
            this.setSearchFileName((String)parser.getAllUnpairedValues().elementAt(0));
        }
        if (parser.isArgumentPresent(ARG_PREPEND_CLASSPATH)) {
            this.setMode(this.getMode() | 0x10000000L);
        }
        if (parser.isArgumentPresent(ARG_PRINT_CLASSPATH)) {
            this.setMode(this.getMode() | 0x1000000L);
        }
        if (parser.isArgumentPresent(ARG_SEARCH_PROPERTYFILES)) {
            this.setMode(this.getMode() | 0x10L);
            this.setSearchFileExtension(".properties");
            this.setSearchFileName(parser.getArgValue(ARG_SEARCH_PROPERTYFILES));
        } else {
            this.setSearchFileExtension(".class");
        }
    }

    private String getClassNameFromPath(String fileName, String sep) {
        int index = fileName.lastIndexOf(sep);
        if (-1 != index) {
            return fileName.substring(index + 1);
        }
        return fileName;
    }

    private void checkArchive(String className, File file, File zipfile) {
        String fileName = null;
        if (0L == this.getMode()) {
            fileName = this.getClassNameFromPath(file.getName(), "/");
        } else if (1L == this.getMode()) {
            fileName = file.getName();
        }
        if (this.isEqual(className, fileName)) {
            System.out.println("Found in " + zipfile.getPath() + ": " + file.getPath());
            this.isFound = true;
        }
    }

    private void searchArchive(String className, File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                this.checkArchive(className, new File(entry.getName()), file);
            }
        }
        catch (ZipException z) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

