/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.LastErrorException;

/**
 *
 * @author Alexander Evsukov
 */
public class Module extends Handle
{
    private static final FunctionName FUNCTION_GET_MODULE_HANDLE = new FunctionName("GetModuleHandle");
    private static final FunctionName FUNCTION_GET_MODULE_FILE_NAME = new FunctionName("GetModuleFileName");

    private Module()
    {
    }

    /**
     * Returns module handle for the current native process. The returned value is
     * a handle to the file used to create the calling native process.
     */
    public static Module getCurrent()
    {
        final Function function = Kernel32.get(FUNCTION_GET_MODULE_HANDLE);
        Module hModule = new Module();
        function.invoke(hModule, new Handle());
        return hModule;
    }

    public String getFileName()
    {
        final Function function = Kernel32.get(FUNCTION_GET_MODULE_FILE_NAME);
        final ZeroTerminatedString fname = Kernel32.getInstance().stringParam("", 255);
        final UInt32 result = new UInt32();
        function.invoke(result, this, new Pointer(fname), new UInt32(fname.getMaxLength()));
        if (result.getValue() == 0)
        {
            throw new LastErrorException("Unable to get module file name.");
        }

        final String fileName = fname.getValue().trim();
        return fileName;
    }
}
