/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import javax.swing.*;
import java.awt.*;
import java.text.MessageFormat;

/**
 * @author Serge Piletsky
 */
class HTMLText extends JLabel
{
    private String _htmlTextPattern;

    public HTMLText(String text, Icon icon, int horizontalAlignment)
    {
        super(text, icon, horizontalAlignment);
    }

    public HTMLText(String text, int horizontalAlignment)
    {
        super(text, horizontalAlignment);
    }

    public HTMLText(String text)
    {
        super(text);
    }

    public HTMLText(Icon image, int horizontalAlignment)
    {
        super(image, horizontalAlignment);
    }

    public HTMLText(Icon image)
    {
        super(image);
    }

    public HTMLText()
    {
    }

    public void setText(String text)
    {
        StringBuffer newHTMLText = new StringBuffer("<html><table width={0}><tr font='Dialog'><td>");
        newHTMLText.append(text);
        newHTMLText.append("</td></tr></table></html>");
        _htmlTextPattern = newHTMLText.toString();
        super.setText(getFormattedText(getWidth()));
    }

    private String getFormattedText(int width)
    {
        Object[] parameter = new Object[] {new Integer(width)};
        final String result = MessageFormat.format(_htmlTextPattern, parameter);
        return result;
    }

    public void paint(Graphics g)
    {
        final int width = getWidth();
        super.setText(getFormattedText(width));
        super.paint(g);
    }
}
