/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.UInt32;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.registry.RegistryEventListener;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.WinRegistry;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RegistryKey
extends EnumItem {
    public static final RegistryKey CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final RegistryKey CURRENT_USER = new RegistryKey(-2147483647, "HKEY_CURRENT_USER");
    public static final RegistryKey LOCAL_MACHINE = new RegistryKey(-2147483646, "HKEY_LOCAL_MACHINE");
    public static final RegistryKey USERS = new RegistryKey(-2147483645, "HKEY_USERS");
    public static final RegistryKey PERFORMANCE_DATA = new RegistryKey(-2147483644, "HKEY_PERFORMANCE_DATA");
    public static final RegistryKey CURRENT_CONFIG = new RegistryKey(-2147483643, "HKEY_CURRENT_CONFIG");
    public static final RegistryKey DYN_DATA = new RegistryKey(-2147483642, "HKEY_DYN_DATA");
    static final int DELETE = 65536;
    static final int READ_CONTROL = 131072;
    static final int WRITE_DAC = 262144;
    static final int WRITE_OWNER = 524288;
    static final int SYNCHRONIZE = 0x100000;
    static final int STANDARD_RIGHTS_REQUIRED = 983040;
    static final int STANDARD_RIGHTS_READ = 131072;
    static final int STANDARD_RIGHTS_WRITE = 131072;
    static final int STANDARD_RIGHTS_EXECUTE = 131072;
    static final int STANDARD_RIGHTS_ALL = 0x1F0000;
    static final int SPECIFIC_RIGHTS_ALL = 65535;
    static final int ACCESS_SYSTEM_SECURITY = 0x1000000;
    static final int MAXIMUM_ALLOWED = 0x2000000;
    static final int GENERIC_READ = Integer.MIN_VALUE;
    static final int GENERIC_WRITE = 0x40000000;
    static final int GENERIC_EXECUTE = 0x20000000;
    static final int GENERIC_ALL = 0x10000000;
    static final int KEY_QUERY_VALUE = 1;
    static final int KEY_SET_VALUE = 2;
    static final int KEY_CREATE_SUB_KEY = 4;
    static final int KEY_ENUMERATE_SUB_KEYS = 8;
    static final int KEY_NOTIFY = 16;
    static final int KEY_CREATE_LINK = 32;
    static final int KEY_READ = 131097;
    static final int KEY_WRITE = 131078;
    static final int KEY_EXECUTE = 131097;
    static final int KEY_ALL_ACCESS = 983103;
    static final int REG_OPTION_RESERVED = 0;
    static final int REG_OPTION_NON_VOLATILE = 0;
    static final int REG_OPTION_VOLATILE = 1;
    static final int REG_OPTION_CREATE_LINK = 2;
    static final int REG_OPTION_BACKUP_RESTORE = 4;
    static final int REG_OPTION_OPEN_LINK = 8;
    static final int REG_LEGAL_OPTION = 15;
    static final int NO_ERROR = 0;
    static final int MAX_PATH = 260;
    private String _path = "";
    private String _name = "";
    private Handle _handle = new Handle();
    private int _errorCode = 0;
    private RegistryKeyValues _keyValues;
    private List _registryEventListeners = new LinkedList();
    private boolean _listening = false;
    public static final int REG_NOTIFY_CHANGE_NAME = 1;
    public static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    public static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    public static final int REG_NOTIFY_CHANGE_SECURITY = 8;

    private RegistryKey() {
        super(0);
    }

    private RegistryKey(int key, String name) {
        super(key);
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public String getAbsolutePath() {
        String path = this.getPath();
        StringBuffer result = new StringBuffer(path);
        if (path.length() > 0 && !path.endsWith("\\")) {
            result.append('\\');
        }
        result.append(this.getName());
        return result.toString();
    }

    protected void checkError() {
        if (this._errorCode != 0) {
            throw new RegistryException(this._errorCode);
        }
    }

    protected void checkError(long errorCode) {
        this._errorCode = (int)errorCode;
        this.checkError();
    }

    public int getSubKeyCount() {
        UInt32 subKeyCount = new UInt32();
        this.checkError(WinRegistry.queryInfoKey(this.getHandle(), null, null, subKeyCount, null, null, null, null, null));
        int result = (int)subKeyCount.getValue();
        return result;
    }

    public void close() {
        this.checkError(WinRegistry.closeKey(this.getHandle()));
    }

    public RegistryKey createSubKey(String subKey, boolean writable) {
        RegistryKey result = new RegistryKey();
        this.checkError(WinRegistry.createKey(this.getHandle(), subKey, 0L, writable ? 131103L : 131097L, result._handle));
        result._path = this.getAbsolutePath();
        result._name = subKey;
        return result;
    }

    public RegistryKey createSubKey(String subKey) {
        return this.createSubKey(subKey, false);
    }

    public void deleteSubKey(String subKey) {
        this.checkError(WinRegistry.deleteKey(this.getHandle(), subKey));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RegistryKey)) {
            return false;
        }
        RegistryKey registryKey = (RegistryKey)((Object)obj);
        return this.getHandle().getValue() == registryKey.getHandle().getValue();
    }

    public void flush() {
        this.checkError(WinRegistry.flushKey(this.getHandle()));
    }

    public List getSubKeyNames() {
        int subKeyCount = this.getSubKeyCount();
        ArrayList<String> result = new ArrayList<String>(subKeyCount);
        if (subKeyCount > 0) {
            Handle handle = this.getHandle();
            int i = 0;
            int errorCode = 0;
            while (errorCode == 0) {
                ZeroTerminatedString valueName = Kernel32.getInstance().stringParam("", 260);
                errorCode = (int)WinRegistry.enumKeyEx(handle, i, valueName, new UInt32(260L), null, null);
                if (errorCode == 0) {
                    result.add(valueName.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public RegistryKey openSubKey(String name) {
        return this.openSubKey(name, false);
    }

    public RegistryKey openSubKey(String name, boolean writable) {
        RegistryKey result = new RegistryKey();
        try {
            this.checkError(WinRegistry.openKey(this.getHandle(), name, writable ? 131103 : 131097, result._handle));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result._path = this.getAbsolutePath();
        result._name = name;
        return result;
    }

    public List getSubkeys() {
        List subkeyNames = this.getSubKeyNames();
        ArrayList<RegistryKey> result = new ArrayList<RegistryKey>(subkeyNames.size());
        Iterator i = subkeyNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            RegistryKey subkey = this.openSubKey(name);
            result.add(subkey);
        }
        return result;
    }

    public RegistryKeyValues values() {
        if (this._keyValues == null) {
            this._keyValues = new RegistryKeyValues(this);
        }
        return this._keyValues;
    }

    public Handle getHandle() {
        if (this._handle.isNull()) {
            this.checkError(WinRegistry.openKey(new Handle((long)this.getValue()), "", 131097, this._handle));
        }
        return this._handle;
    }

    public void addRegistryEventListener(RegistryEventListener listener) {
        if (!this._registryEventListeners.contains(listener)) {
            this._registryEventListeners.add(listener);
        }
    }

    public void removeRegistryEventListener(RegistryEventListener listener) {
        this._registryEventListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegistryEvent(EventObject event) {
        LinkedList listeners;
        RegistryKey registryKey = this;
        synchronized (registryKey) {
            listeners = new LinkedList(this._registryEventListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            RegistryEventListener listener = (RegistryEventListener)i.next();
            listener.handle(event);
        }
    }

    public void startChangeListening(final boolean watchSubtree, final int filter) {
        Thread listener = new Thread(new Runnable(){

            public void run() {
                RegistryKey.this._listening = true;
                while (RegistryKey.this._listening) {
                    RegistryKey.this.checkError(WinRegistry.notifyChangeValue(RegistryKey.this.getHandle(), watchSubtree, filter, new Handle(), false));
                    if (!RegistryKey.this._listening) continue;
                    RegistryKey.this.fireRegistryEvent(new EventObject(this));
                }
            }
        });
        listener.start();
    }

    public void startChangeListening() {
        int filter = 15;
        this.startChangeListening(true, filter);
    }

    public void stopChangeListening() {
        this._listening = false;
        this.close();
    }

    static {
        DELETE = 65536;
        READ_CONTROL = 131072;
        WRITE_DAC = 262144;
        WRITE_OWNER = 524288;
        SYNCHRONIZE = 0x100000;
        STANDARD_RIGHTS_REQUIRED = 983040;
        STANDARD_RIGHTS_READ = 131072;
        STANDARD_RIGHTS_WRITE = 131072;
        STANDARD_RIGHTS_EXECUTE = 131072;
        STANDARD_RIGHTS_ALL = 0x1F0000;
        SPECIFIC_RIGHTS_ALL = 65535;
        ACCESS_SYSTEM_SECURITY = 0x1000000;
        MAXIMUM_ALLOWED = 0x2000000;
        GENERIC_READ = Integer.MIN_VALUE;
        GENERIC_WRITE = 0x40000000;
        GENERIC_EXECUTE = 0x20000000;
        GENERIC_ALL = 0x10000000;
        KEY_QUERY_VALUE = 1;
        KEY_SET_VALUE = 2;
        KEY_CREATE_SUB_KEY = 4;
        KEY_ENUMERATE_SUB_KEYS = 8;
        KEY_NOTIFY = 16;
        KEY_CREATE_LINK = 32;
        KEY_READ = 131097;
        KEY_WRITE = 131078;
        KEY_EXECUTE = 131097;
        KEY_ALL_ACCESS = 983103;
        REG_OPTION_RESERVED = 0;
        REG_OPTION_NON_VOLATILE = 0;
        REG_OPTION_VOLATILE = 1;
        REG_OPTION_CREATE_LINK = 2;
        REG_OPTION_BACKUP_RESTORE = 4;
        REG_OPTION_OPEN_LINK = 8;
        REG_LEGAL_OPTION = 15;
        NO_ERROR = 0;
        MAX_PATH = 260;
        REG_NOTIFY_CHANGE_NAME = 1;
        REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
        REG_NOTIFY_CHANGE_LAST_SET = 4;
        REG_NOTIFY_CHANGE_SECURITY = 8;
    }
}

