package com.tolstoy.testjc;

import com.jconfig.*;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;

/**
This is a sample disk browser application. Please note: this application is not meant to
represent good interface design or proper AWT usage, only to demonstrate the use of the file
methods of JConfig.

Feel free to modify this file as you wish.

@author JConfig Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

public class DiskBrowser {
	public DiskBrowser() {
		BrowserFrame		aFrame;

		aFrame = new BrowserFrame( "Disk Browser Test" );
//		aFrame.reshape( 100, 100, 500, 400 );
		aFrame.show();
	}

		//	initialize JConfig, and then create the browser
	public static void main( String args[] ) {
		FileSystem			systems[];
		File				curDir;
		int					i;

		try {
			curDir = new File( System.getProperty( "user.dir" ) );

				//	output all trace messages to System.out
			Trace.setDestination( Trace.TRACE_SYSOUT );

			FileRegistry.initialize( curDir, JUtils.asciiToInt( "fred" ) );
			if ( !FileRegistry.isInited() ) {
				Trace.println( "Please check your configuration." );
				return;
			}

			systems = FileRegistry.getFileSystems( 20, 0 );
			if ( systems == null )
				Trace.println( "can't get FileSystems" );
			else {
				Trace.println( "FileSystems:" );
				for ( i = 0; i < systems.length; i++ )
					systems[ i ].dumpInfo( Trace.getOut(), "  " );
			}

			DiskBrowser browser = new DiskBrowser();
		}
		catch ( Exception e ) {
			Trace.println( "problems: " + e );
			e.printStackTrace( Trace.getOut() );
		}
	}
}

/*
The browser frame contains 5 panels and a button. Each panel displays information about a file,
directory, alias, or volume. The button is used to go up a level.

If the variable currentContainer is non-null, it holds the directory that contains the five items
at the current level. If currentContainer is null, we're at the top level, and the mounted
volumes should be shown. 
*/

class BrowserFrame extends Frame {
	DiskObject			currentContainer;
	BrowserPanel		thePanels[];
	Button				upALevelButton;

	static final int		kNumPanels = 5;

	public BrowserFrame( String ttl ) {
		super( ttl );
		currentContainer = null;
		initializeDisplay();
	}

/*
Update the display. If we're at the top level, use the FileRegistry to get a list of the
mounted volumes.
*/

	public void refreshCurrentDisplay() {
		DiskVolume			mountedVolumes[];
		int					i;

		if ( currentContainer != null ) {

			Trace.println( "refreshing display with " + currentContainer );
			tryToSetAsContainer( currentContainer );
			return;
		}

		mountedVolumes = FileRegistry.getVolumes();
		if ( mountedVolumes == null ) {
			Trace.println( "can't get mounted volumes" );
			return;
		}

		System.out.println( "there are " + mountedVolumes.length + " volumes" );

		for ( i = 0; i < mountedVolumes.length && i < kNumPanels; i++ ) {
			thePanels[ i ].setDiskObject( mountedVolumes[ i ] );
			thePanels[ i ].repaint();
		}

		for ( ; i < kNumPanels; i++ ) {
			thePanels[ i ].setDiskObject( null );
			thePanels[ i ].repaint();
		}
	}

/*
Try to set the given object as the current container. First, we try to iterate on its contents; if
that fails ( e.g., if it's a file ), we do nothing. Otherwise, set the current container, and
initialize the panels with the contents of the current container.
*/

	void tryToSetAsContainer( DiskObject newContainer ) {
		GenDiskFilter		df;
		DiskObject			savedItems[];
		int					i, theErr, filterFlags;

		df = new GenDiskFilter( kNumPanels );

		filterFlags = DiskFilter.IGNORE_NAME_LOCKED | DiskFilter.IGNORE_HIDDEN;
		theErr = newContainer.iterate( df, filterFlags, 1000 );

		savedItems = df.getArray();

		if ( savedItems == null || theErr != ErrCodes.ERROR_NONE ) {
			Trace.println( "iterated on " + newContainer.getName() + ", got err=0x" + Integer.toHexString( theErr ) );
			return;
		}

		currentContainer = newContainer;
		Trace.println( "setting new container: name=" + currentContainer.getName() );

		for ( i = 0; i < savedItems.length; i++ ) {
			thePanels[ i ].setDiskObject( savedItems[ i ] );
			thePanels[ i ].repaint();
		}

		for ( ; i < kNumPanels; i++ ) {
			thePanels[ i ].setDiskObject( null );
			thePanels[ i ].repaint();
		}
	}

/*
The user clicked on the 'Up A Level' button. If we're at the top level, do nothing. Otherwise,
set the current container to the item which contains the current container.
*/

	void upALevelButtonHit() {
		if ( currentContainer == null )
			Trace.println( "already at top level" );
		else {
			try {
				currentContainer = currentContainer.getContainer();
			}
			catch ( Exception e ) {
				Trace.println( "can't get container for " + currentContainer.getName() + ":" + e );
			}
		}
		
		refreshCurrentDisplay();
	}

/*
One of the panels was clicked on. Try to set the object it holds as the current container.
*/

	void browserPanelHit( int which ) {
		DiskObject			prospectiveContainer;
		
		prospectiveContainer = thePanels[ which ].getDiskObject();
		if ( prospectiveContainer == null ) {
			Trace.println( "can't set null as container" );
			return;
		}
		
		tryToSetAsContainer( prospectiveContainer );
	}

/*
The following are mainly AWT-related methods.
*/

	void initializeDisplay() {
		int				i;

		setLayout( new GridLayout( 6, 1 ) );
		resize( 500, 400 );
//		reshape( 100, 100, 500, 400 );

		thePanels = new BrowserPanel[ kNumPanels ];		
		for ( i = 0; i < kNumPanels; i++ ) {
			thePanels[ i ] = new BrowserPanel( i );
			add( "Center", thePanels[ i ] );
		}

		upALevelButton = new Button( "Up A Level" );
		add( "Center", upALevelButton );
	}

	public void paint( Graphics g ) {
		refreshCurrentDisplay();
	}

	public boolean handleEvent( Event ev ) {
		int			i;

		if ( ev.id == Event.ACTION_EVENT ) {
			if ( ev.target == upALevelButton ) {
				upALevelButtonHit();
				return true;
			}
		}

		if ( ev.id == Event.MOUSE_UP ) {
			for ( i = 0; i < kNumPanels; i++ ) {
				if ( ev.target == thePanels[ i ] ) {
					browserPanelHit( i );
					return true;
				}
			}
		}

		if ( ev.id == Event.WINDOW_DESTROY ) {
			System.exit( 0 );
			return true;
		}

		return false;
	}
}

