package com.kur.ide;

import com.sun.tools.doclets.Taglet;
import com.sun.javadoc.*;
import java.util.Map;
import java.util.Vector;
import java.lang.System;


/** JadeTaglet is a class which represents a JadeIDE specified taglet to generate
  * JadeIDE specific Java Doc comprising user tags
  * <br>
  * @author   Wolfgang Kurz  -- last change: Dienstag, 10. September 2002 11.58 Uhr CEST
  * @version  3.2
  * template generated with JADE Integrated Development Environment ( Wolfgang Kurz, 2002)
  */

public class JadeTaglet implements Taglet
{  /* start of class definition */

//**********************************
// Class variables
//**********************************
   private static int           nbrKeys    = 0;

   private static Vector        theTaglets = new Vector();
   private static Vector        allNames   = new Vector();
   private static Vector        allHeaders = new Vector();

   private static String        userTags;   // Input to Java -DuserTags="a,b;c,d;e,f"
   private static int           startPosE = 0;
   private static int           endPosE   = 0;
   private static int           sepPos    = 0;
   private static char          dQ        = '\u0022';  // double quote
   private static char          sC        = '\u003B';  // semicolon
   private static char          cM        = '\u002C';  // coma
   private static String        anEntry   = "";
   private static String        tmpEntry  = "";
   private static String        aName     = "";
   private static String        aHeader   = "";

//**********************************
// Instance variables
//**********************************

   private String               theName;
   private String               theHeader;

 //**********************************
 // Class constructor
 //**********************************
/** Defines the position of the components inside the window frame
  * and initializes the displayed fields
  * <br>
  * @param    aName    the name of the tag handled by this taglet
  * @param    aHeader  the header of the tags handled by this taglet
  */
    public JadeTaglet(String aName, String aHeader)
    {  /* start constructor */
       theName   = aName;
       theHeader = aHeader;
    }  /* end constructor */

//**********************************
// Class methods
//**********************************

   /**
    * Register this Taglet.
    * @param tagletMap  the map to register this tag to.
    */
   public static void register(Map tagletMap)
   {  /* start of method */
      JadeTaglet.initialize();

      for (int i = 0; i < nbrKeys; i=i+1)
      {  /* 001 start for */
         JadeTaglet tag = new JadeTaglet((String) allNames.get(i),(String) allHeaders.get(i));
         theTaglets.add(i, (Object) tag);
         Taglet t = (Taglet) tagletMap.get(tag.getName());
         if (t != null)
         {  /* 002 start if */
            tagletMap.remove(tag.getName());
         }  /* 002 end if */
         tagletMap.put(tag.getName(), tag);
      }  /* 001 end for */
   }  /* end of method */

   /**
    * Initialize this Taglet class
    * Input to the Java virtual machine as -DuserTags="a,b;c,d;e,f"
    */
   public static void initialize()
   {  /* start of method */
       userTags   = System.getProperty("userTags","todo,To Do:;new,New Function:");
       userTags   = userTags.trim();
       startPosE  = 0;
       endPosE    = 0;
       nbrKeys    = 0;

loop:  for (int i = 0; i > -1; i=i+1)
       {  /* 001 start for */
          endPosE = userTags.indexOf(sC,startPosE);
          if ( endPosE < startPosE )
          {  /* 002 start if */
             anEntry = userTags.substring(startPosE);
             anEntry = anEntry.trim();
             JadeTaglet.buildPair(i,anEntry);
             nbrKeys = nbrKeys + 1;
             break loop;
          } else {
             anEntry = userTags.substring(startPosE,endPosE);
             JadeTaglet.buildPair(i,anEntry);
             nbrKeys = nbrKeys + 1;
             startPosE = endPosE+1;
          }  /* 002 end if */
       }  /* 001 end for */

   }  /* end of method */

   /**
    * Build a tag header pair
    */
   public static void buildPair(int vInd, String aEntry)
   {  /* start of method */
       tmpEntry    = aEntry.trim();
       sepPos      = tmpEntry.indexOf(cM);

       if (sepPos < 0) // if no seperator than tag and header is the same
       {  /* 001 start if */
          aName   = tmpEntry;
          aHeader = tmpEntry;
       }  else {  // if a seperator exists, extract the components
          aName   = tmpEntry.substring(0,sepPos);
          aHeader = tmpEntry.substring(sepPos+1);
       }  /* 001 end if */
       allNames.add(vInd,(Object) aName);
       allHeaders.add(vInd,(Object) aHeader);
   }  /* end of method */

//**********************************
// Instance methods
//**********************************

   /**
    * Return the name of this custom tag.
    */
   public String getName()
   {  /* start of method */
       return theName;
   }  /* end of method */

   /**
    * Return the name of this custom tag.
    */
   public String getHeader()
   {  /* start of method */
       return theHeader;
   }  /* end of method */

   /**
    * Will return true since this <code>ToDoTaglet</code>
    * can be used in field documentation.
    * @return true since this <code>ToDoTaglet</code>
    * can be used in field documentation and false
    * otherwise.
    */
   public boolean inField()
   {  /* start of method */
       return true;
   }  /* end of method */

   /**
    * Will return true since this <code>ToDoTaglet</code>
    * can be used in constructor documentation.
    * @return true since this <code>ToDoTaglet</code>
    * can be used in constructor documentation and false
    * otherwise.
    */
   public boolean inConstructor()
   {  /* start of method */
       return true;
   }  /* end of method */

   /**
    * Will return true since this <code>ToDoTaglet</code>
    * can be used in method documentation.
    * @return true since this <code>ToDoTaglet</code>
    * can be used in method documentation and false
    * otherwise.
    */
   public boolean inMethod()
   {  /* start of method */
       return true;
   }  /* end of method */

   /**
    * Will return true since this <code>ToDoTaglet</code>
    * can be used in method documentation.
    * @return true since this <code>ToDoTaglet</code>
    * can be used in overview documentation and false
    * otherwise.
    */
   public boolean inOverview()
   {  /* start of method */
       return true;
   }  /* end of method */

   /**
    * Will return true since this <code>ToDoTaglet</code>
    * can be used in package documentation.
    * @return true since this <code>ToDoTaglet</code>
    * can be used in package documentation and false
    * otherwise.
    */
   public boolean inPackage()
   {  /* start of method */
       return true;
   }  /* end of method */

   /**
    * Will return true since this <code>ToDoTaglet</code>
    * can be used in type documentation (classes or interfaces).
    * @return true since this <code>ToDoTaglet</code>
    * can be used in type documentation and false
    * otherwise.
    */
   public boolean inType()
   {  /* start of method */
       return true;
   }  /* end of method */

   /**
    * Will return false since this <code>ToDoTaglet</code>
    * is not an inline tag.
    * @return false since this <code>ToDoTaglet</code>
    * is not an inline tag.
    */
   public boolean isInlineTag()
   {  /* start of method */
       return false;
   }  /* end of method */


   /**
    * Given the <code>Tag</code> representation of this custom
    * tag, return its string representation.
    * @param tag he <code>Tag</code> representation of this custom tag.
    */
   public String toString(Tag tag)
   {  /* start of method */
       String     aHeader;

       aHeader = getHeader();
       return "<DT><B>" + aHeader + "</B><DD>"
              + "<table cellpadding=2 cellspacing=0><tr><td bgcolor=\"white\">"
              + tag.text()
              + "</td></tr></table></DD>\n";
   }  /* end of method */

   /**
    * Given an array of <code>Tag</code>s representing this custom
    * tag, return its string representation.
    * @param tags the array of <code>Tag</code>s representing of this custom tag.
    */
   public String toString(Tag[] tags)
   {  /* start of method */
       String     aHeader;


       if (tags.length == 0)
       {  /* 001 start if */
          return null;
       } else {
          aHeader = getHeader();
          String result = "\n<DT><B>" + aHeader + "</B><DD>";
          result += "<table cellpadding=2 cellspacing=0><tr><td bgcolor=\"white\">";
          for (int i = 0; i < tags.length; i++)
          {  /* 002 start for */
             if (i > 0)
             {  /* 002 start if */
                result += ", ";
             }  /* 002 end if  */
             result += tags[i].text();
          }  /* 002 end for */
          return result + "</td></tr></table></DD>\n";
       }  /* 001 end if */
   }  /* end of method */
}  /* end of class definition */



