/*
 * Decompiled with CFR 0.152.
 */
package com.dipu.tablelisteners;

import com.dipu.tablelisteners.SelectionModel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class RowEditor
extends AbstractAction
implements ListSelectionListener {
    Vector clipBoard;
    int min;
    int max;
    JTable table;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cut")) {
            this.rowsToClipBoard();
            this.rowsRemove();
            this.reset();
        }
        if (string.equals("copy")) {
            this.rowsToClipBoard();
            this.reset();
        }
        if (string.equals("insert")) {
            this.clipBoardToRows();
            this.reset();
        }
    }

    void clipBoardToRows() {
        if (this.min == -1) {
            this.min = 0;
        }
        int n = this.clipBoard.size() - 1;
        while (n >= 0) {
            Vector vector = (Vector)this.clipBoard.elementAt(n);
            ((DefaultTableModel)this.table.getModel()).insertRow(this.min, vector);
            --n;
        }
    }

    void reset() {
        this.min = -1;
        this.max = -1;
        this.table.clearSelection();
    }

    void rowsRemove() {
        if (this.min == -1 || this.max == -1) {
            return;
        }
        int n = this.min;
        while (n <= this.max) {
            ((DefaultTableModel)this.table.getModel()).removeRow(this.min);
            ++n;
        }
    }

    void rowsToClipBoard() {
        if (this.min == -1 || this.max == -1) {
            return;
        }
        this.clipBoard = new Vector();
        int n = this.min;
        while (n <= this.max) {
            Vector<Object> vector = new Vector<Object>();
            int n2 = 0;
            while (n2 < this.table.getColumnCount()) {
                vector.addElement(this.table.getValueAt(n, n2));
                ++n2;
            }
            this.clipBoard.addElement(vector);
            ++n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            SelectionModel selectionModel = (SelectionModel)listSelectionEvent.getSource();
            this.min = selectionModel.getMinSelectionIndex();
            this.max = selectionModel.getMaxSelectionIndex();
            this.table = selectionModel.getTable();
        }
    }
}

