/*
 * Decompiled with CFR 0.152.
 */
import com.javazine.components.AppletProperties;
import com.javazine.components.BorderPanel;
import com.javazine.components.Column;
import com.javazine.components.Grid;
import com.javazine.components.GridEvent;
import com.javazine.components.GridListener;
import com.javazine.components.ImageButton;
import com.javazine.components.ImageDialog;
import com.javazine.components.ProgressBar;
import com.javazine.components.Row;
import com.javazine.components.TextDialog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public final class DbApplet
extends Applet
implements ActionListener,
GridListener,
ItemListener {
    public ProgressBar pBar = null;
    ImageButton ibtnFirst = null;
    ImageButton ibtnNext = null;
    ImageButton ibtnPrevious = null;
    ImageButton ibtnLast = null;
    ImageButton ibtnReset = null;
    ImageButton ibtnSearch = null;
    ImageButton ibtnHome = null;
    Choice choiceCategories = null;
    TextField searchField = null;
    private Image imgFirst = null;
    private Image imgNext = null;
    private Image imgPrevious = null;
    private Image imgLast = null;
    private Image imgReset = null;
    private Image imgSearch = null;
    private Image imgHome = null;
    private FontMetrics fMetrics = null;
    private Font fFont = new Font("Helvetica", 1, 18);
    private boolean bLoaded = false;
    private boolean bLoadError = false;
    private String sTitle = "";
    AboutDialog dlgAbout = null;
    DbApplet self = null;
    private String sStatus = "";
    private TextDialog dlgRecord = null;
    public boolean bLicensed = false;
    public Grid grid = null;
    public ImageDialog dlgImage = null;
    private String propertiesFileName = "dbapplet.properties";
    public AppletProperties properties = null;
    private Util util = null;

    public void stop() {
        if (this.dlgImage != null) {
            this.dlgImage.dispose();
        }
        if (this.dlgRecord != null) {
            this.dlgRecord.dispose();
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private int cton(String string, String string2) {
        return string.indexOf(string2);
    }

    public void startRecordDialog() {
        if (this.dlgRecord != null) {
            this.dlgRecord.dispose();
            this.dlgRecord = null;
        }
        this.dlgRecord = new TextDialog("Database Applet Record", this.getRecord());
    }

    private final void init2() {
        this.remove(this.pBar);
        this.validate();
        this.repaint();
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        BorderPanel borderPanel = new BorderPanel();
        FlowLayout flowLayout = (FlowLayout)panel2.getLayout();
        flowLayout.setAlignment(0);
        flowLayout.setVgap(2);
        flowLayout.setHgap(10);
        flowLayout = (FlowLayout)panel3.getLayout();
        flowLayout.setAlignment(0);
        flowLayout.setVgap(2);
        flowLayout.setHgap(5);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.ibtnFirst = new ImageButton(this.imgFirst, this, 24, 24);
        this.ibtnNext = new ImageButton(this.imgNext, this, 24, 24);
        this.ibtnPrevious = new ImageButton(this.imgPrevious, this, 24, 24);
        this.ibtnLast = new ImageButton(this.imgLast, this, 24, 24);
        this.ibtnReset = new ImageButton(this.imgReset, this, 24, 24);
        this.ibtnSearch = new ImageButton(this.imgSearch, this, 24, 24);
        this.ibtnHome = new ImageButton(this.imgHome, this, 24, 24);
        this.searchField = new TextField(20);
        this.choiceCategories = new Choice();
        panel.add(this.ibtnFirst);
        panel.add(this.ibtnPrevious);
        panel.add(this.ibtnNext);
        panel.add(this.ibtnLast);
        Vector vector = this.grid.getCategories();
        if (vector.size() > 0) {
            this.choiceCategories.addItem(this.properties.getProperty("ALIAS_ALL_ITEMS", "All Items"));
            int n = 0;
            while (n < vector.size()) {
                this.choiceCategories.addItem((String)vector.elementAt(n));
                ++n;
            }
            panel2.add(this.choiceCategories);
        }
        panel2.add(this.searchField);
        panel2.add(this.ibtnSearch);
        panel2.add(this.ibtnReset);
        panel3.add(this.ibtnHome);
        if (this.properties.getProperty("LAYOUT_NAVIGATION_BUTTONS", "YES").trim().equals("YES")) {
            borderPanel.add(panel);
        }
        if (this.properties.getProperty("LAYOUT_SEARCH_BUTTONS", "YES").trim().equals("YES")) {
            borderPanel.add(panel2);
        }
        if (this.properties.getProperty("LAYOUT_ABOUT_BUTTON", "YES").trim().equals("YES")) {
            borderPanel.add(panel3);
        }
        this.setLayout(new BorderLayout(0, 1));
        if (borderPanel.getComponentCount() > 0) {
            this.add((Component)borderPanel, "North");
        }
        this.add((Component)this.grid, "Center");
        this.validate();
        ToolMouseListener toolMouseListener = new ToolMouseListener();
        this.ibtnFirst.addMouseListener(toolMouseListener);
        this.ibtnPrevious.addMouseListener(toolMouseListener);
        this.ibtnNext.addMouseListener(toolMouseListener);
        this.ibtnLast.addMouseListener(toolMouseListener);
        this.ibtnReset.addMouseListener(toolMouseListener);
        this.ibtnSearch.addMouseListener(toolMouseListener);
        this.ibtnHome.addMouseListener(toolMouseListener);
        this.searchField.addMouseListener(toolMouseListener);
        this.searchField.addActionListener(this);
        this.choiceCategories.addItemListener(this);
        this.choiceCategories.addMouseListener(toolMouseListener);
        this.grid.addGridListener(this);
        this.validate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setFont(this.fFont);
        if (!this.bLoaded) {
            graphics.setColor(Color.black);
            int n = this.fMetrics.stringWidth(this.sTitle);
            graphics.drawString(this.sTitle, (dimension.width - n) / 2, dimension.height / 2);
        } else if (this.bLoadError) {
            String string = "Sorry, cannot load the data file";
            int n = this.fMetrics.stringWidth(string);
            graphics.drawString(string, (dimension.width - n) / 2, dimension.height / 2);
        }
        graphics.setColor(Color.darkGray);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void gridChanged(GridEvent gridEvent) {
        switch (gridEvent.getId()) {
            case 1: {
                Column column = this.grid.getColumn();
                this.grid.getRow();
                switch (column.iType) {
                    case 4: {
                        String string = this.grid.getCell();
                        if (string.length() <= 0) return;
                        this.showURL(column.sBaseUrl + string, column.sTarget);
                        return;
                    }
                    case 5: {
                        String string = this.grid.getCell();
                        if (string.length() <= 0) return;
                        this.startImageDialog(column.sBaseUrl + string, this.getRecord());
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 2: {
                this.startRecordDialog();
                return;
            }
            default: {
                return;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.choiceCategories.getSelectedItem();
        if (string.equalsIgnoreCase(this.properties.getProperty("ALIAS_ALL_ITEMS", "All Items"))) {
            this.grid.showAll();
            ((TextComponent)this.searchField).setText("");
            return;
        }
        this.grid.showCategories(string);
    }

    private final boolean checksLicense(String string) {
        if (string.length() == 0) {
            return false;
        }
        String string2 = "0123456789:-abcdefghijklmnopqrstuvwxyz._~ABCDEF/GHIJKLMNOPQRSTUVWXYZ";
        String string3 = "ghnopqrstuef:-._~ABCDEFvwx0137UVWX89abcdGHIJ456KLMyz2NOPlmRST/QijkYZ";
        String string4 = "";
        string4 = this.code(string, string3, 8);
        string4 = this.code(string4, string2, 7);
        string4.substring(0, 4);
        String string5 = string4.substring(4);
        return string5.equalsIgnoreCase(this.getCodeBase().toString());
    }

    private final synchronized void loadData(String string, int n, char c) {
        block15: {
            BufferedReader bufferedReader = null;
            URL uRL = null;
            URLConnection uRLConnection = null;
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            try {
                try {
                    uRL = new URL(string);
                    uRLConnection = uRL.openConnection();
                    bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    int n2 = 0;
                    int n3 = 0;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String[] stringArray = new String[n];
                        int n4 = 0;
                        while (n4 < n) {
                            stringArray[n4] = "";
                            ++n4;
                        }
                        n3 = 0;
                        stringBuffer = new StringBuffer("");
                        n4 = 0;
                        while (n4 < string2.length()) {
                            if (string2.charAt(n4) == c && n3 < n) {
                                stringArray[n3] = this.util.trim(stringBuffer.toString().trim(), '\"');
                                stringBuffer = new StringBuffer("");
                                ++n3;
                            } else {
                                stringBuffer.append(string2.charAt(n4));
                            }
                            ++n4;
                        }
                        if (n3 < n) {
                            stringArray[n3] = this.util.trim(stringBuffer.toString().trim(), '\"');
                        }
                        this.grid.addRow(stringArray);
                        this.pBar.updateProgress();
                        ++n2;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Object var14_17 = null;
                if (bufferedReader == null) break block15;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.bLoaded = true;
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.bLoaded = true;
    }

    public void startImageDialog(String string, String string2) {
        if (this.dlgImage != null) {
            this.dlgImage.dispose();
            this.dlgImage = null;
        }
        this.dlgImage = new ImageDialog("Database Applet Image Dialog", string, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.searchField.getText().trim();
        if (this.choiceCategories.getItemCount() > 0) {
            this.choiceCategories.select(0);
        }
        if (string.length() == 0) {
            this.grid.showAll();
            return;
        }
        this.grid.searchSlow(string);
    }

    public void start() {
    }

    private String getRecord() {
        Column column;
        int n = 0;
        char[] cArray = new char[1024];
        int n2 = 0;
        do {
            cArray[n2] = 32;
        } while (++n2 < 1024);
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.grid.getColumns();
        Row row = this.grid.getRow();
        int n3 = 0;
        while (n3 < vector.size()) {
            column = (Column)vector.elementAt(n3);
            if (column.bVisible) {
                n = Math.max(n, column.sHeader.length());
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            column = (Column)vector.elementAt(n3);
            if (column.bVisible) {
                stringBuffer.append(((Column)vector.elementAt((int)n3)).sHeader).append(cArray, 0, n - ((Column)vector.elementAt((int)n3)).sHeader.length() + 4);
                if (row.sRow.length > n3) {
                    stringBuffer.append(row.sRow[n3]);
                }
                stringBuffer.append('\n');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String ntoc(String string, int n) {
        return string.substring(n, n + 1);
    }

    public void showURL(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL(string);
            if (uRL != null) {
                this.getAppletContext().showDocument(uRL, string2);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void init() {
        this.self = this;
        this.fMetrics = this.getToolkit().getFontMetrics(new Font("Helvetica", 0, 12));
        String string = this.getParameter("PROPERTIES");
        if (string != null) {
            this.propertiesFileName = string.trim();
        }
        this.properties = new AppletProperties(this);
        this.properties.load(this.getCodeBase() + this.propertiesFileName);
        if (!this.checksLicense(this.properties.getProperty("LICENSE_KEY", "").trim())) {
            this.dlgAbout = new AboutDialog(this, false);
        } else {
            this.bLicensed = true;
        }
        this.sTitle = this.properties.getProperty("TITLE", "Database Applet").trim();
        this.util = new Util();
        boolean bl = System.getProperty("java.vendor").substring(0, 8).equals("Netscape");
        if (!bl) {
            this.imgFirst = this.getImage(this.getCodeBase(), "first.gif");
            this.imgNext = this.getImage(this.getCodeBase(), "next.gif");
            this.imgPrevious = this.getImage(this.getCodeBase(), "previous.gif");
            this.imgLast = this.getImage(this.getCodeBase(), "last.gif");
            this.imgReset = this.getImage(this.getCodeBase(), "reset.gif");
            this.imgSearch = this.getImage(this.getCodeBase(), "search.gif");
            this.imgHome = this.getImage(this.getCodeBase(), "home.gif");
        } else {
            this.imgFirst = this.util.getImageFromJAR(this, "first.gif");
            this.imgNext = this.util.getImageFromJAR(this, "next.gif");
            this.imgPrevious = this.util.getImageFromJAR(this, "previous.gif");
            this.imgLast = this.util.getImageFromJAR(this, "last.gif");
            this.imgReset = this.util.getImageFromJAR(this, "reset.gif");
            this.imgSearch = this.util.getImageFromJAR(this, "search.gif");
            this.imgHome = this.util.getImageFromJAR(this, "home.gif");
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.imgFirst, 0);
        mediaTracker.addImage(this.imgNext, 1);
        mediaTracker.addImage(this.imgPrevious, 2);
        mediaTracker.addImage(this.imgLast, 3);
        mediaTracker.addImage(this.imgReset, 4);
        mediaTracker.addImage(this.imgSearch, 5);
        mediaTracker.addImage(this.imgHome, 6);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        this.grid = new Grid(null, null, null, this.properties);
        if (this.properties.getProperty("TOOLTIP_SHOW_TOOLTIP", "YES").trim().equalsIgnoreCase("YES")) {
            this.grid.enableToolTip(true);
        } else {
            this.grid.enableToolTip(false);
        }
        Vector vector = this.properties.getColumns();
        int n = 0;
        while (n < vector.size()) {
            this.grid.addColumn((Column)vector.elementAt(n));
            ++n;
        }
        this.pBar = new ProgressBar("Loading Data: ", this.properties.getIntProperty("DATA_FILE_ROW_COUNT", 100), new Dimension(250, 30));
        this.add(this.pBar);
        this.setVisible(true);
        this.validate();
        this.loadData(this.getCodeBase() + this.properties.getProperty("DATA_FILE_NAME", "data.txt").trim(), vector.size(), this.properties.getDelimiter());
        this.init2();
    }

    private final String code(String string, String string2, int n) {
        int n2;
        int n3;
        Object object;
        String string3 = "";
        Object object2 = "";
        int n4 = 0;
        while (n4 < string.length()) {
            object = string.substring(n4, n4 + 1);
            n3 = this.cton(string2, (String)object);
            if (n3 < 64) {
                n2 = n3 ^ string.length() / 2 + n;
                object2 = this.ntoc(string2, n2);
            } else {
                object2 = object;
            }
            string3 = string3 + (String)object2;
            ++n4;
        }
        char[] cArray = string3.toCharArray();
        object = string3.toCharArray();
        n3 = object[0];
        n2 = 0;
        while (n2 < cArray.length - 1) {
            cArray[n2] = object[n2 + 1];
            ++n2;
        }
        cArray[cArray.length - 1] = n3;
        string3 = new String(cArray);
        string = cArray.length == 2 * (cArray.length / 2) ? string3.substring(cArray.length / 2, cArray.length) + string3.substring(0, cArray.length / 2) : string3.substring(cArray.length / 2 + 1, cArray.length) + string3.substring(0, cArray.length / 2 + 1);
        return string;
    }

    public class ToolMouseListener
    extends MouseAdapter
    implements MouseListener {
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component == DbApplet.this.ibtnFirst) {
                DbApplet.this.grid.moveFirst();
                return;
            }
            if (component == DbApplet.this.ibtnPrevious) {
                DbApplet.this.grid.movePrevious();
                return;
            }
            if (component == DbApplet.this.ibtnNext) {
                DbApplet.this.grid.moveNext();
                return;
            }
            if (component == DbApplet.this.ibtnLast) {
                DbApplet.this.grid.moveLast();
                return;
            }
            if (component == DbApplet.this.ibtnReset) {
                ((TextComponent)DbApplet.this.searchField).setText("");
                DbApplet.this.grid.showAll();
                DbApplet.this.choiceCategories.select(0);
                return;
            }
            if (component == DbApplet.this.ibtnSearch) {
                DbApplet.this.grid.searchSlow(DbApplet.this.searchField.getText().trim());
                DbApplet.this.choiceCategories.select(0);
                return;
            }
            if (component == DbApplet.this.ibtnHome) {
                if (DbApplet.this.dlgAbout != null) {
                    DbApplet.this.dlgAbout.dispose();
                    DbApplet.this.dlgAbout = null;
                }
                DbApplet.this.dlgAbout = new AboutDialog(DbApplet.this.self, DbApplet.this.bLicensed);
            }
        }

        public ToolMouseListener() {
            DbApplet.this.getClass();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component == DbApplet.this.ibtnFirst) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_MOVE_TO_FIRST_ROW", "Move to first row"));
                return;
            }
            if (component == DbApplet.this.ibtnPrevious) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_MOVE_TO_PREVIOUS_ROW", "Move to previous row"));
                return;
            }
            if (component == DbApplet.this.ibtnNext) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_MOVE_TO_NEXT_ROW", "Move to next row"));
                return;
            }
            if (component == DbApplet.this.ibtnLast) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_MOVE_TO_LAST_ROW", "Move to last row"));
                return;
            }
            if (component == DbApplet.this.ibtnReset) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_SHOW_ALL_ROWS", "Show all rows"));
                return;
            }
            if (component == DbApplet.this.ibtnSearch) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_SEARCH_FOR_KEYWORDS", "Search for keywords"));
                return;
            }
            if (component == DbApplet.this.ibtnHome) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_ABOUT_DATABASE_APPLET", "About database applet"));
                return;
            }
            if (component == DbApplet.this.searchField) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_SEARCH_FOR_KEYWORDS", "Search for keywords"));
                return;
            }
            if (component == DbApplet.this.choiceCategories) {
                DbApplet.this.grid.setToolTip(DbApplet.this.properties.getProperty("TOOLTIP_SHOW_BY_CATEGORY", "Show by category"));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DbApplet.this.grid.setToolTip("");
        }
    }
}

