/*This is example of using dalib classes when updating data in BLOB fields.
Change database URL and user name and password before compiling this example.

Run InsertBlob example to populate table. Then run ListBlobKeys to see primary keys of inserted
rows. Then run:
java UpdateBlob key file
Here key - primary key of the row, file - input file name.
*/

import java.util.*;
import JProjects.eab.data.*;


public class UpdateBlob {

    public static void main(String[] arg)  throws Exception {
	System.out.println("Update blob Test running");
	Properties prop = new Properties();
	prop.put("user","user");
	prop.put("password","paswd");
	DatastoreJDBC ds = new DatastoreJDBC("jdbc:informix-sqli://host-name:1526/testbase:informixserver=server-name;db_locale=en_us.819",prop);
	ds.setDriver("com.informix.jdbc.IfxDriver");
	try {
	ds.connect();
	if (!ds.isConnected()) {
	    System.out.println("Couldn't connect to url");
	    System.exit(0);
	}
	if (ds.isAutoCommit())
	    ds.setAutoCommit(false);
	BlobDemoManager mgr = new BlobDemoManager();
	mgr.open(" where t1.idx="+arg[0]+" for update");
	if (mgr.fetchNext()) {
	    mgr.element().setData(new DAIOStream(arg[1]));
	    mgr.updateFetched();
	    ds.commit();
	    System.out.println("Record with key="+arg[0]+" was updated from "+arg[1]);
	} else 
	    System.out.println("Couldn't find record with key="+arg[0]);
	mgr.close();
	} catch(DAException ex) {
	    ex.printStackTrace(System.err);
	    System.err.println("Id: "+ex.getId()+", Property:"+ex.getProperty());
	    if (ex.getSQLException()!=null)
		System.err.println("SQL: "+ex.getSQLException().getMessage());
	    
	}
    }
}
