/*
 * Decompiled with CFR 0.152.
 */
package CalendarBean;

import CalendarBean.CalendarBnException;
import CalendarBean.CalendarBnListener;
import CalendarBean.CalendarBnListenerHandler;
import CalendarBean.GreaterThanMaxDateException;
import CalendarBean.InvalidDateException;
import CalendarBean.LessThanMinDateException;
import CalendarBean.calendarpanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.sql.Date;
import java.util.GregorianCalendar;

public class CalendarBn
extends Panel {
    public static final int dd_mm_yyyy = 1;
    public static final int mm_dd_yyyy = 2;
    public static final int dd_mmm_yyyy = 3;
    public static final int dd_mmmm_yyyy = 4;
    public static final int mmm_dd_yyyy = 5;
    public static final int mmmm_dd_yyyy = 6;
    public static final int ldow_dd_mmm_yyyy = 7;
    public static final int ldow_dd_mmmm_yyyy = 8;
    public static final int ldow_mmm_dd_yyyy = 9;
    public static final int ldow_mmmm_dd_yyyy = 10;
    public static final int sdow_dd_mmm_yyyy = 11;
    public static final int sdow_dd_mmmm_yyyy = 12;
    public static final int sdow_mmm_dd_yyyy = 13;
    public static final int sdow_mmmm_dd_yyyy = 14;
    private int dateformat = 13;
    calendarpanel calpan = new calendarpanel(this);
    boolean showtoday = true;
    boolean show_date_range = true;
    private Color CalendarBackground = Color.white;
    private Color CalendarArrowColor = Color.gray;
    private Color CalendarWeekdaysColor = Color.blue;
    private Color CalendarDaysColor = Color.black;
    private Color CalendarMonthColor = Color.black;
    private Color CalendarYearColor = Color.black;
    private Color CalendarMouseOverYearColor = Color.red;
    private Color CalendarSelectionColor = Color.red;
    private Color CalendarBorder = Color.gray;
    private boolean EditableYearVisible = true;
    private int CalWinWidth_EditableYearVisible = 290;
    private int CalWinWidth_EditableYearNotVisible = 250;
    private int CalWinWidth = this.CalWinWidth_EditableYearVisible;
    private int CalWinHeightNormal = 290;
    private int CalWinHeightApplet = 310;
    private int CalWinHeight = this.CalWinHeightNormal;
    Label caltitle;
    private GregorianCalendar vdt = new GregorianCalendar();
    CalendarBnListenerHandler dphl;
    Panel b1;
    Panel b2;
    Panel b3;
    Panel b4;
    Panel mainpanel;

    public CalendarBn() {
        this.init();
    }

    public CalendarBn(int n, int n2, int n3) throws CalendarBnException {
        this.setDate(n, n2, n3);
        this.init();
    }

    public CalendarBn(Date date) throws CalendarBnException {
        this.setDate(date);
        this.init();
    }

    public CalendarBn(Date date, Date date2, Date date3) throws CalendarBnException {
        this.setDate(date);
        this.setMinDate(date);
        this.setMaxDate(date);
        this.init();
    }

    public CalendarBn(GregorianCalendar gregorianCalendar) throws CalendarBnException {
        this.setDate(gregorianCalendar);
        this.init();
    }

    public CalendarBn(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2, GregorianCalendar gregorianCalendar3) throws CalendarBnException {
        this.setDate(gregorianCalendar);
        this.setMinDate(gregorianCalendar);
        this.setMaxDate(gregorianCalendar);
        this.init();
    }

    public static int CompareDates(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n4) {
            return -1;
        }
        if (n > n4) {
            return 1;
        }
        if (n2 < n5) {
            return -1;
        }
        if (n2 > n5) {
            return 1;
        }
        if (n3 < n6) {
            return -1;
        }
        if (n3 > n6) {
            return 1;
        }
        return 0;
    }

    public static int CompareDates(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar2.get(1);
        int n5 = gregorianCalendar2.get(2);
        int n6 = gregorianCalendar2.get(5);
        return CalendarBn.CompareDates(n, n2, n3, n4, n5, n6);
    }

    void NewDateSelected() {
        this.dphl.FireNewDateSelected();
    }

    public int addCalendarBnListener(CalendarBnListener calendarBnListener) {
        int n = this.dphl.addCalendarBnListener(calendarBnListener);
        return n;
    }

    public Color getArrowColor() {
        return this.CalendarArrowColor;
    }

    public Color getBackground() {
        return this.CalendarBackground;
    }

    public Color getBorderColor() {
        return this.CalendarBorder;
    }

    public String getDOW(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(7);
        return this.calpan.mp.wd[0].getWeekDay(n - 1);
    }

    public GregorianCalendar getDate() {
        GregorianCalendar gregorianCalendar = this.calpan.getDate();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public int getDateFormat() {
        return this.dateformat;
    }

    public CalendarBn getDateValues() {
        return this;
    }

    public int getDay() {
        return this.getDayFrom(this.getDate());
    }

    public int getDayFrom(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(5);
    }

    public Color getDaysColor() {
        return this.CalendarDaysColor;
    }

    public boolean getEditableYearVisible() {
        return this.EditableYearVisible;
    }

    public String getFormat() {
        String string;
        switch (this.dateformat) {
            case 1: {
                string = "dd_mm_yyyy";
                break;
            }
            case 2: {
                string = "mm_dd_yyyy";
                break;
            }
            case 3: {
                string = "dd_mmm_yyyy";
                break;
            }
            case 4: {
                string = "dd_mmmm_yyyy";
                break;
            }
            case 5: {
                string = "mmm_dd_yyyy";
                break;
            }
            case 6: {
                string = "mmmm_dd_yyyy";
                break;
            }
            case 7: {
                string = "ldow_dd_mmm_yyyy";
                break;
            }
            case 8: {
                string = "ldow_dd_mmmm_yyyy";
                break;
            }
            case 9: {
                string = "ldow_mmm_dd_yyyy";
                break;
            }
            case 10: {
                string = "ldow_mmmm_dd_yyyy";
                break;
            }
            case 11: {
                string = "sdow_dd_mmm_yyyy";
                break;
            }
            case 12: {
                string = "sdow_dd_mmmm_yyyy";
                break;
            }
            case 13: {
                string = "sdow_mmm_dd_yyyy";
                break;
            }
            case 14: {
                string = "sdow_mmmm_dd_yyyy";
                break;
            }
            default: {
                string = "sdow_mmm_dd_yyyy";
            }
        }
        if (this.getDateFormat() <= 9) {
            return "0" + this.getDateFormat() + ". " + string;
        }
        return this.getDateFormat() + ". " + string;
    }

    public String getFormattedDate() {
        return this.calpan.getDateFormat(this.getDate(), this.dateformat);
    }

    public String getFormattedDate(GregorianCalendar gregorianCalendar, int n) {
        return this.calpan.getDateFormat(gregorianCalendar, n);
    }

    public GregorianCalendar getMaxDate() {
        GregorianCalendar gregorianCalendar = this.calpan.getMaxDate();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public GregorianCalendar getMinDate() {
        GregorianCalendar gregorianCalendar = this.calpan.getMinDate();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public int getMonth() {
        return this.getMonthFrom(this.getDate());
    }

    public Color getMonthColor() {
        return this.CalendarMonthColor;
    }

    public int getMonthFrom(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(2) + 1;
    }

    public String getMonthStr(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(2);
        return this.calpan.bp.mylrp.myp.getMonth(n, 2);
    }

    public Color getMouseOverYear_Color() {
        return this.CalendarMouseOverYearColor;
    }

    public Color getSelectionColor() {
        return this.CalendarSelectionColor;
    }

    public boolean getShowDateRange() {
        return this.show_date_range;
    }

    public boolean getShowToday() {
        return this.showtoday;
    }

    public String getTitle() {
        return this.caltitle.getText();
    }

    public Color getTitleBackground() {
        return this.caltitle.getBackground();
    }

    public Color getTitleColor() {
        return this.caltitle.getForeground();
    }

    public Color getWeekdaysColor() {
        return this.CalendarWeekdaysColor;
    }

    public int getYear() {
        return this.getYearFrom(this.getDate());
    }

    public Color getYearColor() {
        return this.CalendarYearColor;
    }

    public int getYearFrom(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(1);
    }

    private void init() {
        this.setSize(300, 300);
        String[] stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", " Thu", " Fri", "Sat"};
        String[] stringArray2 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        GregorianCalendar gregorianCalendar = this.getDate();
        int n = gregorianCalendar.get(7);
        String string = String.valueOf(stringArray[n - 1]) + ", " + stringArray2[this.getMonth() - 1] + " " + this.getDay() + ", " + this.getYear();
        this.dateformat = 13;
        this.dphl = new CalendarBnListenerHandler(this);
        this.caltitle = new Label("Select Date");
        this.caltitle.setAlignment(1);
        this.caltitle.setFont(new Font("SansSerif", 1, 15));
        this.setBackground(Color.white);
        this.setWeekdaysColor(Color.blue);
        this.mainpanel = new Panel();
        this.mainpanel.setLayout(new BorderLayout());
        this.mainpanel.add((Component)this.caltitle, "North");
        this.mainpanel.add((Component)this.calpan, "Center");
        this.b1 = new Panel();
        this.b2 = new Panel();
        this.b3 = new Panel();
        this.b4 = new Panel();
        this.setBorderColor(this.CalendarBorder);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.minimumLayoutSize(this.mainpanel);
        this.setLayout(borderLayout);
        this.add((Component)this.mainpanel, "Center");
        this.add((Component)this.b1, "East");
        this.add((Component)this.b2, "West");
        this.add((Component)this.b3, "North");
        this.add((Component)this.b4, "South");
        this.caltitle.setBackground(Color.lightGray);
    }

    private boolean isDateValid(int n, int n2, int n3) {
        this.vdt.set(n, --n2, n3);
        return n == this.vdt.get(1) && n2 == this.vdt.get(2) && n3 == this.vdt.get(5);
    }

    public int removeCalendarBnListener(CalendarBnListener calendarBnListener) {
        int n = this.dphl.removeCalendarBnListener(calendarBnListener);
        return n;
    }

    public void setArrowColor(Color color) {
        this.CalendarArrowColor = color;
        this.setCalendarColors();
    }

    public void setBackground(Color color) {
        this.CalendarBackground = color;
        this.setCalendarColors();
    }

    public void setBorderColor(Color color) {
        this.CalendarBorder = color;
        this.b1.setBackground(color);
        this.b2.setBackground(color);
        this.b3.setBackground(color);
        this.b4.setBackground(color);
    }

    void setCalendarColors() {
        this.calpan.setColors(this.CalendarBackground, this.CalendarArrowColor, this.CalendarWeekdaysColor, this.CalendarDaysColor, this.CalendarMonthColor, this.CalendarYearColor, this.CalendarMouseOverYearColor, this.CalendarSelectionColor);
    }

    public void setDate(int n, int n2, int n3) throws CalendarBnException {
        if (!this.isDateValid(n, n2, n3)) {
            throw new InvalidDateException();
        }
        if (CalendarBn.CompareDates(new GregorianCalendar(n, n2 - 1, n3), this.getDate()) == 0) {
            return;
        }
        int n4 = CalendarBn.CompareDates(new GregorianCalendar(n, n2 - 1, n3), this.calpan.getMinDate());
        if (n4 == -1) {
            throw new LessThanMinDateException();
        }
        n4 = CalendarBn.CompareDates(new GregorianCalendar(n, n2 - 1, n3), this.calpan.getMaxDate());
        if (n4 == 1) {
            throw new GreaterThanMaxDateException();
        }
        this.calpan.setDate(n, n2, n3);
        this.NewDateSelected();
    }

    public void setDate(Date date) throws CalendarBnException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setDate(gregorianCalendar);
    }

    public void setDate(GregorianCalendar gregorianCalendar) throws CalendarBnException {
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
        this.setDate(gregorianCalendar2.get(1), gregorianCalendar2.get(2) + 1, gregorianCalendar2.get(5));
    }

    public void setDateFormat(int n) {
        this.dateformat = n;
        this.calpan.setDateFormat();
    }

    public void setDateValues(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        try {
            this.setDate(n, n2, n3);
            this.setMinDate(n4, n5, n6);
            this.setMaxDate(n7, n8, n9);
        }
        catch (CalendarBnException calendarBnException) {}
    }

    public void setDateValues(CalendarBn calendarBn) {
        try {
            this.setDate(calendarBn.getDate());
            this.setMinDate(calendarBn.getMinDate());
            this.setMaxDate(calendarBn.getMaxDate());
        }
        catch (CalendarBnException calendarBnException) {}
    }

    public void setDaysColor(Color color) {
        this.CalendarDaysColor = color;
        this.setCalendarColors();
    }

    public void setEditableYearVisible(boolean bl) {
        if (this.EditableYearVisible != bl) {
            this.EditableYearVisible = bl;
            this.calpan.setEditableYearVisible(bl);
            this.CalWinWidth = bl ? this.CalWinWidth_EditableYearVisible : this.CalWinWidth_EditableYearNotVisible;
        }
    }

    public void setFormat(String string) {
        try {
            int n;
            this.dateformat = n = Integer.parseInt(string.substring(0, 2));
            this.calpan.setDateFormat();
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setMaxDate(int n, int n2, int n3) throws CalendarBnException {
        if (!this.isDateValid(n, n2, n3)) {
            throw new InvalidDateException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3);
        this.setMaxDate(gregorianCalendar);
    }

    public void setMaxDate(Date date) throws LessThanMinDateException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setMaxDate(gregorianCalendar);
    }

    public void setMaxDate(GregorianCalendar gregorianCalendar) throws LessThanMinDateException {
        block4: {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
            if (CalendarBn.CompareDates(gregorianCalendar2, this.getMaxDate()) == 0) {
                return;
            }
            int n = CalendarBn.CompareDates(gregorianCalendar2, this.calpan.getMinDate());
            if (n == -1) {
                throw new LessThanMinDateException();
            }
            this.calpan.setMaxDate(gregorianCalendar2);
            n = 0;
            n = CalendarBn.CompareDates(gregorianCalendar2, this.calpan.getDate());
            if (n != -1) break block4;
            try {
                this.setDate(gregorianCalendar2);
            }
            catch (CalendarBnException calendarBnException) {}
        }
    }

    public void setMinDate(int n, int n2, int n3) throws CalendarBnException {
        if (!this.isDateValid(n, n2, n3)) {
            throw new InvalidDateException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3);
        this.setMinDate(gregorianCalendar);
    }

    public void setMinDate(Date date) throws GreaterThanMaxDateException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setMinDate(gregorianCalendar);
    }

    public void setMinDate(GregorianCalendar gregorianCalendar) throws GreaterThanMaxDateException {
        block4: {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
            if (CalendarBn.CompareDates(gregorianCalendar2, this.getMinDate()) == 0) {
                return;
            }
            int n = CalendarBn.CompareDates(gregorianCalendar2, this.calpan.getMaxDate());
            if (n == 1) {
                throw new GreaterThanMaxDateException();
            }
            this.calpan.setMinDate(gregorianCalendar2);
            n = 0;
            n = CalendarBn.CompareDates(gregorianCalendar2, this.calpan.getDate());
            if (n != 1) break block4;
            try {
                this.setDate(gregorianCalendar2);
            }
            catch (CalendarBnException calendarBnException) {}
        }
    }

    public void setMonthColor(Color color) {
        this.CalendarMonthColor = color;
        this.setCalendarColors();
    }

    public void setMouseOverYear_Color(Color color) {
        this.CalendarMouseOverYearColor = color;
        this.setCalendarColors();
    }

    public void setSelectionColor(Color color) {
        this.CalendarSelectionColor = color;
        this.setCalendarColors();
    }

    public void setShowDateRange(boolean bl) {
        this.showDateRange(bl);
    }

    public void setShowToday(boolean bl) {
        this.showToday(bl);
    }

    public void setTitle(String string) {
        this.caltitle.setText(string);
    }

    public void setTitleBackground(Color color) {
        this.caltitle.setBackground(color);
    }

    public void setTitleColor(Color color) {
        this.caltitle.setForeground(color);
    }

    public void setWeekdaysColor(Color color) {
        this.CalendarWeekdaysColor = color;
        this.setCalendarColors();
    }

    public void setYearColor(Color color) {
        this.CalendarYearColor = color;
        this.setCalendarColors();
    }

    public void showDateRange(boolean bl) {
        if (this.show_date_range == bl) {
            return;
        }
        this.show_date_range = bl;
        this.calpan.showInCalendar(this.showtoday, this.show_date_range);
    }

    public void showToday(boolean bl) {
        if (this.showtoday == bl) {
            return;
        }
        this.showtoday = bl;
        this.calpan.showInCalendar(this.showtoday, this.show_date_range);
    }

    public String toString() {
        String string = "Current Date :" + this.getFormattedDate(this.getDate(), 10) + "\n";
        string = String.valueOf(string) + "Min Date :" + this.getFormattedDate(this.getMinDate(), 10) + "\n";
        string = String.valueOf(string) + "Max Date :" + this.getFormattedDate(this.getMaxDate(), 10) + "\n";
        return string;
    }
}

