/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.util;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.ExceptionDispatch;
import com.borland.jb.util.VetoException;
import com.borland.jb.util.VetoableDispatch;
import java.util.EventListener;

public class EventMulticaster {
    protected transient EventListener[] listeners;

    public static final EventMulticaster merge(EventMulticaster destCaster, EventMulticaster sourceCaster) {
        EventListener[] source = sourceCaster.listeners;
        if (destCaster == null) {
            destCaster = new EventMulticaster();
        }
        if (source != null) {
            for (int index = 0; index < source.length; ++index) {
                if (destCaster.find(source[index]) != -1) continue;
                destCaster = EventMulticaster.add(destCaster, source[index]);
            }
        }
        return destCaster;
    }

    public int getListenerCount() {
        return this.listeners != null ? this.listeners.length : 0;
    }

    public static final EventMulticaster remove(EventMulticaster caster, EventListener listener) {
        if (caster != null) {
            caster.remove(listener);
            if (!caster.hasListeners()) {
                caster = null;
            }
        }
        return caster;
    }

    public static final EventMulticaster add(EventMulticaster caster, EventListener listener) {
        if (caster == null) {
            caster = new EventMulticaster();
        }
        caster.add(listener);
        return caster;
    }

    public final synchronized void remove(EventListener listener) {
        int index = this.find(listener);
        if (index > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                EventListener[] newListeners = new EventListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, index);
                if (index < newListeners.length) {
                    System.arraycopy(this.listeners, index + 1, newListeners, index, newListeners.length - index);
                }
                this.listeners = newListeners;
            }
        }
    }

    public final synchronized void add(EventListener listener) {
        if (this.find(listener) < 0) {
            EventListener[] newListeners;
            if (this.listeners == null) {
                newListeners = new EventListener[1];
            } else {
                newListeners = new EventListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            }
            newListeners[newListeners.length - 1] = listener;
            this.listeners = newListeners;
        }
    }

    public int find(EventListener listener) {
        if (this.listeners != null) {
            for (int index = 0; index < this.listeners.length; ++index) {
                if (this.listeners[index] != listener) continue;
                return index;
            }
        }
        return -1;
    }

    public final void exceptionDispatch(ExceptionDispatch e2) throws Exception {
        EventListener[] listenersCopy = this.listeners;
        if (listenersCopy != null) {
            int count = listenersCopy.length;
            for (int index = 0; index < count; ++index) {
                e2.exceptionDispatch(listenersCopy[index]);
            }
        }
    }

    public final boolean vetoableDispatch(VetoableDispatch e2) {
        EventListener[] listenersCopy = this.listeners;
        try {
            if (listenersCopy != null) {
                int count = listenersCopy.length;
                for (int index = 0; index < count; ++index) {
                    e2.vetoableDispatch(listenersCopy[index]);
                }
            }
        }
        catch (VetoException ex) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final void dispatch(DispatchableEvent e2) {
        EventListener[] listenersCopy = this.listeners;
        if (listenersCopy != null) {
            int count = listenersCopy.length;
            for (int index = 0; index < count; ++index) {
                e2.dispatch(listenersCopy[index]);
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }
}

