/*
 * Decompiled with CFR 0.152.
 */
package hsplitter.control;

import hsplitter.model.Config;
import hsplitter.model.HtmlDoc;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;

public class HSplitLogic {
    private static final boolean DEBUG = true;
    public static final int ISHTML_OK = 0;
    public static final int ISHTML_NONFILE = 1;
    public static final int ISHTML_NONTEXT = 2;
    public static final int ISHTML_NONHTML = 3;
    public static final int ISHTML_BADHTML = 4;
    private HtmlDoc thehtml = null;
    private Config config = Config.load();
    private boolean configFromFile = true;
    ProgressEventListener progressListener;

    public HSplitLogic() {
        if (this.config == null) {
            this.configFromFile = false;
            this.config = new Config();
            System.out.println("INFO: Using default configuration");
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean isConfigFromFile() {
        return this.configFromFile;
    }

    public int setAndTestHtmlFile(File fil) {
        this.thehtml = new HtmlDoc(this.config, fil);
        return 0;
    }

    public boolean splitHtml() {
        int count = 0;
        this.displayProgress("", 1);
        boolean OK = this.thehtml.open();
        this.displayProgress(this.thehtml.getErrMessage(), 3);
        if (!OK) {
            this.displayProgress(".", 2);
            return false;
        }
        this.displayProgress("INFO: SEGMENTING", 3);
        int retval = 1;
        while (retval > 0) {
            count += retval;
            retval = this.thehtml.segmentIt(1);
            if (retval > 0) {
                this.displayProgress("INFO: Nb Segments read = ".concat(String.valueOf(String.valueOf(count))), 3);
                continue;
            }
            this.displayProgress(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.thehtml.getErrMessage()))).append("  for segment reading ").append(count))), 3);
        }
        if (retval == -2 || retval == -3) {
            this.displayProgress(".", 2);
            return false;
        }
        retval = this.thehtml.nameTheSegments();
        if (retval > 0) {
            this.displayProgress("INFO: Nb named segments = ".concat(String.valueOf(String.valueOf(retval))), 3);
        } else {
            this.displayProgress(String.valueOf(String.valueOf(this.thehtml.getErrMessage())).concat("  at Naming phase"), 3);
        }
        if (retval == -2 || retval == -3) {
            this.displayProgress(".", 2);
            return false;
        }
        retval = this.thehtml.relinkSegments();
        if (retval > 0) {
            this.displayProgress("INFO: Nb links = ".concat(String.valueOf(String.valueOf(retval))), 3);
        } else {
            this.displayProgress(String.valueOf(String.valueOf(this.thehtml.getErrMessage())).concat("  at Linking phase"), 3);
        }
        count = 0;
        retval = 1;
        while (retval > 0) {
            retval = this.thehtml.saveSegments(1);
            count += retval;
            if (retval > 0) {
                this.displayProgress("INFO: Nb Segments saved = ".concat(String.valueOf(String.valueOf(count))), 3);
                continue;
            }
            this.displayProgress(this.thehtml.getErrMessage(), 3);
        }
        if (this.config.doTOC) {
            retval = this.thehtml.prepareTOC();
            this.displayProgress(String.valueOf(String.valueOf(this.thehtml.getErrMessage())).concat("  at TOC buildup"), 3);
        }
        if (this.config.doJavaHelpMeta) {
            retval = this.thehtml.prepareJavaHelp();
            this.displayProgress(String.valueOf(String.valueOf(this.thehtml.getErrMessage())).concat("  at JavaHelp buildup"), 3);
        }
        this.displayProgress(".", 2);
        return true;
    }

    public static void main(String[] args) {
        HSplitLogic HSplitLogic1 = new HSplitLogic();
    }

    public void addProgressEventListener(ProgressEventListener pl) {
        this.progressListener = pl;
    }

    public void removeProgressEventListener() {
        this.progressListener = null;
    }

    public void displayProgress(String message, int action) {
        ProgressEvent pev = new ProgressEvent(this, this, message, action);
        this.progressListener.progressReported(pev);
    }

    static {
        DEBUG = true;
        ISHTML_OK = 0;
        ISHTML_NONFILE = 1;
        ISHTML_NONTEXT = 2;
        ISHTML_NONHTML = 3;
        ISHTML_BADHTML = 4;
    }

    public static interface ProgressEventListener
    extends EventListener {
        public void progressReported(ProgressEvent var1);
    }

    public class ProgressEvent
    extends EventObject {
        public static final int PROGRESS_NONE = 0;
        public static final int PROGRESS_TITLE = 1;
        public static final int PROGRESS_STOP = 2;
        public static final int PROGRESS_LIST = 3;
        public static final int PROGRESS_MSG_RARE = 4;
        public static final int PROGRESS_MSG_FREQUENT = 5;
        public static final int PROGRESS_VAL_RARE = 6;
        public static final int PROGRESS_VAL_FREQUENT = 7;
        public static final int PROGRESS_REPORT = 12;
        int action = 0;
        String message;

        public ProgressEvent(HSplitLogic this$0, Object source, String msg, int act) {
            super(source);
            this.message = msg;
            this.action = act;
        }

        public String getMessage() {
            return this.message;
        }

        public int getAction() {
            return this.action;
        }

        public Object getSource() {
            return null;
        }

        public String toString() {
            return null;
        }

        static {
            PROGRESS_NONE = 0;
            PROGRESS_TITLE = 1;
            PROGRESS_STOP = 2;
            PROGRESS_LIST = 3;
            PROGRESS_MSG_RARE = 4;
            PROGRESS_MSG_FREQUENT = 5;
            PROGRESS_VAL_RARE = 6;
            PROGRESS_VAL_FREQUENT = 7;
            PROGRESS_REPORT = 12;
        }
    }
}

