#! /usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
# Quick Website News
#
# verify.cgi - for adding an item to the db. The add.html pages sends its data to this script.

use htmlgen;
use qwnui;
use config;
use encode;
use session;

print "Content-Type: text\/html\n\n<html><head><title>QWN: Add News Item..</title><link href=\"style.css\" typ=text/css rel=stylesheet></head><body>";
qwnui::qwnheader;


# work out where its coming from
if ($ENV[REQUEST_METHOD] eq "GET") {
$in=$ENV[QUERY_STRING];
}
else{
$in = <STDIN>;
}

# fix encoded data
$in =~ s/\+/ /g;
@detail = split(/&/, $in);

# print "<p>IN = $in";

if ($detail[$#detail] eq "preview=on") {
# Show a preview screen
        print "<br><br><table border=0 width=100%><tr><th rowspan=5 width=20%>";
        print "<th width=60% colspan=2><h2>Verify details</h2><th rowspan=5 width=20%>";
        print "<form action=\"verify.cgi\" method=post>";
        foreach $detail(@detail){
                %detail = split(/=/,$detail);
                while (($name,$value) = each %detail){
                        if ($name ne "preview"){
                                $value =~ s/%0D%0A/\<br\>/g;
                                $uname=&encode::unencode($name);
                                $uvalue=&encode::unencode($value);
                                print "<tr><td><p align=right>$uname:<td>$uvalue";
                                print "<input type=hidden name=\"$name\" value=\"$value\">";
                        }
                }
        }
        print "<tr><td colspan=2><p align=center><input type=submit value=\"Accept\">";
        print "<a href=\"javascript:history[0]\">[Back / Cancel]</a></form>";
        print "</table><p>Press the Back Button in your browser to correct any errors,";
        print " otherwise press the accept button to add the news item and regenerate the HTML pages.";
        print "</body></html>";
         &config::savesess;
}
else{
# Not preview, just write to file.
        # print "Input: $in\n\n";
        $entry = time . "#";
        foreach $detail(@detail){
                %detail = split(/=/,$detail);
                while (($name,$value) = each %detail){
                        $value =~ s/%0D%0A/<br>/s;
                        $entry .= &encode::unencode($value) . "#";
                }
        }
        # Write to the end of the file
        $entry .= "\n";
        open (NEWS,">>config/$session::newsdb") || print "Unable to write to database file $session::newsdb";
        print NEWS "$entry";
        close (NEWS);

        print "<br><br>Generating HTML Pages: ";
        htmlgen::makehtml;
        print "<br><br><p align=center> <a href=\"add.cgi\">[Add Another Item]</a>";
        print "&nbsp;&nbsp;&nbsp;<a href=\"view.cgi\">[View / Edit Items]</a>";
        print "&nbsp;&nbsp;&nbsp;<a href=\"index.cgi\">[Return To Start Page]</a>";

        &config::savesess;
}


