#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
#
# config.pm - module for loading and saving configurations.

# save data between cgis in a session.pm module.
# write it as a simple package to store the data.
# Will then save projects to a configuration file at log out. - Need this to be able to have multiple projects.


package config;

use checksess;

sub savesession{
        open(SESS,">session.pm");
        print SESS  "\#!/usr/bin/perl\n\#\n";
        print SESS  "\# QWN - Session.pm - current session variables\n\n";
        print SESS  "package session;\n\n";

        print SESS  "# Session Details - mostly for security\n";
        print SESS  "\$remoteaddr=\"$session::remoteaddr\";\n";
        print SESS  "\$remotehost=\"$session::remotehost\";\n";
        print SESS  "\$expires=\"$session::expires\";\n";
        print SESS  "\$httpuseragent=\"$session::httpuseragent\";\n\n\n";

        print SESS  "# Current Project Details\n";
        print SESS  "\$projloaded=$session::projloaded;\n";
        print SESS  "\$projname=\"$session::projname\";\n";
        print SESS  "\$filename=\"$session::filename\";\n";
        print SESS  "\$defauthor=\"$session::defauthor\";\n";
        print SESS  "\$htmldir=\"$session::htmldir\";\n";
        print SESS  "\$newsdb=\"$session::newsdb\";\n";
        print SESS  "\$firstfile=\"$session::firstfile\";\n";
        print SESS  "\$otherfiles=\"$session::otherfiles\";\n";
        print SESS  "\$firstpagecount=$session::firstpagecount;\n";
        print SESS  "\$otherpagecount=$session::otherpagecount;\n";
        print SESS  "\$firsthtmlstart=\"$session::firsthtmlstart\";\n";
        print SESS  "\$firsthtmlend=\"$session::firsthtmlend\";\n";
        print SESS  "\$htmlstart=\"$session::htmlstart\";\n";
        print SESS  "\$htmlend=\"$session::htmlend\";\n";
        print SESS  "\$firstitemtemplate=\"$session::firstitemtemplate\";\n";
        print SESS  "\$otheritemtemplate=\"$session::otheritemtemplate\";\n";
        print SESS  "\$dateformat=\"$session::dateformat\";\n";
        print SESS  "\$backupfrequency=\"$session::backupfrequency\";\n";
        print SESS  "\$hostsallow=\"$session::hostsallow\";\n";
        print SESS  "\$hostsdeny=\"$session::hostsdeny\";\n";
        print SESS  "\$password=\"$session::password\";\n";
        print SESS  "1;";

        close (SESS);
        1;
}

sub getprojname{
# returns project name from input of filename;
        open CONFFILE, "config/@_[0]";
        @conffile=<CONFFILE>;
        close CONFFILE;
        $result="@_[0] - No Title Found";
        foreach $entry (@conffile){
             #   print "$entry";
                chomp($entry);
                # ignore white space and comments.
                if (($entry =~ /^#/)) { next;   }
                if ( $entry =~ s/^projname=// ) { $result=$entry; last; }
        }
        $result;
}

sub loadconf{
        # Loads a config file into memory from @_[0]  (= filename)
        # if @_[1] (password) is correct
        # Also check the hosts to allow and deny
        if (not -e "config/@_[0]"){ return 2;
        }else{
        open CONFFILE, &encode::unencode("<config/@_[0]") || print "open failed  -    config/@_[0]"; #"die "unable to open configuration";
        @conffile=<CONFFILE>;
        close CONFFILE;


        foreach $entry (@conffile){
                chomp($entry);
                # ignore white space and comments.
                if ($entry =~ /^#/) { next;   }
                if ( $entry =~ s/^projname=// ) { $session::projname=$entry; }
                elsif ( $entry =~ s/^htmldir=//) { $session::htmldir=$entry;}
                elsif ( $entry =~ s/^newsdb=//) { $session::newsdb=$entry;}
                elsif ( $entry =~ s/^firstfile=//) {$session::firstfile=$entry;}
                elsif ( $entry =~ s/^defauthor=//) {$session::defauthor=$entry;}
                elsif ( $entry =~ s/^otherfiles=//) {$session::otherfiles=$entry;}
                elsif ( $entry =~ s/^firstpagecount=//) {$session::firstpagecount=$entry;}
                elsif ( $entry =~ s/^otherpagecount=//) {$session::otherpagecount=$entry;}
                elsif ( $entry =~ s/^firsthtmlstart=//) {$session::firsthtmlstart=$entry;}
                elsif ( $entry =~ s/^firsthtmlend=//) {$session::firsthtmlend=$entry;}
                elsif ( $entry =~ s/^htmlstart=//) {$session::htmlstart=$entry;}
                elsif ( $entry =~ s/^htmlend=//) {$session::htmlend=$entry;}
                elsif ( $entry =~ s/^firstitemtemplate=//) {$session::firstitemtemplate=$entry;}
                elsif ( $entry =~ s/^otheritemtemplate=//) {$session::otheritemtemplate=$entry;}
                elsif ( $entry =~ s/^dateformat=//) {$session::dateformat=$entry;}
                elsif ( $entry =~ s/^backupfrequency=//) {$session::backupfrequency=$entry;}
                elsif ( $entry =~ s/^hostsallow=//) {$session::hostsallow=$entry;}
                elsif ( $entry =~ s/^hostsdeny=//) {$session::hostsdeny=$entry;}
                elsif ( $entry =~ s/^password=//) {$session::password=$entry;}

                $session::projloaded=1;
                $session::remoteaddr=$ENV{REMOTE_ADDR};
                $session::remotehost=$ENV{REMOTE_HOST};
                $session::httpuseragent=$ENV{HTTP_USER_AGENT};
                $t=time;
                $session::expires=$t+$checksess::timeout;
                &savesession;
        }

        $session::filename=@_[0];
        # a few permission checks
        $permission=1;
        # Check Password
        if ($session::password ne @_[1]){
                &clearsess;
                return 1;
        }
        # check hosts to allow and deny;
        if ($session::hostsallow ne "*"){
                $allow=0;
                @allowed=split(/,/,$session::hostsallow);
                foreach $allowedhost(@allowed){
                        if (($allowedhost eq $ENV{REMOTE_HOST})||($allowedhost eq $ENV{REMOTE_ADDR})) { $allow=1;}
                }
                if ($allow==0){
                        &clearsess;
                        $permission=0;
                        return 3;
                }
        }
        if ($session::hoastsdeny ne ""){
                @denied=split(/,/,$session::hostsdeny);
                $allow=1;
                foreach $deniedhost(@denied){
                        if (($deniedhost eq $ENV{REMOTE_ADDR})||($deniedhost eq $ENV{REMOTE_HOST})){   $allow=0;   }
                }
                if ($allow==0){
                        &clearsess;
                        $permission=0;
                        return 4;
                }
        }
         # user has permission
         if ($permission==1){
                &savesession;
                return 0;
        }
        } # - end of file exists bit.
}

sub clearsess{
        $session::remoteaddr="";
        $session::remotehost="";
        $session::httpuseragent="";

        $session::projloaded=0;
        $session::projname="";
        $session::filename="";
        $session::defauthor="";
        $session::htmldir="";
        $session::newsdb="";
        $session::firstfile="";
        $session::otherfiles="";
        $session::firstpagecount=0;
        $session::otherpagecount=0;
        $session::firsthtmlstart="";
        $session::firsthtmlend="";
        $session::htmlstart="";
        $session::htmlend="";
        $session::firstitemtemplate="";
        $session::otheritemtemplate="";
        $session::dateformat="";
        $session::backupfrequency="";
        $session::hostsallow="*";
        $session::hostsdeny="";
        $session::password="";

        &savesession;
        1;
}

sub newsess{
        $session::remoteaddr=$ENV{REMOTE_ADDR};
        $session::remotehost=$ENV{REMOTE_HOST};
        $session::httpuseragent=$ENV{HTTP_USER_AGENT};

        $session::projloaded=1;
        $session::projname=@_[0];

        $fn = @_[0];
        $fn =~ s/ /_/g;

        $session::filename="$fn.qwn";
        $session::htmldir="/full_path/www/newsdir";
        $fn .="_news.db";
        $session::newsdb="$fn";
        $session::defauthor="Webmaster";
        $session::firstfile="news.html";
        $session::otherfiles="news_page<!--#PageNum-->.html";
        $session::firstpagecount=5;
        $session::otherpagecount=15;
        $session::firsthtmlstart=&encode::encode("\<html\>\<head\>\n\<title\>News: Page one\</title\>\n\</head\>\<body\>\n\<h1\>News - Page 1</h1>");
        $session::firsthtmlend=&encode::encode("\n<p align=center><a href=\"<!--#NextPage-->\">Older News</a>\n<p align=right>Created with <a href=\"<!--#QWN_URL-->\">QWN <!--#Version--></a>\n</body>\n</html>");
        $session::htmlstart=&encode::encode("<html><head>\n<title>News: Page one</title>\n</head><body>\n<h1>News - Page <!--#PageNum--></h1>\n Other News Pages: <!--#OtherPages-->");
        $session::htmlend=&encode::encode("<p align=center><a href=\"<!--#PrevPage-->\">Previous Page</a><a href=\"<!--#NextPage-->\">Next Page</a>\n<p align=right>Created with <a href=\"<!--#QWN_URL-->\">QWN <!--#Version--></a></body></html>");
        $session::firstitemtemplate=&encode::encode("<br><br>Date: <!--#ItemDate-->:&nbsp;&nbsp;&nbsp;Title: <!--#ItemTitle--><br>Content: <!--#Content-->");
        $session::otheritemtemplate=&encode::encode("<br><br>Date: <!--#ItemDate-->:&nbsp;&nbsp;&nbsp;Title: <!--#ItemTitle--><br>Content: <!--#Content-->");
        $session::dateformat="";
        $session::backupfrequency="";
        $session::hostsallow="*";
        $session::hostsdeny="";
        $session::password="";
        $t=time;
        $session::expires=$t+$checksess::timeout;
        &savesession;
        1;
}


sub saveconf{
        # saves a config to file AND CLEARS SESSION INFO.
        # Check loaded, etc.
        if (not $session::projloaded){
                print "<h1>Error: unable to save configuration: no project
loaded";
                print "<p>Return to the <a href=\"index.cgi\">portal page</a>
to load a project.";
                die "no project loaded";
        }
        open CONFFILE, ">config/$session::filename";

        print CONFFILE "# QWN Configuration file\n";
        print CONFFILE "# Version $checksess::version\n\n";
        print CONFFILE "projname=$session::projname\n";
        print CONFFILE "filename=$session::filename\n\n";
        print CONFFILE "password=$session::password\n";

        print CONFFILE "defauthor=$session::defauthor\n";
        print CONFFILE "htmldir=$session::htmldir\n";
        print CONFFILE "newsdb=$session::newsdb\n";
        print CONFFILE "firstfile=$session::firstfile\n";
        print CONFFILE "otherfiles=$session::otherfiles\n";
        print CONFFILE "firstpagecount=$session::firstpagecount\n";
        print CONFFILE "otherpagecount=$session::otherpagecount\n";
        print CONFFILE "firsthtmlstart=$session::firsthtmlstart\n";
        print CONFFILE "firsthtmlend=$session::firsthtmlend\n";
        print CONFFILE "htmlstart=$session::htmlstart\n";
        print CONFFILE "htmlend=$session::htmlend\n";
        print CONFFILE "firstitemtemplate=$session::firstitemtemplate\n";
        print CONFFILE "otheritemtemplate=$session::otheritemtemplate\n";
        print CONFFILE "dateformat=$session::dateformat\n";
        print CONFFILE "backupfrequency=$session::backupfrequency\n";
        print CONFFILE "hostsallow=$session::hostsallow\n";
        print CONFFILE "hostsdeny=$session::hostsdeny\n";

        close CONFFILE;
        &clearsess;
        0;
}

1;
