/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

public final class OS {
    public static final int JDK1_1 = 11;
    public static final int JDK1_2 = 12;
    public static final int JDK1_3 = 13;
    public static final int JDK1_4 = 14;
    private static boolean isWindows95;
    private static boolean isWindowsNT;
    private static boolean isWindows2000;
    private static boolean isMacintosh;
    private static boolean isSolaris;
    private static boolean isLinux;
    private static boolean isCaseSensitive;
    private static int jdkVersion;

    public static final boolean isWindows() {
        return OS.isWindows95() || OS.isWindowsNT() || OS.isWindows2000();
    }

    public static final boolean isWindows95() {
        return isWindows95;
    }

    public static final boolean isWindowsNT() {
        return isWindowsNT;
    }

    public static final boolean isWindows2000() {
        return isWindows2000;
    }

    public static final boolean isMacintosh() {
        return isMacintosh;
    }

    public static final boolean isSolaris() {
        return isSolaris;
    }

    public static final boolean isLinux() {
        return isLinux;
    }

    public static final boolean isUnix() {
        return OS.isSolaris() || OS.isLinux();
    }

    public static final boolean isCaseSensitive() {
        return isCaseSensitive;
    }

    public static final int getJDKVersion() {
        return jdkVersion;
    }

    public static final boolean isOneDotOne() {
        return jdkVersion == 11;
    }

    public static final boolean isOneDotTwo() {
        return jdkVersion == 12;
    }

    public static final boolean isOneDotThree() {
        return jdkVersion == 13;
    }

    public static final boolean isOneDotFour() {
        return jdkVersion == 14;
    }

    public static final boolean isOneDotThreeOrMore() {
        return jdkVersion >= 13;
    }

    public static final void openDocument(String path) throws Exception {
        if (OS.isWindows2000()) {
            Runtime.getRuntime().exec(new String[]{"cmd /c start", path});
        } else if (OS.isWindows()) {
            Runtime.getRuntime().exec(new String[]{"start", path});
        } else {
            System.err.println("OS.openDocument() not supported on this platform (" + System.getProperty("os.name"));
        }
    }

    private OS() {
    }

    static {
        jdkVersion = 11;
        String s = System.getProperty("os.name").toLowerCase();
        String version = System.getProperty("os.version").toLowerCase();
        if ("windows nt".equals(s) && "5.0".equals(version)) {
            isWindows2000 = true;
        } else if (s.equals("windows nt")) {
            isWindowsNT = true;
        } else if (s.startsWith("windows")) {
            isWindows95 = true;
        } else if (s.equals("macintosh") || s.equals("macos") || s.equals("mac os")) {
            isMacintosh = true;
        } else if (s.equals("sunos") || s.equals("solaris")) {
            isSolaris = true;
            isCaseSensitive = true;
        } else if (s.equals("linux")) {
            isLinux = true;
            isCaseSensitive = true;
        }
        try {
            Class.forName("java.lang.ref.WeakReference");
            jdkVersion = 12;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Class.forName("javax.swing.UIDefaults$LazyInputMap");
            jdkVersion = 13;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Class.forName("java.lang.CharSequence");
            jdkVersion = 14;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

