/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkStyle;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import com.l2fprod.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

class GtkButton
extends AbstractSkinButton
implements SkinButton {
    DefaultButton checkIN;
    DefaultButton checkOUT;
    DefaultButton optionIN;
    DefaultButton optionOUT;
    Icon disabledCheckIN;
    Icon disabledCheckOUT;
    Icon disabledOptionIN;
    Icon disabledOptionOUT;
    DefaultButton disabledButton;
    DefaultButton pressedButton;
    DefaultButton normalButton;
    DefaultButton rolloverButton;
    DefaultButton disabledButtonIN;
    DefaultButton toggleIN;
    DefaultButton toggleOUT;
    DefaultButton toggleRollover;

    public Dimension getCheckBoxIconSize() {
        if (this.checkIN != null) {
            return new Dimension(this.checkIN.getIconWidth(), this.checkIN.getIconHeight());
        }
        return new Dimension(13, 13);
    }

    public Dimension getRadioButtonIconSize() {
        if (this.optionIN != null) {
            return new Dimension(this.optionIN.getIconWidth(), this.optionIN.getIconHeight());
        }
        return new Dimension(13, 13);
    }

    public Icon getRadioIcon(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (b instanceof JRadioButton || b instanceof JRadioButtonMenuItem) {
            if (model.isSelected() || model.isPressed() && model.isArmed()) {
                return b.isEnabled() ? this.optionIN : this.disabledOptionIN;
            }
            if (!model.isEnabled()) {
                if (model.isSelected()) {
                    return b.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
                }
                return b.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
            }
            return b.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
        }
        if (b instanceof JCheckBox || b instanceof JCheckBoxMenuItem) {
            if (model.isSelected() || model.isPressed() && model.isArmed()) {
                return b.isEnabled() ? this.checkIN : this.disabledCheckIN;
            }
            if (!model.isEnabled()) {
                if (model.isSelected()) {
                    return b.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
                }
                return b.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
            }
            return b.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
        }
        return null;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        return true;
    }

    public boolean paintButton(Graphics g, AbstractButton b) {
        ButtonModel model = b.getModel();
        if (GtkUtils.DEBUG) {
            System.out.println("Button " + b.getClass().getName() + " " + b.getText());
            System.out.println("\tisEnabled() = " + model.isEnabled());
            System.out.println("\tisOpaque() = " + b.isOpaque());
            System.out.println("\tisArmed() = " + model.isArmed());
            System.out.println("\tisPressed() = " + model.isPressed());
            System.out.println("\tisSelected() = " + model.isSelected());
            System.out.println("\thasFocus() = " + b.hasFocus());
            System.out.println("\tisRollover() = " + model.isRollover());
        }
        if (!b.isEnabled()) {
            this.disabledButton.paint(g, b);
        } else if (b instanceof JToggleButton) {
            if (model.isArmed() && model.isPressed() || model.isSelected()) {
                this.toggleIN.paint(g, b);
            } else if (model.isRollover()) {
                this.toggleRollover.paint(g, b);
            } else {
                this.toggleOUT.paint(g, b);
            }
        } else if (b instanceof JButton) {
            if (model.isPressed() && (!b.isRolloverEnabled() || b.isRolloverEnabled() && model.isRollover())) {
                this.pressedButton.paint(g, b);
            } else if (model.isRollover()) {
                this.rolloverButton.paint(g, b);
            } else {
                this.normalButton.paint(g, b);
            }
        }
        return true;
    }

    public GtkButton(GtkParser parser) throws Exception {
        this.normalButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "NORMAL", "OUT"});
        this.pressedButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "ACTIVE", "IN"});
        this.disabledButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "INSENSITIVE", "OUT"});
        this.disabledButtonIN = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "INSENSITIVE", "IN"});
        this.rolloverButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"});
        this.toggleIN = GtkUtils.newButton(parser, "GtkToggleButton", new String[]{"function", "shadow"}, new String[]{"BOX", "IN"});
        this.toggleOUT = GtkUtils.newButton(parser, "GtkToggleButton", new String[]{"function", "shadow"}, new String[]{"BOX", "OUT"});
        this.toggleRollover = GtkUtils.newButton(parser, "GtkToggleButton", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"});
        GtkStyle defaultStyle = parser.getStyle("check");
        if (defaultStyle == null && (defaultStyle = parser.getStyle("checkradiobutton")) == null) {
            defaultStyle = parser.getStyle("default");
        }
        this.checkIN = GtkUtils.newButton(parser, "GtkCheckButton", new String[]{"function", "shadow"}, new String[]{"CHECK", "IN"});
        this.disabledCheckIN = ImageUtils.getDisabledIcon(this.checkIN.center);
        this.checkOUT = GtkUtils.newButton(parser, "GtkCheckButton", new String[]{"function", "shadow"}, new String[]{"CHECK", "OUT"});
        this.disabledCheckOUT = ImageUtils.getDisabledIcon(this.checkOUT.center);
        this.optionIN = GtkUtils.newButton(parser, "GtkRadioButton", new String[]{"function", "shadow"}, new String[]{"OPTION", "IN"});
        this.disabledOptionIN = ImageUtils.getDisabledIcon(this.optionIN.center);
        this.optionOUT = GtkUtils.newButton(parser, "GtkRadioButton", new String[]{"function", "shadow"}, new String[]{"OPTION", "OUT"});
        this.disabledOptionOUT = ImageUtils.getDisabledIcon(this.optionOUT.center);
    }
}

