/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.contrib.nanoxml.sax;

import com.l2fprod.contrib.nanoxml.XMLElement;
import com.l2fprod.contrib.nanoxml.XMLParseException;
import com.l2fprod.contrib.nanoxml.sax.SAXLocator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributeListImpl;

public class SAXParser
implements Parser {
    private DocumentHandler documentHandler = new HandlerBase();
    private ErrorHandler errorHandler = new HandlerBase();

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null || !locale.getLanguage().equals("en")) {
            throw new SAXException("NanoXML/SAX doesn't support locale: " + locale);
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void parse(InputSource source) throws SAXException, IOException {
        XMLElement topElement = this.createTopElement();
        Reader reader = source.getCharacterStream();
        SAXLocator locator = new SAXLocator(source.getSystemId());
        this.documentHandler.setDocumentLocator(locator);
        if (reader == null) {
            InputStream stream = source.getByteStream();
            String encoding = source.getEncoding();
            if (stream == null) {
                String systemId = source.getSystemId();
                if (systemId == null) {
                    SAXParseException saxException = new SAXParseException("Invalid input source", locator);
                    this.errorHandler.fatalError(saxException);
                    return;
                }
                try {
                    URL url = new URL(systemId);
                    stream = url.openStream();
                }
                catch (MalformedURLException exception) {
                    try {
                        stream = new FileInputStream(systemId);
                    }
                    catch (FileNotFoundException exception2) {
                        SAXParseException saxException = new SAXParseException(null, locator, exception2);
                        this.errorHandler.fatalError(saxException);
                        return;
                    }
                    catch (SecurityException exception2) {
                        SAXParseException saxException = new SAXParseException(null, locator, exception2);
                        this.errorHandler.fatalError(saxException);
                        return;
                    }
                }
            }
            if (encoding == null) {
                reader = new InputStreamReader(stream);
            } else {
                try {
                    reader = new InputStreamReader(stream, encoding);
                }
                catch (UnsupportedEncodingException exception) {
                    SAXParseException saxException = new SAXParseException(null, locator, exception);
                    this.errorHandler.fatalError(saxException);
                    return;
                }
            }
        }
        try {
            topElement.parseFromReader(reader);
        }
        catch (XMLParseException exception) {
            locator.setLineNr(exception.getLineNr());
            SAXParseException saxException = new SAXParseException(null, locator, exception);
            this.errorHandler.fatalError(saxException);
            this.documentHandler.endDocument();
            return;
        }
        locator.setLineNr(topElement.getLineNr());
        this.documentHandler.startDocument();
        this.handleSubTree(topElement, locator);
        this.documentHandler.endDocument();
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    protected XMLElement createTopElement() {
        return new XMLElement();
    }

    private final void handleSubTree(XMLElement element, SAXLocator locator) throws SAXException {
        AttributeListImpl attrList = new AttributeListImpl();
        locator.setLineNr(element.getLineNr());
        Enumeration enumeration = element.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = element.getProperty(key);
            attrList.addAttribute(key, "CDATA", value);
        }
        this.documentHandler.startElement(element.getTagName(), attrList);
        if (element.getContents() == null) {
            enumeration = element.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                this.handleSubTree((XMLElement)enumeration.nextElement(), locator);
            }
        } else {
            char[] chars = element.getContents().toCharArray();
            this.documentHandler.characters(chars, 0, chars.length);
        }
        locator.setLineNr(-1);
        this.documentHandler.endElement(element.getTagName());
    }
}

