/* AddressBook - AddressBookResources
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package addressbook;

import java.util.ListResourceBundle;

public class AddressBookResources extends ListResourceBundle {
    public final static String MENU_FILE = "File";
    public final static String MENU_NEWCONTACT = "New contact...";
    public final static String MENU_NEWBOOKMARK = "New bookmark...";
    public final static String MENU_NEWCOOKIE = "New cookie...";
    public final static String MENU_NEWGROUP = "New group...";
    public final static String MENU_NEWFOLDER = "New folder...";
    public final static String MENU_PROPERTIES = "Properties";
    public final static String MENU_DELETE = "Delete";
    public final static String MENU_IMPORT = "Import";
    public final static String MENU_EXPORT = "Export";
    public final static String MENU_ADDRBOOK = "Address Book...";
    public final static String MENU_BUSCARD = "Business Card(vCard)...";
    public final static String MENU_OTHERADDRBOOK = "Other Address Book...";
    public final static String MENU_PRINT = "Print";
    public final static String MENU_EXIT = "Exit";
    public final static String MENU_CLOSE = "Close";
    public final static String MENU_EDIT = "Edit";
    public final static String MENU_COPY = "Copy";
    public final static String MENU_PASTE = "Paste";
    public final static String MENU_PROFILE = "Profile...";
    public final static String MENU_FINDPEOPLE = "Find People...";
    public final static String MENU_SELECTALL = "Select all";
    public final static String MENU_VIEW = "View";
    public final static String MENU_TOOLBAR = "Toolbar";
    public final static String MENU_SYNCHRONIZE = "Synchronize now";
    public final static String MENU_FOLDERGROUP = "Folders and Groups";
    public final static String MENU_REFRESH = "Refresh";
    public final static String MENU_ACCOUNTS = "Accounts";
    public final static String MENU_STATUSBAR = "Statusbar";
    public final static String MENU_SORTBY = "Sort By";
    public final static String MENU_NAME = "Name";
    public final static String MENU_EMAILADDR = "E-Mail Address";
    public final static String MENU_BUSPHONE = "Business Phone";
    public final static String MENU_HOMEPHONE = "Home Phone";
    public final static String MENU_FIRSTNAME = "First Name";
    public final static String MENU_LASTNAME = "Last Name";
    public final static String MENU_ASC = "Ascending";
    public final static String MENU_DESC = "Descending";
    public final static String MENU_TOOLS = "Tools";
    public final static String MENU_OPTIONS = "Options";
    public final static String MENU_ACTION = "Action";
    public final static String MENU_SENDMAIL = "Send Mail";
    public final static String MENU_DIALTO = "Dial to";
    public final static String MENU_SHOWURL = "Show URL";
    public final static String MENU_APPCOOKIE = "Apply cookie";
    public final static String [] MENUS_ACTION = {MENU_SENDMAIL,
        MENU_DIALTO, MENU_SHOWURL, 
        MENU_APPCOOKIE};
    public final static String MENU_HELP = "Help";
    public final static String MENU_CONTENTS = "Contents";
    public final static String MENU_ABOUT = "About...";
    public final static String[] HEADER_ADDRBOOK =
    {MENU_NAME, MENU_EMAILADDR, MENU_BUSPHONE, MENU_HOMEPHONE };
    public final static String TAB_STORAGE = "Storage";
    public final static String TTIP_STORAGE = "Provide storage location of the address book source";
    public final static String LABEL_TNAMEORLIST = "Type name or select from list";
    public final static String LABEL_GLOBAL = "Global";
    public final static String LABEL_HOST = "Host";
    public final static String LABEL_LOCAL = "Local";
    public final static String LABEL_DB_URL = "JDBC URL";
    public final static String LABEL_SHAREADDR = "Share my address";
    public final static String LABEL_SYNCHRONIZE = "Synchronize";
    public final static String LABEL_LOGIN = "Login";
    public final static String LABEL_PASSWORD = "Password";
    public final static String LABEL_NAME = "Name";
    public final static String LABEL_ADDRESSES = "Addresses";
    public final static String LABEL_PHOTO = "Photo";
    public final static String LABEL_COMMENT = "Comment";

    public final static String TITLE_NEWCONTACT = "New Contact";
    
    public final static String TAB_GENERAL = "General";
    public final static String TAB_DETAILS = "Details";
    public final static String TAB_CERTIFICATES = "Certificates";

    public final static String TTIP_GENERALCONTACTINFO = "Specify general contact information here";
    public final static String TTIP_DETAILCONTACTINFO = "Provide more details for friend and/or partner";
    public final static String TTIP_CERTIFICATES = "Add certificates for signing and encryption";
    
    public final static String CMD_OK = "OK";
    public final static String CMD_APPLY = "<html><i>Apply";
    public final static String CMD_CANCEL = "Cancel";
    public final static String CMD_ADD = "Add";
    public final static String CMD_MODIFY = "Modify";
    public final static String CMD_DELETE = "Delete";

    public final static String EXT_GIF = ".gif";

    public final static String IMG_NEW = "New";
    public final static String IMG_PROPERTIES = "Properties"; //MENU_PROPERTIES;
    public final static String IMG_DELETE = MENU_DELETE;
    public final static String IMG_FINDPEOPLE = "Find";
    public final static String IMG_PRINT = MENU_PRINT;
    public final static String IMG_ACTION = MENU_ACTION;
    public final static String IMG_PROGRAM = "photoorganizer.jpg";

    public final static String URL_HELP = "../R-AddressBook.html";
    
    public final static int CTRL_VERT_SIZE = 20;
    public final static int CTRL_VERT_GAP = 4;
    public final static int CTRL_HORIS_INSET = 8;
    public final static int CTRL_HORIZ_GAP = 8;
    public final static java.awt.Dimension MIN_PANEL_DIMENSION = new java.awt.Dimension(40, 20);

    public Object[][] getContents() {
	return contents;
    }
    
    static final Object[][] contents = {
	{MENU_FILE, "File"},
	{"CancelKey", "Cancel"},
    };
}