/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <qapp.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qpainter.h>
#include <qimage.h>
#include <qcolor.h>
#include <qarray.h>
#include "zlib.h"
#include <stdlib.h>
#include <stdio.h>
//#include "menu.h"  
#include "menu.moc"   // also includes menu.h, which itself includes
                      // main.h & common.h

extern QPixmap *pixmap;
extern int pixx, pixy, picx, picy;
extern int xadd, yadd;

extern "C" unsigned char TitleImg[];
extern "C" long TitleImg_Length;
extern "C" long TitleImg_X, TitleImg_Y;

QuatMenu::QuatMenu(QWidget *parent, const char *name, QCmds *s_cmd = 0) : QWidget(parent, name)
{
   cmd = s_cmd;
   Image = new QPopupMenu();
   CHECK_PTR(Image);
   ID_ImageOpen = Image->insertItem("&Open...", cmd, SLOT(ImageOpen()));
   ID_ImageClose = Image->insertItem("&Close", cmd, SLOT(ImageClose()));
   ID_ImageSave = Image->insertItem("&Save", cmd, SLOT(ImageSave()));
   ID_ImageSaveAs = Image->insertItem("Save &As...", cmd, SLOT(ImageSaveAs()));
   Image->insertSeparator();
   ID_ImageAdjustWindow = Image->insertItem("Adjust &Window", cmd,
      SLOT(ImageAdjustWindow()));    
   Image->insertSeparator();
   Image->insertItem("A&bout", cmd, SLOT(ImageAbout()));
   ID_ImageExit = Image->insertItem("E&xit", cmd, SLOT(Exit()), CTRL+Key_Q);

   Calculation = new QPopupMenu();
   CHECK_PTR(Calculation);
   ID_CalculationStartImage = 
      Calculation->insertItem("Start / Resume an &image", cmd,
      SLOT(CalculationStartImage()));    
   ID_CalculationStartZBuf =
      Calculation->insertItem("Start / Resume a &ZBuffer", cmd,
      SLOT(CalculationStartZBuf()));
   ID_CalculationStop =
      Calculation->insertItem("St&op", cmd, SLOT(CalculationStop()));

   Parameters = new QPopupMenu();
   CHECK_PTR(Parameters);
   ID_ParametersObjectEditor = Parameters->insertItem("&Object Editor",
      cmd, SLOT(ParametersObjectEditor()));
   ID_ParametersViewEditor = Parameters->insertItem("&View Editor", 
      cmd, SLOT(ParametersViewEditor()));
   ID_ParametersColorEditor = Parameters->insertItem("&Color Editor", 
      cmd, SLOT(ParametersColorEditor()));
   ID_ParametersIntersectionEditor = Parameters->insertItem("Inter&section Editor",
      cmd, SLOT(ParametersIntersectionEditor()));
   ID_ParametersOther = Parameters->insertItem("O&ther Parameters", 
      cmd, SLOT(ParametersOther()));
   Parameters->insertSeparator();
   ID_ParametersReset = Parameters->insertItem("&Reset", cmd, 
      SLOT(ParametersReset()));
   ID_ParametersReadINI = Parameters->insertItem("Read from &INI...", 
      cmd, SLOT(ParametersReadINI()));
   ID_ParametersReadPNG = Parameters->insertItem("Read from &PNG...", 
      cmd, SLOT(ParametersReadPNG()));
   ID_ParametersSaveAs = Parameters->insertItem("Save &As...", cmd,
      SLOT(ParametersSaveAs()));

   ZBuffer = new QPopupMenu();
   CHECK_PTR(ZBuffer);
   ID_ZBufferOpen = ZBuffer->insertItem("&Open...", cmd,
      SLOT(ZBufferOpen()));
   ID_ZBufferClose = ZBuffer->insertItem("&Close", cmd,
      SLOT(ZBufferClose()));
   ID_ZBufferSave = ZBuffer->insertItem("&Save", cmd,
      SLOT(ZBufferSave()));
   ID_ZBufferSaveAs = ZBuffer->insertItem("Save &As...", cmd,
      SLOT(ZBufferSaveAs()));
 
   menu = new QMenuBar(this);
   CHECK_PTR(menu);
   menu->insertItem("&Image", Image);
   menu->insertItem("&Calculation", Calculation);
   menu->insertItem("&Parameters", Parameters);
   menu->insertItem("&ZBuffer", ZBuffer);

}

void QuatMenu::TitleImage()
{
   long i, j;
//   unsigned char line[320*3+10];
   unsigned char *line;
//   long Pos;
   uint *p;
   z_stream d_stream;
   int err;

   if (TitleImg_Length==0 || TitleImg_X==0 || TitleImg_Y==0) return;
   QImage *bitmap = new QImage(TitleImg_X,TitleImg_Y,32, 0, 
      QImage::IgnoreEndian);
//   Pos = 0;
   line = (unsigned char *)calloc(TitleImg_X*3+10, 1);
   if (!line) return;
   d_stream.zalloc = (alloc_func)0;
   d_stream.zfree = (free_func)0;
   inflateInit(&d_stream);
   d_stream.avail_in = TitleImg_Length;
   d_stream.next_in = &(TitleImg[0]);
   for (i=0; i<TitleImg_Y; i++) 
   {
      d_stream.avail_out = TitleImg_X*3;
      d_stream.next_out = &(line[0]);
      err = inflate(&d_stream, Z_PARTIAL_FLUSH);
//      if (err == Z_STREAM_END)
//         err = inflateEnd(&d_stream);
//      Pos = (unsigned int)(d_stream.next_in-TitleImg);
      p = (uint *)bitmap->scanLine(i);
      for (j=0; j<TitleImg_X; j++)
         *(p+j) = qRgb(line[3*j], line[3*j+1], line[3*j+2]);
   }
   inflateEnd(&d_stream);
   pixmap = new QPixmap(TitleImg_X,TitleImg_Y,-1);
   pixmap->convertFromImage(*bitmap, 0);
   picx = TitleImg_X; picy = TitleImg_Y;
   delete bitmap;
   free(line);
}

void QuatMenu::ChangeState(bool ImgInMem, bool ZBufInMem, bool ImgChanged, 
   bool ZBufChanged, bool ImgReady, bool ZBufReady, bool InCalc) 
{
   Image->setItemEnabled(ID_ImageOpen, !ImgInMem && !ZBufInMem && !InCalc);
   Image->setItemEnabled(ID_ImageClose, ImgInMem && !InCalc);
   Image->setItemEnabled(ID_ImageSave, ImgInMem && ImgChanged && !InCalc);
   Image->setItemEnabled(ID_ImageSaveAs, ImgInMem && !InCalc);
   Image->setItemEnabled(ID_ImageExit, !InCalc);
   Calculation->setItemEnabled(ID_CalculationStartImage, !ImgReady && (ZBufReady || !ZBufInMem) && !InCalc);
   Calculation->setItemEnabled(ID_CalculationStartZBuf, !ZBufReady && !ImgInMem && !InCalc);
   Calculation->setItemEnabled(ID_CalculationStop, InCalc);
   Parameters->setItemEnabled(ID_ParametersReset, !ZBufInMem && !ImgInMem && !InCalc);
   Parameters->setItemEnabled(ID_ParametersReadINI, !ImgInMem && !InCalc);
   Parameters->setItemEnabled(ID_ParametersReadPNG, !ImgInMem && !InCalc);
   Parameters->setItemEnabled(ID_ParametersSaveAs, !InCalc);
   Parameters->setItemEnabled(ID_ParametersObjectEditor, !InCalc);
   Parameters->setItemEnabled(ID_ParametersViewEditor, !InCalc);
   Parameters->setItemEnabled(ID_ParametersColorEditor, !InCalc);
   Parameters->setItemEnabled(ID_ParametersIntersectionEditor, !InCalc);
   Parameters->setItemEnabled(ID_ParametersOther, !InCalc);
   ZBuffer->setItemEnabled(ID_ZBufferOpen, !ImgInMem && !ZBufInMem && !InCalc);
   ZBuffer->setItemEnabled(ID_ZBufferClose, !ImgInMem && ZBufInMem && !InCalc);
   ZBuffer->setItemEnabled(ID_ZBufferSave, ZBufInMem && ZBufChanged && !InCalc);
   ZBuffer->setItemEnabled(ID_ZBufferSaveAs, ZBufInMem && !InCalc);
}

void QuatMenu::setAllDisabled()
{
   Image->setItemEnabled(ID_ImageOpen, FALSE);
   Image->setItemEnabled(ID_ImageClose, FALSE);
   Image->setItemEnabled(ID_ImageSave, FALSE);
   Image->setItemEnabled(ID_ImageSaveAs, FALSE);
   Image->setItemEnabled(ID_ImageExit, FALSE);
   Calculation->setItemEnabled(ID_CalculationStartImage, FALSE);
   Calculation->setItemEnabled(ID_CalculationStartZBuf, FALSE);
   Calculation->setItemEnabled(ID_CalculationStop, FALSE);
   Parameters->setItemEnabled(ID_ParametersReset, FALSE);
   Parameters->setItemEnabled(ID_ParametersReadINI, FALSE);
   Parameters->setItemEnabled(ID_ParametersReadPNG, FALSE);
   Parameters->setItemEnabled(ID_ParametersSaveAs, FALSE);
   Parameters->setItemEnabled(ID_ParametersObjectEditor, FALSE);
   Parameters->setItemEnabled(ID_ParametersViewEditor, FALSE);
   Parameters->setItemEnabled(ID_ParametersColorEditor, FALSE);
   Parameters->setItemEnabled(ID_ParametersIntersectionEditor, FALSE);
   Parameters->setItemEnabled(ID_ParametersOther, FALSE);
   ZBuffer->setItemEnabled(ID_ZBufferOpen, FALSE);
   ZBuffer->setItemEnabled(ID_ZBufferClose, FALSE);
   ZBuffer->setItemEnabled(ID_ZBufferSave, FALSE);
   ZBuffer->setItemEnabled(ID_ZBufferSaveAs, FALSE);
}

void QuatMenu::paintEvent(QPaintEvent *qp)
{
   QRect qr;
  
   if (pixmap && !pixmap->isNull()) 
   {
      QPainter painter(this);
      qr = qp->rect();
      if (qr.right()>xadd+picx) qr.setRight(xadd+picx);
      if (qr.bottom()>yadd+picy) qr.setBottom(yadd+picx);
      if (qr.left()<xadd) qr.setLeft(xadd);
      if (qr.top()<yadd) qr.setTop(yadd);
      painter.setClipRect(qr);
      painter.drawPixmap(qr.left(), qr.top(), *pixmap, qr.left()-xadd, qr.top()-yadd, 
         qr.width(), qr.height());
      if (HScroll && qr.bottom()>height()-16 && qr.top()<height()) 
         HScroll->repaint();
      if (VScroll && qr.right()>width()-16 && qr.left()<width()) 
         VScroll->repaint();
   }
}

void QuatMenu::resizeEvent(QResizeEvent *qr)
{
   int menh = menu->heightForWidth(width());
   pixx = width(); pixy = height()-menh;
   xadd = (pixx-picx-2)/2; yadd = (pixy-picy-2)/2+menh;
   cmd->SetScrollBars();
}

void QuatMenu::SetHScrollPos(int p)
{
   xadd = -p;
   repaint(FALSE);
}

void QuatMenu::SetVScrollPos(int p)
{
   yadd = menu->heightForWidth(width())-p;
   repaint(FALSE);
}

