/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.UiUpdater;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.Thumbnail;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.ThumbnailsPanel;
import rogatkin.Serializer;

public class CollectionThumbnailsPanel
extends ThumbnailsPanel {
    public CollectionThumbnailsPanel(Controller controller) {
        super(controller);
    }

    void setImageView() {
        this.imagepanel = (PhotoImagePanel)this.controller.component(Controller.COMP_IMAGECOLLCTPANEL);
    }

    void setCollection(PhotoCollectionPanel photoCollectionPanel) {
        this.collectionpanel = photoCollectionPanel;
    }

    JPopupMenu getRightButtonMenu(ActionListener actionListener, boolean bl) {
        if (bl) {
            return this.collectionpanel.getRMouseMenu();
        }
        return new CollectThumbsRightBtnMenu(actionListener);
    }

    void doSpecificAction(BasicJpeg basicJpeg, ActionEvent actionEvent, Thumbnail thumbnail) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Show")) {
            this.showFullImage(basicJpeg, thumbnail);
        } else if (string.equals("Delete")) {
            this.collectionpanel.delete(new int[]{this.collectionpanel.findIndexOf(thumbnail)});
        } else if (string.equals("Rename")) {
            this.collectionpanel.rename(new int[]{this.collectionpanel.findIndexOf(thumbnail)});
        } else if (string.equals("Invert selection")) {
            int n = this.collectionpanel.findIndexOf(thumbnail);
            if (n >= 0) {
                if (this.collectionpanel.isRowSelected(n)) {
                    this.collectionpanel.removeRowSelectionInterval(n, n);
                } else {
                    this.collectionpanel.addRowSelectionInterval(n, n);
                }
                this.controller.getUiUpdater().notify(this.collectionpanel.getSelectedRowCount() > 0, UiUpdater.SELECTION_SELECTED);
            }
        } else if (string.equals("Print")) {
            this.controller.print(new File[]{new File(basicJpeg.getLocationName())});
        } else if (string.equals("To album")) {
            AlbumPane albumPane = (AlbumPane)this.controller.component(Controller.COMP_ALBUMPANEL);
            AlbumSelectionDialog albumSelectionDialog = albumPane.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + basicJpeg);
            ((Component)albumSelectionDialog).setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                albumPane.addToAlbum(new BasicJpeg[]{basicJpeg}, treePathArray);
                Serializer serializer = this.controller.getSerializer();
                if (Serializer.getInt(serializer.getProperty("AlbumOptions", "MoveToAlbum"), 0) == 1 && Serializer.getInt(serializer.getProperty("AlbumOptions", "AlbumFolders"), 0) == 1) {
                    this.collectionpanel.delete(new int[]{this.collectionpanel.findIndexOf(thumbnail)});
                }
            }
        } else {
            int n = Controller.convertCmdToTrnasformOp(string);
            if (n != -1) {
                this.collectionpanel.transform(new int[]{this.collectionpanel.findIndexOf(thumbnail)}, n);
            }
        }
    }

    class CollectThumbsRightBtnMenu
    extends JPopupMenu {
        CollectThumbsRightBtnMenu(ActionListener actionListener) {
            JMenuItem jMenuItem = new JMenuItem("Invert selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("Show");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("To album");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("Rename");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Print");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            this.add(Controller.createTransformMenu(actionListener));
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
        }
    }
}

