void __fastcall TDesignForm::ScaleClick(TObject *Sender) {
  D3DVALUE x = 1, y = 1, z = 1, d;
  DecimalSeparator = '.';
  try { d = edScale->Text.ToDouble();
  } catch (Exception &exception) {
     Application->ShowException(&exception);
     return;
  }

  if      (Sender == sbScalexMul) x  = d;
  else if (Sender == sbScaleyMul) y  = d;
  else if (Sender == sbScalezMul) z  = d;
  else if (Sender == sbScalexDiv) x /= d;
  else if (Sender == sbScaleyDiv) y /= d;
  else if (Sender == sbScalezDiv) z /= d;
  else if (Sender == sbScaleAllMul) {
     x = d; y = d; z = d;
  }
  else if (Sender == sbScaleAllDiv) {
     x /= d; y /= d; z /= d;
  }

  if (ISelBuilder) ISelBuilder->Scale(x, y, z);
  else
  if (ISelFrame)
      ISelFrame->AddScale(D3DRMCOMBINE_BEFORE, x, y, z);

  D3dView->Render();
  Changed();
}//---------------------------------------------------------
void __fastcall TDesignForm::PositionClick(TObject *Sender){
  D3DVALUE x = 0, y = 0, z = 0, d;
  DecimalSeparator = '.';
  try { d = edPos->Text.ToDouble();
  } catch (Exception &exception) {
     Application->ShowException(&exception);
     return;
  }

  if      (Sender == sbPosxPlus)  x =  d;
  else if (Sender == sbPosyPlus)  y =  d;
  else if (Sender == sbPoszPlus)  z =  d;
  else if (Sender == sbPosxMinus) x = -d;
  else if (Sender == sbPosyMinus) y = -d;
  else if (Sender == sbPoszMinus) z = -d;

  if (ISelBuilder && SelVertex) {
     x += SelVertexPos.x;
     y += SelVertexPos.y;
     z += SelVertexPos.z;
     ISelBuilder->SetVertex(SelVertex, x, y, z);
  }
  else
  if (ISelBuilder) ISelBuilder->Translate(x, y, z);
  else
  if (ISelFrame) {
     D3DVECTOR pos;
     ISelFrame->GetPosition(IScene, &pos);
     ISelFrame->SetPosition(IScene,pos.x+x,pos.y+y,pos.z+z);
  }

  D3dView->Render();
  Changed();
}//---------------------------------------------------------
void __fastcall TDesignForm::RotateClick(TObject *Sender) {
  D3DVALUE d;
  DecimalSeparator = '.';
  try { d = edRot->Text.ToDouble() * M_PI / 180;
  } catch (Exception &exception) {
     Application->ShowException(&exception);
     return;
  }

  if (ISelBuilder) {
     if      (Sender == sbRotxPlus)
       BuilderRotate(ISelBuilder,1,0,0, d);
     else if (Sender == sbRotyPlus)
       BuilderRotate(ISelBuilder,0,1,0, d);
     else if (Sender == sbRotzPlus)
       BuilderRotate(ISelBuilder,0,0,1, d);
     else if (Sender == sbRotxMinus)
       BuilderRotate(ISelBuilder,1,0,0,-d);
     else if (Sender == sbRotyMinus)
       BuilderRotate(ISelBuilder,0,1,0,-d);
     else if (Sender == sbRotzMinus)
       BuilderRotate(ISelBuilder,0,0,1,-d);
  } // if (ISelBuilder)
  else
  if (ISelFrame) {
     if      (Sender == sbRotxPlus)
       ISelFrame->AddRotation(D3DRMCOMBINE_BEFORE,1,0,0, d);
     else if (Sender == sbRotyPlus)
       ISelFrame->AddRotation(D3DRMCOMBINE_BEFORE,0,1,0, d);
     else if (Sender == sbRotzPlus)
       ISelFrame->AddRotation(D3DRMCOMBINE_BEFORE,0,0,1, d);
     else if (Sender == sbRotxMinus)
       ISelFrame->AddRotation(D3DRMCOMBINE_BEFORE,1,0,0,-d);
     else if (Sender == sbRotyMinus)
       ISelFrame->AddRotation(D3DRMCOMBINE_BEFORE,0,1,0,-d);
     else if (Sender == sbRotzMinus)
       ISelFrame->AddRotation(D3DRMCOMBINE_BEFORE,0,0,1,-d);
  } // if (ISelFrame)

  D3dView->Render();
  Changed();
}//---------------------------------------------------------
void __fastcall TDesignForm::sbFromCameraClick(TObject *) {
  if (!ISelFrame) return;
  D3DRMMATRIX4D m;
  Vport->GetCamera()->GetTransform(m);
  ISelFrame->AddTransform(D3DRMCOMBINE_REPLACE, m);
  D3dView->Render();
  Changed();
}//---------------------------------------------------------
void __fastcall TDesignForm::sbResetClick(TObject*) {
  D3DRMMATRIX4D m = {{1,0,0,0},
                     {0,1,0,0},
                     {0,0,1,0},
                     {0,0,0,1}};
  if (ISelFrame) {
     ISelFrame->AddTransform(D3DRMCOMBINE_REPLACE, m);
     D3dView->Render();
     Changed();
  }
}//---------------------------------------------------------
void __fastcall TDesignForm::edCameraStepExit(TObject*) {
  try {
     DecimalSeparator = '.';
     D3DVALUE d = edCameraStep->Text.ToDouble();
     Ctrl->SetLinearArgs(d);
  } catch (Exception &exception) {
     Application->ShowException(&exception);
  }
}//---------------------------------------------------------
