/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import java.util.Iterator;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class PacksPanelAutomationHelper
implements PanelAutomation {
    public void makeXMLData(AutomatedInstallData automatedInstallData, XMLElement xMLElement) {
        for (int i = 0; i < automatedInstallData.availablePacks.size(); ++i) {
            Pack pack = (Pack)automatedInstallData.availablePacks.get(i);
            XMLElement xMLElement2 = new XMLElement("pack");
            xMLElement2.setAttribute("index", new Integer(i).toString());
            xMLElement2.setAttribute("name", pack.name);
            Boolean bl = new Boolean(automatedInstallData.selectedPacks.contains(pack));
            xMLElement2.setAttribute("selected", bl.toString());
            xMLElement.addChild(xMLElement2);
        }
    }

    public void runAutomated(AutomatedInstallData automatedInstallData, XMLElement xMLElement) {
        Vector vector = xMLElement.getChildrenNamed("pack");
        int n = vector.size();
        automatedInstallData.selectedPacks.clear();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = (XMLElement)vector.get(i);
            Boolean bl = new Boolean(xMLElement2.getAttribute("selected"));
            if (!bl.booleanValue()) continue;
            String string = xMLElement2.getAttribute("index");
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 >= 0 && n2 < automatedInstallData.availablePacks.size()) {
                        automatedInstallData.selectedPacks.add(automatedInstallData.availablePacks.get(n2));
                        continue;
                    }
                    System.err.println("Invalid pack index \"" + string + "\" in line " + xMLElement2.getLineNr());
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid pack index \"" + string + "\" in line " + xMLElement2.getLineNr());
                }
                continue;
            }
            String string2 = xMLElement2.getAttribute("name");
            if (string2 == null) continue;
            Iterator iterator = automatedInstallData.availablePacks.iterator();
            boolean bl2 = false;
            while (!bl2 && iterator.hasNext()) {
                Pack pack = (Pack)iterator.next();
                if (!pack.name.equals(string2)) continue;
                automatedInstallData.selectedPacks.add(pack);
                bl2 = true;
            }
            if (bl2) continue;
            System.err.println("Could not find selected pack named \"" + string2 + "\" in line " + xMLElement2.getLineNr());
        }
    }
}

