/** \file 3D_View.h
    A partial view of an infinite 3D World.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_3D_VIEW
#define H_3D_VIEW

#include <2D_View.h>
#include <3D_Object3D.h>
#include <3D_Radar.h>


/** View3D is the connection between a camera and a View2D.  */

class View3D : public View2D, public Transformable
{
public:
   /** Creates a view with the specified rectangle on the Canvas (screen/bitmap) */
   View3D(const Rect2D& r);
   /** Create a new view with transform preconcatenated to view's current transform. */
   View3D(const View3D& view, const Transformable& transform);

   virtual ~View3D();
   
   /** called by World::render() to initialize the view */
   virtual int beginRendering();
   
   /** Must be called after rendering, to ensure correct clipping. */
   virtual int endRendering();

   /** This radar will receive notifications of detectable objects
       in the vicinity of the camera.
       Note: R must be dynamically allocated and will be deleted by ~View3D(). */

   long      setRadar(Radar* R);
   Radar*    getRadar();

   Camera*   getCamera() const;
   Screen3D* getScreen3D() const;

   /* this is called after each object is rendered to the 3D view.
      default implementation adds the object to the radar if it is 
      radarDetectable().  */
   long postObjectRender(Object3D* O) const;

   long status() { return m_Status; }

protected:
   Screen3D* m_S;
   Radar*    m_Radar;
   Camera*   m_Cam;
   long      m_Status;
   int       m_RootView;  // boolean flag indicating that this was constructed as
                          // a new view by View3D(Rect2D(...))
};

#endif // H_3D_VIEW