/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.freehep.util.io.IndentPrintWriter;
import org.freehep.xml.util.XMLCharacterProperties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    protected boolean closed = true;
    private String dtdName = null;
    private Hashtable attributes = new Hashtable();
    private Stack openTags = new Stack();
    protected IndentPrintWriter writer;
    protected String defaultNameSpace;

    public XMLWriter(Writer w2, String indentString, String defaultNameSpace) {
        this.writer = new IndentPrintWriter(w2);
        this.writer.setIndentString(indentString);
        this.defaultNameSpace = defaultNameSpace;
    }

    public XMLWriter(Writer w2, String indentString) {
        this(w2, indentString, "");
    }

    public XMLWriter(Writer w2) {
        this(w2, "  ");
    }

    public void close() throws IOException {
        this.closeDoc();
        this.writer.close();
    }

    public void openDoc() {
        this.openDoc("1.0", "", false);
    }

    public void openDoc(String version, String encoding, boolean standalone) {
        String indentString = this.writer.getIndentString();
        this.writer.setIndentString(indentString);
        this.closed = false;
        if (!XMLCharacterProperties.validVersionNum(version)) {
            throw new RuntimeException("Invalid version number: " + version);
        }
        this.writer.print("<?xml version=\"");
        this.writer.print(version);
        this.writer.print("\" ");
        if (encoding != null && !encoding.equals("")) {
            if (!XMLCharacterProperties.validEncName(encoding)) {
                throw new RuntimeException("Invalid encoding name: " + encoding);
            }
            this.writer.print("encoding=\"");
            this.writer.print(encoding);
            this.writer.print("\" ");
        }
        if (standalone) {
            this.writer.print("standalone=\"yes\" ");
        }
        this.writer.println("?>");
        this.writer.setIndentString(indentString);
    }

    public void referToDTD(String name, String pid, String ref) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = name;
        this.writer.println("<!DOCTYPE " + name + " PUBLIC \"" + pid + "\" \"" + ref + "\">");
    }

    public void referToDTD(String name, String system) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = name;
        this.writer.println("<!DOCTYPE " + name + " SYSTEM \"" + system + "\">");
    }

    public void closeDoc() {
        if (!this.closed) {
            if (!this.openTags.isEmpty()) {
                StringBuffer sb = new StringBuffer("Not all tags were closed before closing XML document:\n");
                while (!this.openTags.isEmpty()) {
                    sb.append("   </");
                    sb.append((String)this.openTags.pop());
                    sb.append(">\n");
                }
                throw new RuntimeException(sb.toString());
            }
            this.closed = true;
        }
    }

    public void printComment(String comment) {
        if (comment.indexOf("--") >= 0) {
            throw new RuntimeException("'--' sequence not allowed in comment");
        }
        this.writer.print("<!--");
        this.writer.print(XMLWriter.normalizeText(comment));
        this.writer.println("-->");
    }

    public void print(String text) {
        this.writer.print(XMLWriter.normalizeText(text));
    }

    public void println(String text) {
        this.print(text);
        this.writer.println();
    }

    public void openTag(String namespace, String name) {
        if (namespace.equals(this.defaultNameSpace)) {
            this.openTag(name);
        } else {
            this.openTag(namespace + ":" + name);
        }
    }

    public void openTag(String name) {
        this.checkNameValid(name);
        if (this.openTags.isEmpty() && this.dtdName != null && !this.dtdName.equals(name)) {
            throw new RuntimeException("First tag: '" + name + "' not equal to DTD id: '" + this.dtdName + "'");
        }
        this.writer.print("<" + name);
        this.printAttributes(name.length());
        this.writer.println(">");
        this.writer.indent();
        this.openTags.push(name);
    }

    public void closeTag() {
        if (this.openTags.isEmpty()) {
            this.writer.close();
            throw new RuntimeException("No open tags");
        }
        Object name = this.openTags.pop();
        this.writer.outdent();
        this.writer.print("</");
        this.writer.print(name);
        this.writer.println(">");
    }

    public void printTag(String namespace, String name) {
        if (namespace.equals(this.defaultNameSpace)) {
            this.printTag(name);
        } else {
            this.printTag(namespace + ":" + name);
        }
    }

    public void printTag(String name) {
        this.checkNameValid(name);
        this.writer.print("<" + name);
        this.printAttributes(name.length());
        this.writer.println("/>");
    }

    public void setAttribute(String name, String value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void setAttribute(String namespace, String name, String value) {
        if (namespace != null && name != null) {
            this.attributes.put(namespace + ":" + name, value);
        }
    }

    public void setAttribute(String name, double value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, float value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, short value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, byte value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, char value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String ns, String name, double value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    public void setAttribute(String ns, String name, int value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    public void setAttribute(String ns, String name, boolean value) {
        this.setAttribute(ns + ":" + name, String.valueOf(value));
    }

    protected void printAttributes(int tagLength) {
        int width = tagLength + 1;
        boolean extraIndent = false;
        Enumeration e2 = this.attributes.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement().toString();
            this.checkNameValid(key);
            String value = XMLWriter.normalize(this.attributes.get(key).toString());
            int length = key.length() + value.length() + 3;
            if (width > 0 && width + length + 2 * this.writer.getIndent() > 60) {
                width = 0;
                this.writer.println();
                if (!extraIndent) {
                    this.writer.indent();
                    extraIndent = true;
                }
            } else {
                width += length;
                this.writer.print(' ');
            }
            this.writer.print(key);
            this.writer.print("=\"");
            this.writer.print(value);
            this.writer.print("\"");
        }
        this.attributes.clear();
        if (extraIndent) {
            this.writer.outdent();
        }
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                throw new RuntimeException("No support for printing nodes of type Document");
            }
            case 1: {
                NamedNodeMap attributes = node.getAttributes();
                int i2 = 0;
                while (i2 < attributes.getLength()) {
                    Node attr = attributes.item(i2);
                    this.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    ++i2;
                }
                NodeList children = node.getChildNodes();
                if (children == null) {
                    this.printTag(node.getNodeName());
                    break;
                }
                this.openTag(node.getNodeName());
                int len = children.getLength();
                int i3 = 0;
                while (i3 < len) {
                    this.print(children.item(i3));
                    ++i3;
                }
                this.closeTag();
                break;
            }
            case 5: {
                this.writer.print('&');
                this.writer.print(node.getNodeName());
                this.writer.print(';');
                break;
            }
            case 4: {
                this.writer.print("<![CDATA[");
                this.writer.print(node.getNodeValue());
                this.writer.print("]]>");
                break;
            }
            case 3: {
                this.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.writer.print("<?");
                this.writer.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.writer.print(' ');
                    this.writer.print(data);
                }
                this.writer.print("?>");
            }
        }
    }

    public static String normalize(String s2) {
        StringBuffer str = new StringBuffer();
        int len = s2 != null ? s2.length() : 0;
        int i2 = 0;
        while (i2 < len) {
            char ch = s2.charAt(i2);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    break;
                }
                default: {
                    if (ch > '\u00ff') {
                        String hex = "0000" + Integer.toHexString(ch);
                        str.append("&#x");
                        str.append(hex.substring(hex.length() - 4));
                        str.append(';');
                        break;
                    }
                    str.append(ch);
                }
            }
            ++i2;
        }
        return str.toString();
    }

    public static String normalizeText(String s2) {
        StringBuffer str = new StringBuffer();
        int len = s2 != null ? s2.length() : 0;
        int i2 = 0;
        while (i2 < len) {
            char ch = s2.charAt(i2);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                default: {
                    if (ch > '\u007f') {
                        String hex = "0000" + Integer.toHexString(ch);
                        str.append("&#x");
                        str.append(hex.substring(hex.length() - 4));
                        str.append(';');
                        break;
                    }
                    str.append(ch);
                }
            }
            ++i2;
        }
        return str.toString();
    }

    protected void checkNameValid(String s2) {
        if (!XMLCharacterProperties.validName(s2)) {
            throw new RuntimeException("Invalid name: " + s2);
        }
    }
}

