/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.util.export.ExportFileTypeRegistry;

public abstract class ExportFileType
implements Comparable {
    private static ClassLoader loader;

    public abstract String getDescription();

    public abstract String[] getExtensions();

    public abstract String[] getMIMETypes();

    public abstract void exportToFile(OutputStream var1, Component var2, Component var3, Properties var4, String var5) throws IOException;

    public abstract void exportToFile(File var1, Component var2, Component var3, Properties var4, String var5) throws IOException;

    public abstract void exportToFile(OutputStream var1, Component[] var2, Component var3, Properties var4, String var5) throws IOException;

    public abstract void exportToFile(File var1, Component[] var2, Component var3, Properties var4, String var5) throws IOException;

    public int compareTo(Object o2) {
        ExportFileType type = (ExportFileType)o2;
        return this.getDescription().compareTo(type.getDescription());
    }

    public boolean hasOptionPanel() {
        return false;
    }

    public JPanel createOptionPanel(Properties options) {
        return null;
    }

    public boolean applyChangedOptions(JPanel optionPanel, Properties options) {
        return false;
    }

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.getExtensions(), this.getDescription());
    }

    public File adjustFilename(File file, Properties properties) {
        return ExportFileType.adjustExtension(file, this.getExtensions()[0], this.getExtensions());
    }

    public boolean fileHasValidExtension(File file) {
        return ExportFileType.checkExtension(file, this.getExtensions());
    }

    public boolean isMultipageCapable() {
        return false;
    }

    public static void setClassLoader(ClassLoader loader) {
        ExportFileType.loader = loader;
    }

    public static List getExportFileTypes() {
        return ExportFileType.getExportFileTypes(null);
    }

    public static List getExportFileTypes(String format) {
        return ExportFileTypeRegistry.getDefaultInstance(loader).get(format);
    }

    public static boolean checkExtension(File file, String[] acceptableExtensions) {
        boolean match = false;
        if (file != null && acceptableExtensions != null) {
            String originalName = file.getName();
            String extension = "";
            int dotIndex = originalName.lastIndexOf(46);
            extension = dotIndex > 0 && dotIndex < originalName.length() - 1 ? originalName.substring(dotIndex + 1) : "";
            int i2 = 0;
            while (i2 < acceptableExtensions.length) {
                if (acceptableExtensions[i2].equals(extension)) {
                    match = true;
                }
                ++i2;
            }
        }
        return match;
    }

    public static File adjustExtension(File file, String preferredExtension, String[] acceptableExtensions) {
        File returnValue = file;
        if (file != null) {
            int dotIndex;
            String originalParent = file.getParent();
            String originalName = file.getName();
            String mainName = "";
            String extension = "";
            if (originalParent != null) {
                mainName = originalParent + File.separator;
            }
            if ((dotIndex = originalName.lastIndexOf(46)) > 0 && dotIndex < originalName.length() - 1) {
                mainName = mainName + originalName.substring(0, dotIndex);
                extension = originalName.substring(dotIndex + 1);
            } else {
                mainName = mainName + originalName;
                extension = "";
            }
            boolean match = false;
            if (acceptableExtensions != null) {
                int i2 = 0;
                while (i2 < acceptableExtensions.length) {
                    if (acceptableExtensions[i2].equals(extension)) {
                        match = true;
                    }
                    ++i2;
                }
            }
            if (!match) {
                File newFile;
                String newName = mainName + "." + preferredExtension;
                returnValue = newFile = new File(newName);
            }
        }
        return returnValue;
    }
}

