/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Shape;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public class CharstringEncoder
extends QuadToCubicPathConstructor {
    private static final int LAST_POINT = 0;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int BOTH = 3;
    private OutputStream out;
    private int currentX;
    private int currentY;

    public CharstringEncoder(OutputStream out) {
        this.out = out;
        this.currentY = 0;
        this.currentX = 0;
    }

    private int writeNumber(double v2) throws IOException {
        int round = (int)Math.round(v2);
        this.writeNumber(round);
        return round;
    }

    private void writeNumber(int v2) throws IOException {
        if (v2 >= -107 && v2 <= 107) {
            this.out.write(v2 + 139);
        } else if (v2 >= 108 && v2 <= 1131) {
            int highByte = (v2 - 108) / 256;
            this.out.write(highByte + 247);
            this.out.write(v2 - 108 - 256 * highByte);
        } else if (v2 >= -1131 && v2 <= -108) {
            int highByte = (v2 + 108) / 256;
            this.out.write(-highByte + 251);
            this.out.write(-(v2 + 108 - 256 * highByte));
        } else {
            this.out.write(255);
            this.out.write(v2 >>> 24 & 0xFF);
            this.out.write(v2 >>> 16 & 0xFF);
            this.out.write(v2 >>> 8 & 0xFF);
            this.out.write(v2 >>> 0 & 0xFF);
        }
    }

    private void writeCommand(int com) throws IOException {
        if (com >= 31) {
            throw new IOException("Charstring command out of range: " + com);
        }
        this.out.write(com);
    }

    private void writeExtCommand(int com) throws IOException {
        this.out.write(12);
        this.out.write(com);
    }

    private void writePoint(double x2, double y2) throws IOException {
        this.currentX += this.writeNumber(x2 - (double)this.currentX);
        this.currentY += this.writeNumber(y2 - (double)this.currentY);
    }

    private void writeX(double x2) throws IOException {
        this.currentX += this.writeNumber(x2 - (double)this.currentX);
    }

    private void writeY(double y2) throws IOException {
        this.currentY += this.writeNumber(y2 - (double)this.currentY);
    }

    public void startChar(double sidebearing, double width) throws IOException {
        this.currentX = this.writeNumber(sidebearing);
        this.writeNumber(width);
        this.writeCommand(13);
    }

    public void endchar() throws IOException {
        this.writeCommand(14);
    }

    private int to(double x2, double y2) throws IOException {
        int rx = (int)Math.round(x2);
        int ry = (int)Math.round(y2);
        if (rx == this.currentX) {
            if (ry == this.currentY) {
                return 0;
            }
            this.writeY(y2);
            return 2;
        }
        if (ry == this.currentY) {
            this.writeX(x2);
            return 1;
        }
        this.writePoint(x2, y2);
        return 3;
    }

    public void move(double x2, double y2) throws IOException {
        switch (this.to(x2, y2)) {
            case 3: {
                this.writeCommand(21);
                break;
            }
            case 1: {
                this.writeCommand(22);
                break;
            }
            case 2: {
                this.writeCommand(4);
                break;
            }
        }
        super.move(x2, y2);
    }

    public void line(double x2, double y2) throws IOException {
        switch (this.to(x2, y2)) {
            case 3: {
                this.writeCommand(5);
                break;
            }
            case 1: {
                this.writeCommand(6);
                break;
            }
            case 2: {
                this.writeCommand(7);
                break;
            }
        }
        super.line(x2, y2);
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.writePoint(x1, y1);
        this.writePoint(x2, y2);
        this.writePoint(x3, y3);
        this.writeCommand(8);
        super.cubic(x1, y1, x2, y2, x3, y3);
    }

    public void closePath() throws IOException {
        this.writeCommand(9);
        super.closePath();
    }

    public void drawPath(Shape s2) throws IOException {
        this.addPath(s2);
    }
}

