/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.util.images.ImageHandler;

class CloseButtonTabbedPane
extends JTabbedPane {
    public static final boolean CLOSE_BUTTON_ENABLED = true;
    static final String TAB_NAME_TRAILING_SPACE = "   ";
    private static Image closeTabImage = ImageHandler.getImage("tabclose", class$org$freehep$application$mdi$CloseButtonTabbedPane == null ? (class$org$freehep$application$mdi$CloseButtonTabbedPane = CloseButtonTabbedPane.class$("org.freehep.application.mdi.CloseButtonTabbedPane")) : class$org$freehep$application$mdi$CloseButtonTabbedPane);
    private static Image closeTabInactiveImage = ImageHandler.getImage("tabcloseinactive", class$org$freehep$application$mdi$CloseButtonTabbedPane == null ? (class$org$freehep$application$mdi$CloseButtonTabbedPane = CloseButtonTabbedPane.class$("org.freehep.application.mdi.CloseButtonTabbedPane")) : class$org$freehep$application$mdi$CloseButtonTabbedPane);
    private boolean draggedOut = false;
    private int mouseOverCloseButtonIndex = -1;
    private int pressedCloseButtonIndex = -1;
    static /* synthetic */ Class class$org$freehep$application$mdi$CloseButtonTabbedPane;

    CloseButtonTabbedPane() {
        CloseButtonListener cl = new CloseButtonListener();
        this.addMouseListener(cl);
        this.addMouseMotionListener(cl);
        this.addChangeListener(cl);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        int selectedIndex = this.getSelectedIndex();
        int i2 = 0;
        int n2 = this.getTabCount();
        while (i2 < n2) {
            Rectangle r2 = this.getCloseButtonBoundsAt(i2);
            if (r2 != null) {
                if (i2 == this.pressedCloseButtonIndex && !this.draggedOut) {
                    g2.setColor(new Color(153, 153, 153));
                    g2.fillRect(r2.x, r2.y, r2.width, r2.height);
                }
                if (i2 != selectedIndex) {
                    g2.drawImage(closeTabInactiveImage, r2.x + 2, r2.y + 2, this);
                } else {
                    g2.drawImage(closeTabImage, r2.x + 2, r2.y + 2, this);
                }
                if (i2 == this.mouseOverCloseButtonIndex || i2 == this.pressedCloseButtonIndex && this.draggedOut) {
                    g2.setColor(new Color(102, 102, 102));
                    g2.drawRect(r2.x, r2.y, r2.width, r2.height);
                    g2.setColor(i2 == selectedIndex ? new Color(255, 255, 255) : new Color(204, 204, 204));
                    g2.drawRect(r2.x + 1, r2.y + 1, r2.width, r2.height);
                    g2.setColor(new Color(162, 162, 162));
                    g2.drawLine(r2.x + r2.width, r2.y + 1, r2.x + r2.width, r2.y + 1);
                    g2.drawLine(r2.x + 1, r2.y + r2.height, r2.x + 1, r2.y + r2.height);
                } else if (i2 == this.pressedCloseButtonIndex) {
                    g2.setColor(new Color(102, 102, 102));
                    g2.drawRect(r2.x, r2.y, r2.width, r2.height);
                    g2.setColor(i2 == selectedIndex ? new Color(255, 255, 255) : new Color(204, 204, 204));
                    g2.drawLine(r2.x + 1, r2.y + r2.height + 1, r2.x + r2.width + 1, r2.y + r2.height + 1);
                    g2.drawLine(r2.x + r2.width + 1, r2.y + 1, r2.x + r2.width + 1, r2.y + r2.height + 1);
                    g2.setColor(new Color(153, 153, 153));
                    g2.drawLine(r2.x + 1, r2.y + 1, r2.x + r2.width, r2.y + 1);
                    g2.drawLine(r2.x + 1, r2.y + 1, r2.x + 1, r2.y + r2.height);
                }
            }
            ++i2;
        }
    }

    protected void fireCloseTabAt(int index) {
        this.removeTabAt(index);
    }

    private Rectangle getCloseButtonBoundsAt(int i2) {
        Rectangle b2 = this.getBoundsAt(i2);
        if (b2 == null) {
            return null;
        }
        b2 = new Rectangle(b2);
        Dimension tabsz = this.getSize();
        if (b2.x + b2.width >= tabsz.width || b2.y + b2.height >= tabsz.height) {
            return null;
        }
        return new Rectangle(b2.x + b2.width - 13, b2.y + b2.height / 2 - 5, 8, 8);
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r2;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0) {
            r2 = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r2.x, r2.y, r2.width + 2, r2.height + 2);
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0) {
            r2 = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r2.x, r2.y, r2.width + 2, r2.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r2;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0) {
            r2 = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r2.x, r2.y, r2.width + 2, r2.height + 2);
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0) {
            r2 = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r2.x, r2.y, r2.width + 2, r2.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CloseButtonListener
    extends MouseAdapter
    implements MouseMotionListener,
    ChangeListener {
        private CloseButtonListener() {
        }

        public void mouseDragged(MouseEvent e2) {
            if (CloseButtonTabbedPane.this.pressedCloseButtonIndex >= 0) {
                Rectangle r2 = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(CloseButtonTabbedPane.this.pressedCloseButtonIndex);
                if (CloseButtonTabbedPane.this.draggedOut != !r2.contains(e2.getPoint())) {
                    CloseButtonTabbedPane.this.draggedOut = !r2.contains(e2.getPoint());
                    CloseButtonTabbedPane.this.repaint(r2.x, r2.y, r2.width + 2, r2.height + 2);
                }
                e2.consume();
            }
        }

        public void mouseMoved(MouseEvent e2) {
            int index = CloseButtonTabbedPane.this.indexAtLocation(e2.getX(), e2.getY());
            if (index >= 0) {
                Rectangle r2 = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(index);
                if (r2.contains(e2.getPoint())) {
                    CloseButtonTabbedPane.this.setMouseOverCloseButtonIndex(index);
                    CloseButtonTabbedPane.this.draggedOut = false;
                    e2.consume();
                } else if (CloseButtonTabbedPane.this.mouseOverCloseButtonIndex >= 0) {
                    CloseButtonTabbedPane.this.setMouseOverCloseButtonIndex(-1);
                    CloseButtonTabbedPane.this.draggedOut = false;
                    e2.consume();
                }
            }
        }

        public void mousePressed(MouseEvent e2) {
            Rectangle r2;
            int index = CloseButtonTabbedPane.this.indexAtLocation(e2.getX(), e2.getY());
            if (index >= 0 && (r2 = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(index)).contains(e2.getPoint())) {
                CloseButtonTabbedPane.this.setPressedCloseButtonIndex(index);
                CloseButtonTabbedPane.this.draggedOut = false;
                e2.consume();
            }
        }

        public void mouseReleased(MouseEvent e2) {
            Rectangle r2;
            int tabIndex = CloseButtonTabbedPane.this.pressedCloseButtonIndex;
            if (tabIndex >= 0 && (r2 = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(tabIndex)).contains(e2.getPoint()) && tabIndex >= 0) {
                CloseButtonTabbedPane.this.reset();
                CloseButtonTabbedPane.this.fireCloseTabAt(tabIndex);
                e2.consume();
                return;
            }
            CloseButtonTabbedPane.this.reset();
        }

        public void stateChanged(ChangeEvent e2) {
            CloseButtonTabbedPane.this.reset();
        }
    }
}

