/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Gif;
import com.lowagie.text.ImgCCITT;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Jpeg;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Png;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.CCITTG4Encoder;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Color;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public abstract class Image
extends Rectangle
implements Element,
MarkupAttributes {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int MIDDLE = 3;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    protected boolean invert = false;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected PdfTemplate template;
    protected int alignment;
    protected String alt;
    protected float absoluteX = Float.NaN;
    protected float absoluteY = Float.NaN;
    protected float plainWidth;
    protected float plainHeight;
    protected float scaledWidth;
    protected float scaledHeight;
    protected float rotation;
    protected int colorspace = -1;
    protected int bpc = 1;
    protected int[] transparency;
    protected Long mySerialId = Image.getSerialId();
    static long serialId = 0L;
    protected int dpiX = 0;
    protected int dpiY = 0;
    protected boolean mask = false;
    protected Image imageMask;
    protected boolean invertMask = false;
    protected boolean interpolation;
    protected Annotation annotation = null;
    protected Properties markupAttributes;
    static /* synthetic */ Class class$com$lowagie$text$Image;

    public Image(URL uRL) {
        super(0.0f, 0.0f);
        this.url = uRL;
        this.alignment = 0;
        this.rotation = 0.0f;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.rotation = image.rotation;
        this.colorspace = image.colorspace;
        this.rawData = image.rawData;
        this.template = image.template;
        this.bpc = image.bpc;
        this.transparency = image.transparency;
        this.mySerialId = image.mySerialId;
        this.invert = image.invert;
        this.dpiX = image.dpiX;
        this.dpiY = image.dpiY;
        this.mask = image.mask;
        this.imageMask = image.imageMask;
        this.invertMask = image.invertMask;
        this.interpolation = image.interpolation;
        this.annotation = image.annotation;
        this.markupAttributes = image.markupAttributes;
    }

    public static Image getInstance(Image image) {
        try {
            Class<?> clazz = image.getClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(class$com$lowagie$text$Image == null ? (class$com$lowagie$text$Image = Image.class$("com.lowagie.text.Image")) : class$com$lowagie$text$Image);
            return (Image)constructor.newInstance(image);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(URL uRL) throws BadElementException, MalformedURLException, IOException {
        ImgWMF imgWMF;
        InputStream inputStream;
        block8: {
            Png png;
            block7: {
                Jpeg jpeg;
                block6: {
                    Gif gif;
                    block5: {
                        inputStream = null;
                        try {
                            inputStream = uRL.openStream();
                            int n2 = inputStream.read();
                            int n3 = inputStream.read();
                            inputStream.close();
                            inputStream = null;
                            if (n2 == 71 && n3 == 73) {
                                gif = new Gif(uRL);
                                Object var6_8 = null;
                                if (inputStream == null) return gif;
                                break block5;
                            }
                            if (n2 == 255 && n3 == 216) {
                                jpeg = new Jpeg(uRL);
                                break block6;
                            }
                            if (n2 == Png.PNGID[0] && n3 == Png.PNGID[1]) {
                                png = new Png(uRL);
                                break block7;
                            }
                            if (n2 != 215) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                            if (n3 != 205) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                            imgWMF = new ImgWMF(uRL);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            if (inputStream == null) throw throwable;
                            inputStream.close();
                            throw throwable;
                        }
                    }
                    inputStream.close();
                    return gif;
                }
                Object var6_9 = null;
                if (inputStream == null) return jpeg;
                inputStream.close();
                return jpeg;
            }
            Object var6_10 = null;
            if (inputStream == null) return png;
            inputStream.close();
            return png;
        }
        Object var6_11 = null;
        if (inputStream == null) return imgWMF;
        inputStream.close();
        return imgWMF;
    }

    public static Image getInstance(java.awt.Image image, Color color, boolean bl) throws BadElementException, IOException {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("java.awt.Image Interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("java.awt.Image fetch aborted or errored");
        }
        int n2 = pixelGrabber.getWidth();
        int n3 = pixelGrabber.getHeight();
        int[] nArray = (int[])pixelGrabber.getPixels();
        if (bl) {
            int n4 = n2 / 8 + ((n2 & 7) != 0 ? 1 : 0);
            byte[] byArray = new byte[n4 * n3];
            int n5 = 0;
            int n6 = n3 * n2;
            boolean bl2 = true;
            if (color != null) {
                bl2 = color.getRed() + color.getGreen() + color.getBlue() >= 384;
            }
            int[] nArray2 = null;
            int n7 = 128;
            int n8 = 0;
            int n9 = 0;
            if (color != null) {
                int n10 = 0;
                while (n10 < n6) {
                    int n11 = nArray[n10] >> 24 & 0xFF;
                    if (n11 < 250) {
                        if (bl2) {
                            n9 |= n7;
                        }
                    } else if ((nArray[n10] & 0x888) != 0) {
                        n9 |= n7;
                    }
                    if ((n7 >>= 1) == 0 || n8 + 1 >= n2) {
                        byArray[n5++] = (byte)n9;
                        n7 = 128;
                        n9 = 0;
                    }
                    if (++n8 >= n2) {
                        n8 = 0;
                    }
                    ++n10;
                }
            } else {
                int n12 = 0;
                while (n12 < n6) {
                    int n13;
                    if (nArray2 == null && (n13 = nArray[n12] >> 24 & 0xFF) == 0) {
                        nArray2 = new int[2];
                        nArray2[1] = (nArray[n12] & 0x888) != 0 ? 1 : 0;
                        nArray2[0] = nArray2[1];
                    }
                    if ((nArray[n12] & 0x888) != 0) {
                        n9 |= n7;
                    }
                    if ((n7 >>= 1) == 0 || n8 + 1 >= n2) {
                        byArray[n5++] = (byte)n9;
                        n7 = 128;
                        n9 = 0;
                    }
                    if (++n8 >= n2) {
                        n8 = 0;
                    }
                    ++n12;
                }
            }
            return Image.getInstance(n2, n3, 1, 1, byArray, nArray2);
        }
        byte[] byArray = new byte[n2 * n3 * 3];
        int n14 = 0;
        int n15 = n3 * n2;
        int n16 = 255;
        int n17 = 255;
        int n18 = 255;
        if (color != null) {
            n16 = color.getRed();
            n17 = color.getGreen();
            n18 = color.getBlue();
        }
        int[] nArray3 = null;
        if (color != null) {
            int n19 = 0;
            while (n19 < n15) {
                int n20 = nArray[n19] >> 24 & 0xFF;
                if (n20 < 250) {
                    byArray[n14++] = (byte)n16;
                    byArray[n14++] = (byte)n17;
                    byArray[n14++] = (byte)n18;
                } else {
                    byArray[n14++] = (byte)(nArray[n19] >> 16 & 0xFF);
                    byArray[n14++] = (byte)(nArray[n19] >> 8 & 0xFF);
                    byArray[n14++] = (byte)(nArray[n19] & 0xFF);
                }
                ++n19;
            }
        } else {
            int n21 = 0;
            while (n21 < n15) {
                int n22;
                if (nArray3 == null && (n22 = nArray[n21] >> 24 & 0xFF) == 0) {
                    nArray3 = new int[6];
                    nArray3[0] = nArray3[1] = nArray[n21] >> 16 & 0xFF;
                    nArray3[2] = nArray3[3] = nArray[n21] >> 8 & 0xFF;
                    nArray3[4] = nArray3[5] = nArray[n21] & 0xFF;
                }
                byArray[n14++] = (byte)(nArray[n21] >> 16 & 0xFF);
                byArray[n14++] = (byte)(nArray[n21] >> 8 & 0xFF);
                byArray[n14++] = (byte)(nArray[n21] & 0xFF);
                ++n21;
            }
        }
        return Image.getInstance(n2, n3, 3, 8, byArray, nArray3);
    }

    public static Image getInstance(java.awt.Image image, Color color) throws BadElementException, IOException {
        return Image.getInstance(image, color, false);
    }

    public static Image getInstance(String string) throws BadElementException, MalformedURLException, IOException {
        return Image.getInstance(Image.toURL(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        ImgWMF imgWMF;
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            Png png;
            block7: {
                Jpeg jpeg;
                block6: {
                    Gif gif;
                    block5: {
                        byteArrayInputStream = null;
                        try {
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            int n2 = ((InputStream)byteArrayInputStream).read();
                            int n3 = ((InputStream)byteArrayInputStream).read();
                            ((InputStream)byteArrayInputStream).close();
                            byteArrayInputStream = null;
                            if (n2 == 71 && n3 == 73) {
                                gif = new Gif(byArray);
                                Object var6_8 = null;
                                if (byteArrayInputStream == null) return gif;
                                break block5;
                            }
                            if (n2 == 255 && n3 == 216) {
                                jpeg = new Jpeg(byArray);
                                break block6;
                            }
                            if (n2 == Png.PNGID[0] && n3 == Png.PNGID[1]) {
                                png = new Png(byArray);
                                break block7;
                            }
                            if (n2 != 215) throw new IOException("Could not find a recognized imageformat.");
                            if (n3 != 205) throw new IOException("Could not find a recognized imageformat.");
                            imgWMF = new ImgWMF(byArray);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            if (byteArrayInputStream == null) throw throwable;
                            ((InputStream)byteArrayInputStream).close();
                            throw throwable;
                        }
                    }
                    ((InputStream)byteArrayInputStream).close();
                    return gif;
                }
                Object var6_9 = null;
                if (byteArrayInputStream == null) return jpeg;
                ((InputStream)byteArrayInputStream).close();
                return jpeg;
            }
            Object var6_10 = null;
            if (byteArrayInputStream == null) return png;
            ((InputStream)byteArrayInputStream).close();
            return png;
        }
        Object var6_11 = null;
        if (byteArrayInputStream == null) return imgWMF;
        ((InputStream)byteArrayInputStream).close();
        return imgWMF;
    }

    public static Image getInstance(int n2, int n3, int n4, int n5, byte[] byArray) throws BadElementException {
        return Image.getInstance(n2, n3, n4, n5, byArray, null);
    }

    public static Image getInstance(PdfTemplate pdfTemplate) throws BadElementException {
        return new ImgTemplate(pdfTemplate);
    }

    public static Image getInstance(int n2, int n3, boolean bl, int n4, int n5, byte[] byArray) throws BadElementException {
        return Image.getInstance(n2, n3, bl, n4, n5, byArray, null);
    }

    public static Image getInstance(int n2, int n3, boolean bl, int n4, int n5, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != 2) {
            throw new BadElementException("Transparency length must be equal to 2 with CCITT images");
        }
        ImgCCITT imgCCITT = new ImgCCITT(n2, n3, bl, n4, n5, byArray);
        imgCCITT.transparency = nArray;
        return imgCCITT;
    }

    public static Image getInstance(int n2, int n3, int n4, int n5, byte[] byArray, int[] nArray) throws BadElementException {
        if (nArray != null && nArray.length != n4 * 2) {
            throw new BadElementException("Transparency length must be equal to (componentes * 2)");
        }
        if (n4 == 1 && n5 == 1) {
            byte[] byArray2 = CCITTG4Encoder.compress(byArray, n2, n3);
            return Image.getInstance(n2, n3, false, 256, 1, byArray2, nArray);
        }
        ImgRaw imgRaw = new ImgRaw(n2, n3, n4, n5, byArray);
        imgRaw.transparency = nArray;
        return imgRaw;
    }

    public static Image getInstance(Properties properties) throws BadElementException, MalformedURLException, IOException {
        String string;
        String string2;
        String string3 = (String)((Hashtable)properties).remove("url");
        if (string3 == null) {
            throw new MalformedURLException("The URL of the image is missing.");
        }
        Image image = Image.getInstance(string3);
        int n2 = 0;
        string3 = (String)((Hashtable)properties).remove("align");
        if (string3 != null) {
            if ("Left".equalsIgnoreCase(string3)) {
                n2 |= 2;
            } else if ("Right".equalsIgnoreCase(string3)) {
                n2 |= 1;
            } else if ("Middle".equalsIgnoreCase(string3)) {
                n2 |= 3;
            } else if ("Center".equalsIgnoreCase(string3)) {
                n2 |= 3;
            }
        }
        if ((string3 = (String)((Hashtable)properties).remove("underlying")) != null && new Boolean(string3).booleanValue()) {
            n2 |= 8;
        }
        if ((string3 = (String)((Hashtable)properties).remove("textwrap")) != null && new Boolean(string3).booleanValue()) {
            n2 |= 4;
        }
        image.setAlignment(n2);
        string3 = (String)((Hashtable)properties).remove("alt");
        if (string3 != null) {
            image.setAlt(string3);
        }
        if ((string2 = (String)((Hashtable)properties).remove("absolutex")) != null && (string = (String)((Hashtable)properties).remove("absolutey")) != null) {
            image.setAbsolutePosition(Float.valueOf(string2 + "f").floatValue(), Float.valueOf(string + "f").floatValue());
        }
        if ((string3 = (String)((Hashtable)properties).remove("plainwidth")) != null) {
            image.scaleAbsoluteWidth(Float.valueOf(string3 + "f").floatValue());
        }
        if ((string3 = (String)((Hashtable)properties).remove("plainheight")) != null) {
            image.scaleAbsoluteHeight(Float.valueOf(string3 + "f").floatValue());
        }
        if ((string3 = (String)((Hashtable)properties).remove("rotation")) != null) {
            image.setRotation(Float.valueOf(string3 + "f").floatValue());
        }
        if (((Hashtable)properties).size() > 0) {
            image.setMarkupAttributes(properties);
        }
        return image;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(float f2, float f3) {
        this.absoluteX = f2;
        this.absoluteY = f3;
    }

    public void scaleAbsolute(float f2, float f3) {
        this.plainWidth = f2;
        this.plainHeight = f3;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteWidth(float f2) {
        this.plainWidth = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleAbsoluteHeight(float f2) {
        this.plainHeight = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scalePercent(float f2) {
        this.scalePercent(f2, f2);
    }

    public void scalePercent(float f2, float f3) {
        this.plainWidth = this.width() * f2 / 100.0f;
        this.plainHeight = this.height() * f3 / 100.0f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleToFit(float f2, float f3) {
        float f4;
        float f5 = f2 * 100.0f / this.width();
        this.scalePercent(f5 < (f4 = f3 * 100.0f / this.height()) ? f5 : f4);
    }

    public void setRotation(float f2) {
        double d2 = Math.PI;
        this.rotation = (float)((double)f2 % (2.0 * d2));
        if (this.rotation < 0.0f) {
            this.rotation = (float)((double)this.rotation + 2.0 * d2);
        }
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void setRotationDegrees(float f2) {
        double d2 = Math.PI;
        this.setRotation(f2 / 180.0f * (float)d2);
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation annotation() {
        return this.annotation;
    }

    public int bpc() {
        return this.bpc;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public PdfTemplate templateData() {
        return this.template;
    }

    public void setTemplateData(PdfTemplate pdfTemplate) {
        this.template = pdfTemplate;
    }

    public boolean hasAbsolutePosition() {
        return !Float.isNaN(this.absoluteY);
    }

    public boolean hasAbsoluteX() {
        return !Float.isNaN(this.absoluteX);
    }

    public float absoluteX() {
        return this.absoluteX;
    }

    public float absoluteY() {
        return this.absoluteY;
    }

    public int type() {
        return this.type;
    }

    public boolean isGif() {
        return this.type == 31;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isPng() {
        return this.type == 33;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public boolean isImgTemplate() {
        return this.type == 35;
    }

    public URL url() {
        return this.url;
    }

    public int alignment() {
        return this.alignment;
    }

    public String alt() {
        return this.alt;
    }

    public float scaledWidth() {
        return this.scaledWidth;
    }

    public float scaledHeight() {
        return this.scaledHeight;
    }

    public int colorspace() {
        return this.colorspace;
    }

    public float[] matrix() {
        float[] fArray = new float[8];
        float f2 = (float)Math.cos(this.rotation);
        float f3 = (float)Math.sin(this.rotation);
        fArray[0] = this.plainWidth * f2;
        fArray[1] = this.plainWidth * f3;
        fArray[2] = -this.plainHeight * f3;
        fArray[3] = this.plainHeight * f2;
        if ((double)this.rotation < 1.5707963267948966) {
            fArray[4] = fArray[2];
            fArray[5] = 0.0f;
            fArray[6] = fArray[0];
            fArray[7] = fArray[1] + fArray[3];
        } else if ((double)this.rotation < Math.PI) {
            fArray[4] = fArray[0] + fArray[2];
            fArray[5] = fArray[3];
            fArray[6] = 0.0f;
            fArray[7] = fArray[1];
        } else if ((double)this.rotation < 4.71238898038469) {
            fArray[4] = fArray[0];
            fArray[5] = fArray[1] + fArray[3];
            fArray[6] = fArray[2];
            fArray[7] = 0.0f;
        } else {
            fArray[4] = 0.0f;
            fArray[5] = fArray[1];
            fArray[6] = fArray[0] + fArray[2];
            fArray[7] = fArray[3];
        }
        return fArray;
    }

    public static void skip(InputStream inputStream, int n2) throws IOException {
        while (n2 > 0) {
            n2 = (int)((long)n2 - inputStream.skip(n2));
        }
    }

    public static URL toURL(String string) throws MalformedURLException {
        if (string.startsWith("file:/") || string.startsWith("http://")) {
            return new URL(string);
        }
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return new URL("file", "", string2);
    }

    public int[] getTransparency() {
        return this.transparency;
    }

    public static boolean isTag(String string) {
        return "image".equals(string);
    }

    public float plainWidth() {
        return this.plainWidth;
    }

    public float plainHeight() {
        return this.plainHeight;
    }

    protected static synchronized Long getSerialId() {
        return new Long(++serialId);
    }

    public Long getMySerialId() {
        return this.mySerialId;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public boolean isMaskCandidate() {
        if (this.type == 34) {
            if (this.bpc > 255) {
                return true;
            }
            return this.bpc == 1 && this.colorspace == 1;
        }
        return this.type == 33 && this.bpc == 1 && this.colorspace == 1;
    }

    public void makeMask() throws DocumentException {
        if (!this.isMaskCandidate()) {
            throw new DocumentException("This image can not be an image mask.");
        }
        this.mask = true;
    }

    public void setImageMask(Image image) throws DocumentException {
        if (this.mask) {
            throw new DocumentException("An image mask can not contain another image mask.");
        }
        if (!image.mask) {
            throw new DocumentException("The image mask is not a mask. Did you do makeMask()?");
        }
        this.imageMask = image;
    }

    public Image getImageMask() {
        return this.imageMask;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setInvertMask(boolean bl) {
        this.invertMask = bl;
    }

    public boolean isInvertMask() {
        return this.invertMask;
    }

    public boolean isInvertedJPEG() {
        return this.invert;
    }

    public boolean isInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(boolean bl) {
        this.interpolation = bl;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

