/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;

public class Font
implements Comparable {
    public static final int COURIER = 0;
    public static final int HELVETICA = 1;
    public static final int TIMES_NEW_ROMAN = 2;
    public static final int SYMBOL = 3;
    public static final int ZAPFDINGBATS = 4;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int BOLDITALIC = 3;
    public static final int UNDEFINED = -1;
    public static final int DEFAULTSIZE = 12;
    private int family = -1;
    private float size = -1.0f;
    private int style = -1;
    private Color color = null;
    private BaseFont baseFont = null;

    public Font(int n2, float f2, int n3, Color color) {
        this.family = n2;
        this.size = f2;
        this.style = n3;
        this.color = color;
    }

    public Font(BaseFont baseFont, float f2, int n2, Color color) {
        this.baseFont = baseFont;
        this.size = f2;
        this.style = n2;
        this.color = color;
    }

    public Font(BaseFont baseFont, float f2, int n2) {
        this(baseFont, f2, n2, null);
    }

    public Font(BaseFont baseFont, float f2) {
        this(baseFont, f2, -1, null);
    }

    public Font(BaseFont baseFont) {
        this(baseFont, -1.0f, -1, null);
    }

    public Font(int n2, float f2, int n3) {
        this(n2, f2, n3, null);
    }

    public Font(int n2, float f2) {
        this(n2, f2, -1, null);
    }

    public Font(int n2) {
        this(n2, -1.0f, -1, null);
    }

    public Font() {
        this(-1, -1.0f, -1, null);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        try {
            Font font = (Font)object;
            if (this.baseFont != null && !this.baseFont.equals(font.getBaseFont())) {
                return -2;
            }
            if (this.family != font.family()) {
                return 1;
            }
            if (this.size != font.size()) {
                return 2;
            }
            if (this.style != font.style()) {
                return 3;
            }
            if (this.color == null) {
                if (font.color == null) {
                    return 0;
                }
                return 4;
            }
            if (font.color == null) {
                return 4;
            }
            if (this.color.equals(font.color())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException classCastException) {
            return -3;
        }
    }

    public void setFamily(String string) {
        this.family = Font.getFamilyIndex(string);
    }

    public static int getFamilyIndex(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Times-Roman") || string.equalsIgnoreCase("Times New Roman")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return 3;
        }
        if (string.equalsIgnoreCase("ZapfDingbats")) {
            return 4;
        }
        return -1;
    }

    public String getFamilyname() {
        String string = "unknown";
        switch (this.family()) {
            case 0: {
                return "Courier";
            }
            case 1: {
                return "Helvetica";
            }
            case 2: {
                return "Times New Roman";
            }
            case 3: {
                return "Symbol";
            }
            case 4: {
                return "ZapfDingbats";
            }
        }
        if (this.baseFont != null) {
            String[][] stringArray = this.baseFont.getFamilyFontName();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if ("0".equals(stringArray[n2][2])) {
                    return stringArray[n2][3];
                }
                if ("1033".equals(stringArray[n2][2])) {
                    string = stringArray[n2][3];
                }
                if ("".equals(stringArray[n2][2])) {
                    string = stringArray[n2][3];
                }
                ++n2;
            }
        }
        return string;
    }

    public void setSize(float f2) {
        this.size = f2;
    }

    public void setStyle(String string) {
        if (this.style == -1) {
            this.style = 0;
        }
        this.style |= Font.getStyleValue(string);
    }

    public static int getStyleValue(String string) {
        int n2 = 0;
        if (string.indexOf("normal") != -1) {
            n2 |= 0;
        }
        if (string.indexOf("bold") != -1) {
            n2 |= 1;
        }
        if (string.indexOf("italic") != -1) {
            n2 |= 2;
        }
        if (string.indexOf("oblique") != -1) {
            n2 |= 2;
        }
        if (string.indexOf("underline") != -1) {
            n2 |= 4;
        }
        if (string.indexOf("line-through") != -1) {
            n2 |= 8;
        }
        return n2;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int n2, int n3, int n4) {
        this.color = new Color(n2, n3, n4);
    }

    public float leading(float f2) {
        if (this.size == -1.0f) {
            return f2 * 12.0f;
        }
        return f2 * this.size;
    }

    public boolean isStandardFont() {
        return this.family == -1 && this.size == -1.0f && this.style == -1 && this.color == null && this.baseFont == null;
    }

    public Font difference(Font font) {
        Color color;
        float f2 = font.size;
        if (f2 == -1.0f) {
            f2 = this.size;
        }
        int n2 = -1;
        int n3 = this.style;
        int n4 = font.style();
        if (n3 != -1 || n4 != -1) {
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            n2 = n3 | n4;
        }
        if ((color = font.color) == null) {
            color = this.color;
        }
        if (font.baseFont != null) {
            return new Font(font.baseFont, f2, n2, color);
        }
        if (font.family() != -1) {
            return new Font(font.family, f2, n2, color);
        }
        if (this.baseFont != null) {
            if (n2 == n3) {
                return new Font(this.baseFont, f2, n2, color);
            }
            return FontFactory.getFont(this.getFamilyname(), f2, n2, color);
        }
        return new Font(this.family, f2, n2, color);
    }

    public int family() {
        return this.family;
    }

    public float size() {
        return this.size;
    }

    public int style() {
        return this.style;
    }

    public boolean isBold() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 2) == 2;
    }

    public boolean isUnderlined() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 4) == 4;
    }

    public boolean isStrikethru() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 8) == 8;
    }

    public Color color() {
        return this.color;
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }
}

