/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ColorList;
import common.StyleList;
import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class Style {
    public String sBackground;
    public String sForeground;
    public String sFont;
    public String sStyle;
    public String sSize;
    public Font font;
    public Color background;
    public Color foreground;
    ColorList colorlist = new ColorList();

    public Style() {
    }

    public Style(String string, String string2, String string3, int n, int n2) {
        this.set(string, string2, string3, n, n2);
        this.init();
    }

    public void set(String string, String string2, String string3, int n, int n2) {
        this.sBackground = string;
        this.sForeground = string2;
        this.sFont = string3;
        this.sStyle = new Integer(n).toString();
        this.sSize = new Integer(n2).toString();
    }

    public void init() {
        this.makeFont();
        this.makeColors();
    }

    public void makeFont() {
        this.font = new Font(this.sFont, StyleList.getStyle(this.sStyle), new Integer(this.sSize));
    }

    public void makeColors() {
        this.makeColors(true);
    }

    public void makeColors(boolean bl) {
        this.background = ColorList.getColor(this.sBackground);
        this.foreground = ColorList.getColor(this.sForeground);
        if (bl && this.background.equals(this.foreground)) {
            System.out.println("Style error bg = fg");
            this.background = Color.lightGray;
            this.foreground = Color.black;
        }
    }

    public void tokenize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            this.sBackground = stringTokenizer.nextToken();
            this.sForeground = stringTokenizer.nextToken();
            this.sFont = stringTokenizer.nextToken();
            this.sStyle = stringTokenizer.nextToken();
            this.sSize = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyInto(Style style) {
        style.sBackground = this.sBackground;
        style.sForeground = this.sForeground;
        style.sFont = this.sFont;
        style.sStyle = this.sStyle;
        style.sSize = this.sSize;
    }

    public String getString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.sBackground))).append(",").append(this.sForeground).append(",").append(this.sFont).append(",").append(this.sStyle).append(",").append(this.sSize)));
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.font.toString()))).append(",").append(this.background.toString()).append(",").append(this.foreground.toString()).append(",")));
    }
}

