/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DMessageBar;
import common.DialogCYN;
import common.Disk;
import common.FindDialog;
import common.FindReplace;
import common.FindReplaceEngine;
import common.History;
import common.Path;
import common.Preferences;
import common.ReplaceDialog;
import common.Style;
import common.TextModel;
import common.Tool;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TextEditor
extends Panel
implements KeyListener,
ActionListener {
    final int CANCEL = 0;
    final int YES = 1;
    final int NO = 2;
    public String TextPath = null;
    public String TextName = null;
    public String TextDir = null;
    public String UpdateDir = null;
    public String m_dirName;
    public String m_fileName;
    public String m_pathName;
    FindReplace m_findReplace;
    TextArea area;
    TextModel textModel;
    public String TextMessage = "";
    public static final String NoName = "+Editor";
    public boolean Editable = true;
    public boolean Edited = false;
    boolean wraparound;
    Frame frame = null;
    ActionListener actionListener = null;
    KeyListener keyListener;
    DMessageBar messageBar = null;
    History history = null;

    public TextEditor(Frame frame) {
        this.setLayout(new GridLayout());
        this.frame = frame;
        this.wraparound = Preferences.wordWrap;
        if (this.wraparound) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        this.area = new TextArea("", 80, 16384, 1);
        this.area.addKeyListener(this);
        this.add(this.area);
        this.textModel = new TextModel(this.area);
        this.m_findReplace = new FindReplace(this.area, this.textModel);
        this.TextName = NoName;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.area.setFont(font);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.area.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.area.setForeground(color);
    }

    public void setStyle(Style style) {
        this.setFont(style.font);
        this.setBackground(style.background);
        this.setForeground(style.foreground);
    }

    public void setEditable(boolean bl) {
        this.Editable = !bl;
        this.area.setEditable(this.Editable);
    }

    public String getDir() {
        return this.m_dirName;
    }

    public void setEdited(boolean bl) {
        this.Edited = bl;
        this.m_findReplace.setEdited(bl);
    }

    public boolean isEdited() {
        if (this.Edited) {
            return true;
        }
        return this.m_findReplace.isEdited();
    }

    public void find() {
        this.m_findReplace.setSelection(this.textModel);
        FindDialog findDialog = new FindDialog(this.frame, "Find", false, this.m_findReplace);
        try {
            findDialog.setVisible(true);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void findSelection() {
        if (this.textModel.isSelected()) {
            this.m_findReplace.setFind(this.textModel.getSelectedText());
            this.m_findReplace.setIndex(this.textModel.getSelectionEnd());
            this.findString();
            return;
        }
        this.findAgain();
    }

    public void findAgain() {
        String string = this.m_findReplace.getFind();
        if (!(string != null && string.length() != 0 || this.m_findReplace.setSelection(this.textModel))) {
            this.find();
            return;
        }
        int n = this.textModel.isSelected() ? this.textModel.getSelectionEnd() : this.textModel.getCaretPosition();
        this.m_findReplace.setIndex(n);
        this.findString();
    }

    public void findString() {
        FindReplaceEngine findReplaceEngine = new FindReplaceEngine(this.m_findReplace);
        findReplaceEngine.FindIt();
        if (!this.m_findReplace.isFoundIt()) {
            Tool.beep();
        }
    }

    public void replace() {
        this.m_findReplace.setSelection(this.textModel);
        try {
            ReplaceDialog replaceDialog = new ReplaceDialog(this.frame, "Replace", false, this.m_findReplace);
            replaceDialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void selectAll() {
        this.message("Entire text is selected");
        this.area.select(0, this.area.getText().length());
    }

    public void undo() {
        this.textModel.undo();
    }

    public void setTextInfo() {
        int[] nArray = this.textModel.getLineCol();
        this.TextMessage = String.valueOf(String.valueOf(new StringBuffer("Line ").append(nArray[0]).append(" Column ").append(nArray[1]).append("    Pos ").append(this.textModel.getCaretPosition()).append("  Size ").append(this.textModel.size())));
    }

    public void setPath(String string, String string2) {
        this.m_dirName = string;
        this.m_fileName = string2;
        this.m_pathName = Path.merge(this.m_dirName, this.m_fileName);
    }

    public void changeName() {
        this.TextName = this.m_fileName;
        this.TextDir = this.m_dirName;
        this.TextPath = this.m_pathName;
        this.UpdateDir = this.m_dirName;
        this.setEdited(false);
    }

    public boolean newText() {
        return this.newText("");
    }

    public boolean newText(String string) {
        if (this.savePrevious()) {
            return false;
        }
        this.area.setText(string);
        return true;
    }

    public boolean open() {
        if (this.m_fileName == null) {
            return true;
        }
        if (this.m_pathName == null) {
            this.m_pathName = "";
            this.m_dirName = "";
        }
        this.area.setText("");
        String string = Disk.loadText(this.m_dirName, this.m_fileName);
        int n = string.length();
        if (n > 0) {
            System.gc();
            this.area.setText(string);
            this.area.select(0, 0);
            this.textModel.clearUndo();
            if (this.textModel.size() > 0) {
                this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.m_fileName))).append(" loaded, size ").append(n).append(" bytes"))));
                return true;
            }
            this.message("Enable to display ".concat(String.valueOf(String.valueOf(this.m_pathName))));
        } else {
            this.message("Enable to load ".concat(String.valueOf(String.valueOf(this.m_pathName))));
        }
        return false;
    }

    public boolean close() {
        if (this.isEdited()) {
            DialogCYN dialogCYN = new DialogCYN(this.frame, "Saving the text?");
            dialogCYN.setVisible(true);
            if (dialogCYN.answer == 1) {
                if (this.savePrevious()) {
                    return false;
                }
                if (dialogCYN.answer == 2) {
                    return false;
                }
            }
        }
        this.newText();
        return true;
    }

    public void insert() {
        FileDialog fileDialog = new FileDialog(this.frame);
        fileDialog.setMode(0);
        ((Dialog)fileDialog).setTitle("Open");
        fileDialog.setDirectory(this.m_dirName);
        ((Component)fileDialog).setVisible(true);
        this.insert(fileDialog.getDirectory(), fileDialog.getFile());
    }

    public void insert(String string, String string2) {
        if (string2 != null) {
            int n;
            if (string == null) {
                string = "";
            }
            if ((n = Disk.insert(string, string2, this.textModel)) > 0) {
                this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(" loaded and inserted (").append(n).append(" bytes)"))));
                this.setEdited(true);
            } else {
                this.message(String.valueOf(String.valueOf(new StringBuffer("Enable to load ").append(string2).append(" from ").append(string))));
            }
        }
    }

    public boolean cancelled() {
        this.message("Cancelled...");
        return false;
    }

    public boolean saveAs() {
        if (this.TextName.compareTo(NoName) == 0) {
            this.TextName = "";
        }
        FileDialog fileDialog = new FileDialog(this.frame);
        fileDialog.setMode(1);
        ((Dialog)fileDialog).setTitle("Save");
        fileDialog.setFile(this.TextName);
        fileDialog.setDirectory(this.m_dirName);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string == null) {
            return this.cancelled();
        }
        if (string2 == null) {
            return this.cancelled();
        }
        if (string2.length() == 0) {
            return this.cancelled();
        }
        this.setPath(string, string2);
        int n = Disk.saveProtect(this.m_dirName, this.m_fileName, 1, this.area.getText());
        if (n > 0) {
            this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.TextName))).append(" saved as ").append(this.m_pathName).append(" ").append(n).append(" bytes"))));
        }
        this.changeName();
        this.sendSource("modified");
        return true;
    }

    public int saveBefore() {
        if (this.isEdited()) {
            DialogCYN dialogCYN = new DialogCYN(this.frame, "Text not saved. Save it?");
            dialogCYN.setVisible(true);
            if (dialogCYN.answer == 2) {
                return 0;
            }
            if (dialogCYN.answer == 1) {
                if (!this.save()) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    public boolean save() {
        boolean bl;
        if (this.TextName == null) {
            return this.saveAs();
        }
        if (this.TextName.length() == 0) {
            return this.saveAs();
        }
        if (this.TextName.compareTo(NoName) == 0) {
            return this.saveAs();
        }
        int n = Disk.saveProtect(this.TextDir, this.TextName, 1, this.area.getText());
        if (n > 0) {
            this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.TextName))).append(" saved, ").append(n).append(" bytes"))));
            this.setEdited(false);
            this.UpdateDir = this.TextDir;
            this.sendSource("modified");
            bl = true;
        } else {
            this.message("Error, not saved");
            bl = false;
        }
        return bl;
    }

    public boolean savePrevious() {
        if (!this.isEdited()) {
            return false;
        }
        String string = this.m_fileName;
        String string2 = this.m_dirName;
        boolean bl = this.saveBefore() == 0;
        this.setPath(string2, string);
        return bl;
    }

    public boolean saveBlock() {
        String string = this.textModel.getSelectedText();
        if (string.length() == 0) {
            this.dispTip("Select a block of text to save");
            Tool.beep();
            return false;
        }
        FileDialog fileDialog = new FileDialog(this.frame);
        fileDialog.setMode(1);
        ((Dialog)fileDialog).setTitle("Save");
        fileDialog.setFile("");
        fileDialog.setDirectory(this.TextDir);
        ((Component)fileDialog).setVisible(true);
        String string2 = fileDialog.getFile();
        String string3 = fileDialog.getDirectory();
        if (string2 != null) {
            int n = Disk.saveBlock(string3, string2, string);
            if (n > 0) {
                this.UpdateDir = string3;
                this.message(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(" saved into ").append(string3).append(" ").append(n).append(" bytes"))));
                this.sendSource("modified");
                return true;
            }
            this.message("Error, not saved");
        }
        return false;
    }

    public void requestFocus() {
        this.area.requestFocus();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!this.isVisible()) {
            return;
        }
        if (keyEvent.isAltDown()) {
            switch (n) {
                case 87: {
                    this.saveBlock();
                    keyEvent.consume();
                    return;
                }
                case 73: {
                    if (this.Editable) {
                        this.insert();
                    }
                    keyEvent.consume();
                    return;
                }
            }
            this.sendKey(keyEvent);
            return;
        }
        if (keyEvent.isControlDown()) {
            switch (n) {
                case 70: {
                    this.find();
                    keyEvent.consume();
                    return;
                }
                case 68: {
                    this.setTextInfo();
                    this.dispTip(this.TextMessage);
                    keyEvent.consume();
                    return;
                }
            }
            if (this.Editable) {
                switch (n) {
                    case 83: {
                        this.save();
                        keyEvent.consume();
                        return;
                    }
                    case 82: {
                        this.replace();
                        keyEvent.consume();
                        return;
                    }
                    case 69: {
                        this.textModel.clearEOL();
                        keyEvent.consume();
                        return;
                    }
                    case 89: {
                        this.textModel.clearLine();
                        keyEvent.consume();
                        return;
                    }
                    case 90: {
                        this.undo();
                        keyEvent.consume();
                        return;
                    }
                }
                return;
            }
        }
        if (n == 114) {
            this.findSelection();
            keyEvent.consume();
            return;
        }
        if (keyEvent.isActionKey()) {
            this.dispTip("");
            return;
        }
        if (this.Editable) {
            char c;
            char c2;
            if (!this.isEdited()) {
                this.dispTip("");
                this.setEdited(true);
            }
            if ((c2 = keyEvent.getKeyChar()) != (c = new Character(c2).charValue())) {
                keyEvent.consume();
            }
            keyEvent.setKeyChar(c);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    public void sendKey(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            this.keyListener.keyPressed(keyEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.sendSource(actionEvent.getActionCommand());
    }

    public void sendSource(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void setMessage(DMessageBar dMessageBar) {
        this.messageBar = dMessageBar;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public void dispTip(String string) {
        if (this.messageBar != null) {
            this.messageBar.setText(" ".concat(String.valueOf(String.valueOf(string))));
        }
    }

    public void message(String string) {
        this.dispTip(string);
        if (this.history != null) {
            this.history.tell(string);
        }
    }
}

