// EncDlg.cpp : implementation file
//

#include "stdafx.h"
#include "detest.h"
#include "decenc.h"
#include "EncDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEncodeDlg dialog


CEncodeDlg::CEncodeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEncodeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEncodeDlg)
	m_strData = _T("Sample Text");
	m_nEncoding = 0;
	//}}AFX_DATA_INIT
}


void CEncodeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEncodeDlg)
	DDX_Text(pDX, IDC_DATA_ED, m_strData);
	DDX_CBIndex(pDX, IDC_ENCODING_CB, m_nEncoding);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEncodeDlg, CDialog)
	//{{AFX_MSG_MAP(CEncodeDlg)
	ON_BN_CLICKED(IDC_DECODE, OnDecode)
	ON_BN_CLICKED(IDC_ENCODE, OnEncode)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEncodeDlg message handlers

void CEncodeDlg::OnOK() 
{
}

void CEncodeDlg::OnDecode() 
{
	UpdateData();

    int nEncoding = m_nEncoding + 1;
    if (nEncoding > 2)
        ++nEncoding;
    CString strOutBuffer;
    strOutBuffer.ReleaseBuffer(DecodeBuffer((LPCTSTR)m_strData, strOutBuffer.GetBuffer(m_strData.GetLength()), m_strData.GetLength(), nEncoding));
    m_strData = strOutBuffer;
    UpdateData(FALSE);
}

void CEncodeDlg::OnEncode() 
{
	UpdateData();

    int nEncoding = m_nEncoding + 1;
    if (nEncoding > 2)
        ++nEncoding;
    CString strOutBuffer;
    strOutBuffer.ReleaseBuffer(EncodeBuffer((LPCTSTR)m_strData, strOutBuffer.GetBuffer(m_strData.GetLength() * 3 / 2 + 10), m_strData.GetLength(), nEncoding));
    m_strData = strOutBuffer;
    UpdateData(FALSE);
}
