/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Arrays;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class IPAddressName
implements GeneralNameInterface {
    private byte[] address;

    public IPAddressName(DerValue derValue) throws IOException {
        this.address = derValue.getOctetString();
    }

    public IPAddressName(byte[] byArray) {
        this.address = byArray;
    }

    public int getType() {
        return 7;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOctetString(this.address);
    }

    public String toString() {
        return "IPAddress: " + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
    }

    public byte[] getBytes() {
        return (byte[])this.address.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPAddressName)) {
            return false;
        }
        IPAddressName iPAddressName = (IPAddressName)object;
        return Arrays.equals(this.address, iPAddressName.address);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.address.length) {
            n += this.address[n2] * n2;
            ++n2;
        }
        return n;
    }
}

