/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import sun.awt.color.ICC_Transform;

public class ICC_ColorSpace
extends ColorSpace {
    private ICC_Profile thisProfile;
    private transient ICC_Transform this2srgb;
    private transient ICC_Transform srgb2this;
    private transient ICC_Transform this2xyz;
    private transient ICC_Transform xyz2this;

    public ICC_ColorSpace(ICC_Profile iCC_Profile) {
        super(iCC_Profile.getColorSpaceType(), iCC_Profile.getNumComponents());
        int n = iCC_Profile.getProfileClass();
        if (n != 0 && n != 1 && n != 2 && n != 4 && n != 6) {
            throw new IllegalArgumentException("Invalid profile type");
        }
        this.thisProfile = iCC_Profile;
    }

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    public float[] toRGB(float[] fArray) {
        float[] fArray2;
        if (this.this2srgb == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, -1, 1);
            iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 2);
            this.this2srgb = new ICC_Transform(iCC_TransformArray);
        }
        if (ColorSpace.isCS_CIEXYZ(this)) {
            fArray2 = new float[3];
            float f = 0.5000076f;
            fArray2[0] = fArray[0] * f;
            fArray2[1] = fArray[1] * f;
            fArray2[2] = fArray[2] * f;
        } else {
            fArray2 = fArray;
        }
        float[] fArray3 = new float[3];
        this.this2srgb.colorConvert(1, fArray2, fArray3);
        return fArray3;
    }

    public float[] fromRGB(float[] fArray) {
        if (this.srgb2this == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
            iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, -1, 2);
            this.srgb2this = new ICC_Transform(iCC_TransformArray);
        }
        float[] fArray2 = new float[this.getNumComponents()];
        this.srgb2this.colorConvert(1, fArray, fArray2);
        if (ColorSpace.isCS_CIEXYZ(this)) {
            float f = 1.9999695f;
            fArray2[0] = fArray2[0] * f;
            fArray2[1] = fArray2[1] * f;
            fArray2[2] = fArray2[2] * f;
        }
        return fArray2;
    }

    public float[] toCIEXYZ(float[] fArray) {
        if (this.this2xyz == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            try {
                iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, 1, 1);
            }
            catch (CMMException cMMException) {
                iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, -1, 1);
            }
            iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 2);
            this.this2xyz = new ICC_Transform(iCC_TransformArray);
        }
        float[] fArray2 = new float[3];
        this.this2xyz.colorConvert(1, fArray, fArray2);
        float f = 1.9999695f;
        fArray2[0] = fArray2[0] * f;
        fArray2[1] = fArray2[1] * f;
        fArray2[2] = fArray2[2] * f;
        return fArray2;
    }

    public float[] fromCIEXYZ(float[] fArray) {
        if (this.xyz2this == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
            try {
                iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, 1, 2);
            }
            catch (CMMException cMMException) {
                iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, -1, 2);
            }
            this.xyz2this = new ICC_Transform(iCC_TransformArray);
        }
        float[] fArray2 = new float[3];
        float f = 0.5000076f;
        fArray2[0] = fArray[0] * f;
        fArray2[1] = fArray[1] * f;
        fArray2[2] = fArray[2] * f;
        float[] fArray3 = new float[this.getNumComponents()];
        this.xyz2this.colorConvert(1, fArray2, fArray3);
        return fArray3;
    }
}

