/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class X509Key
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;

    public X509Key() {
    }

    private X509Key(AlgorithmId algorithmId, byte[] byArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
    }

    public static PublicKey parse(DerValue derValue) throws IOException {
        PublicKey publicKey;
        if (derValue.tag != 48) {
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
        try {
            publicKey = X509Key.buildX509Key(algorithmId, derValue.data.getBitString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("subject key, " + invalidKeyException.getMessage());
        }
        if (derValue.data.available() != 0) {
            throw new IOException("excess subject key");
        }
        return publicKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PublicKey buildX509Key(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        DerOutputStream derOutputStream = new DerOutputStream();
        X509Key.encode(derOutputStream, algorithmId, byArray);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.toString());
        }
        String string = "";
        try {
            Object object;
            Class clazz;
            block13: {
                Provider provider = Security.getProvider("SUN");
                if (provider == null) {
                    throw new InstantiationException();
                }
                string = provider.getProperty("PublicKey.X.509." + algorithmId.getName());
                if (string == null) {
                    throw new InstantiationException();
                }
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = ClassLoader.getSystemClassLoader();
                    if (object == null) break block13;
                    clazz = ((ClassLoader)object).loadClass(string);
                }
            }
            Object object2 = null;
            if (clazz != null) {
                object2 = clazz.newInstance();
            }
            if (object2 instanceof X509Key) {
                object = (X509Key)object2;
                ((X509Key)object).algid = algorithmId;
                ((X509Key)object).key = byArray;
                ((X509Key)object).parseKeyBits();
                return object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(string + " [internal error]");
        }
        X509Key x509Key = new X509Key();
        x509Key.algid = algorithmId;
        x509Key.key = byArray;
        return x509Key;
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        X509Key.encode(derOutputStream, this.algid, this.key);
    }

    public synchronized byte[] getEncoded() {
        byte[] byArray = null;
        try {
            byArray = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return byArray;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse(derValue.data.getDerValue());
            this.key = derValue.data.getBitString();
            this.parseKeyBits();
            if (derValue.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("IOException: " + iOException.getMessage());
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            byte[] byArray = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            byte[] byArray2 = key.getEncoded();
            return MessageDigest.isEqual(byArray, byArray2);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getEncoded();
        int n2 = 1;
        while (n2 < byArray.length) {
            n += byArray[n2] * n2;
            ++n2;
        }
        return n;
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putBitString(byArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }
}

