/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class MotifToggleButtonUI
extends BasicToggleButtonUI {
    private static final MotifToggleButtonUI motifToggleButtonUI = new MotifToggleButtonUI();
    protected Color selectColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return motifToggleButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.defaults_initialized = true;
        }
        abstractButton.setOpaque(false);
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Color color = graphics.getColor();
            Dimension dimension = abstractButton.getSize();
            Insets insets = abstractButton.getInsets();
            Insets insets2 = abstractButton.getMargin();
            if (abstractButton.getBackground() instanceof UIResource) {
                graphics.setColor(this.getSelectColor());
            }
            graphics.fillRect(insets.left - insets2.left, insets.top - insets2.top, dimension.width - (insets.left - insets2.left) - (insets.right - insets2.right), dimension.height - (insets.top - insets2.top) - (insets.bottom - insets2.bottom));
            graphics.setColor(color);
        }
    }

    public Insets getInsets(JComponent jComponent) {
        Border border = jComponent.getBorder();
        Insets insets = border != null ? border.getBorderInsets(jComponent) : new Insets(0, 0, 0, 0);
        return insets;
    }
}

