/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Serializable;

public class GFacet
implements Serializable {
    public static final String DRAW_OK = "ok";
    public GEdgeList edgeList;
    private Color color;
    public transient GEdgeList tempEdges;
    private transient GEdge markedEdge;
    private transient boolean selected;
    private transient boolean marked;

    public GFacet(GEdgeList gEdgeList, Color color) {
        this.edgeList = gEdgeList;
        this.tempEdges = new GEdgeList();
        this.color = color;
    }

    public void print() {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            System.out.print(gEdgeNode.getEdge().getHead().getLabel());
            gEdgeNode = gEdgeNode.getNext();
        }
        System.out.print("  ");
        while (gEdgeNode != null) {
            gEdgeNode.getEdge().print();
            System.out.print(" ");
            gEdgeNode = gEdgeNode.getNext();
        }
        System.out.println();
    }

    public String toString() {
        String string = new String();
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            string = String.valueOf(string) + gEdgeNode.getEdge().getHead().getLabel();
            gEdgeNode = gEdgeNode.getNext();
        }
        return string;
    }

    public GEdge getMarkedEdge() {
        return this.markedEdge;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void switchSelection() {
        this.selected = !this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    public GVertex seek(GPoint3D gPoint3D) {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            GVertex gVertex = gEdge.vertexList.seek(gPoint3D, gEdge.getLength());
            if (gVertex != null) {
                return gVertex;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public GFacet engross(GVertex gVertex, boolean bl) {
        Serializable serializable;
        GPoint3D gPoint3D = gVertex.xyzCrds;
        if (this.getAttitude(gPoint3D) != 0) {
            return null;
        }
        GEdgeList gEdgeList = new GEdgeList();
        GEdgeList gEdgeList2 = new GEdgeList();
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GPoint3D gPoint3D2 = gEdgeNode.getEdge().getHead().xyzCrds;
        GPoint3D gPoint3D3 = gEdgeNode.getEdge().getTail().xyzCrds;
        gEdgeNode.getNext().getEdge().getTail();
        while (gEdgeNode != null) {
            serializable = gEdgeNode.getEdge();
            if (bl && ((GEdge)serializable).twin == null) break;
            gPoint3D2 = ((GEdge)serializable).getHead().xyzCrds;
            gPoint3D3 = ((GEdge)serializable).getTail().xyzCrds;
            double d = GMath.mixtP(GMath.subtract(gPoint3D3, gPoint3D), GMath.subtract(gPoint3D2, gPoint3D), this.getXYZNormal());
            if (d < 0.0) {
                gEdgeList.addToTail((GEdge)serializable);
            } else if (d > 0.0) {
                gEdgeList2.addToTail((GEdge)serializable);
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        if (gEdgeList2.getDim() == 0) {
            return this;
        }
        serializable = gEdgeList.toChain();
        GEdge gEdge = new GEdge(gVertex, ((GEdgeList)serializable).getHead().getEdge().getHead());
        GEdge gEdge2 = new GEdge(((GEdgeList)serializable).getTail().getEdge().getTail(), gVertex);
        ((GEdgeList)serializable).addToHead(gEdge);
        ((GEdgeList)serializable).addToTail(gEdge2);
        return new GFacet((GEdgeList)serializable, this.color);
    }

    public int getAttitude(GPoint3D gPoint3D) {
        double d;
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GEdgeNode gEdgeNode2 = gEdgeNode.getNext();
        GEdge gEdge = gEdgeNode.getEdge();
        GPoint3D gPoint3D2 = gEdge.getHead().xyzCrds;
        GPoint3D gPoint3D3 = gEdge.getTail().xyzCrds;
        GPoint3D gPoint3D4 = gEdgeNode2.getEdge().getTail().xyzCrds;
        double d2 = GMath.mixtP(GMath.subtract(gPoint3D3, gPoint3D2), GMath.subtract(gPoint3D4, gPoint3D3), GMath.subtract(gPoint3D, gPoint3D2));
        if (GMath.isAtZero(d2, (d = gEdge.getLength()) * d * d)) {
            return 0;
        }
        if (d2 > 0.0) {
            return 1;
        }
        return -1;
    }

    public int getAttitude(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        GEdge gEdge = this.edgeList.getHead().getEdge();
        GEdge gEdge2 = this.edgeList.getHead().getNext().getEdge();
        int n = gEdge.getHead().getAttitude(gPoint3D, gPoint3D2);
        int n2 = gEdge.getTail().getAttitude(gPoint3D, gPoint3D2);
        int n3 = gEdge2.getTail().getAttitude(gPoint3D, gPoint3D2);
        if (n == 0 && n2 == 0 && n3 == 0) {
            return 0;
        }
        if (n == 1 || n2 == 1 || n3 == 1) {
            return 1;
        }
        return -1;
    }

    public void orient(GPoint3D gPoint3D, int n) {
        if (this.getAttitude(gPoint3D) != n) {
            this.edgeList = this.edgeList.reverse();
        }
    }

    public int getVisibility() {
        double d;
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GEdgeNode gEdgeNode2 = gEdgeNode.getNext();
        GEdge gEdge = gEdgeNode.getEdge();
        GPoint3D gPoint3D = gEdge.getHead().uvwCrds;
        GPoint3D gPoint3D2 = gEdge.getTail().uvwCrds;
        GPoint3D gPoint3D3 = gEdgeNode2.getEdge().getTail().uvwCrds;
        GPoint3D gPoint3D4 = new GPoint3D(0.0, 0.0, 1.0);
        double d2 = GMath.mixtP(GMath.subtract(gPoint3D2, gPoint3D), GMath.subtract(gPoint3D3, gPoint3D2), gPoint3D4);
        if (GMath.isAtZero(d2, (d = gEdge.getLength()) * d * d)) {
            return 0;
        }
        if (d2 > 0.0) {
            return 1;
        }
        return -1;
    }

    public GPoint3D getXYZNormal() {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GEdgeNode gEdgeNode2 = gEdgeNode.getNext();
        GPoint3D gPoint3D = gEdgeNode.getEdge().getHead().xyzCrds;
        GPoint3D gPoint3D2 = gEdgeNode.getEdge().getTail().xyzCrds;
        GPoint3D gPoint3D3 = gEdgeNode2.getEdge().getTail().xyzCrds;
        return GMath.vectorP(GMath.subtract(gPoint3D2, gPoint3D), GMath.subtract(gPoint3D3, gPoint3D2));
    }

    public GPoint3D getUVWNormal() {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GEdgeNode gEdgeNode2 = gEdgeNode.getNext();
        GPoint3D gPoint3D = gEdgeNode.getEdge().getHead().uvwCrds;
        GPoint3D gPoint3D2 = gEdgeNode.getEdge().getTail().uvwCrds;
        GPoint3D gPoint3D3 = gEdgeNode2.getEdge().getTail().uvwCrds;
        return GMath.vectorP(GMath.subtract(gPoint3D2, gPoint3D), GMath.subtract(gPoint3D3, gPoint3D2));
    }

    public boolean encircles(GPoint3D gPoint3D) {
        GPoint3D gPoint3D2 = this.getXYZNormal();
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            GPoint3D gPoint3D3;
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.passesThrough(gPoint3D)) {
                return true;
            }
            GPoint3D gPoint3D4 = GMath.subtract(gEdge.getHead().xyzCrds, gPoint3D);
            if (GMath.mixtP(gPoint3D4, gPoint3D3 = GMath.subtract(gEdge.getTail().xyzCrds, gEdge.getHead().xyzCrds), gPoint3D2) < 0.0) {
                return false;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return true;
    }

    public int getProperDim() {
        int n = 0;
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            ++n;
            gEdgeNode = gEdgeNode.getNext();
        }
        return n;
    }

    public GVertexList cutOffEdge(GEdge gEdge, GVertex gVertex, GVertex gVertex2) {
        if (gEdge.wing2 != null || this.edgeList.seek(gEdge) == null || gEdge.vertexList.seek(gVertex) == null || gEdge.vertexList.seek(gVertex2) == null) {
            return null;
        }
        GEdge[] gEdgeArray = gEdge.cutBetween(gVertex, gVertex2);
        this.edgeList.remove(gEdge);
        if (gEdgeArray[0] != null) {
            this.edgeList.addToTail(gEdgeArray[0]);
        }
        if (gEdgeArray[1] != null) {
            this.edgeList.addToTail(gEdgeArray[1]);
        }
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = gEdge.vertexList.getHead();
        while (gVertexNode != null) {
            GVertex gVertex3 = gVertexNode.getVertex();
            boolean bl = false;
            GEdgeNode gEdgeNode = this.edgeList.getHead();
            while (gEdgeNode != null) {
                if (gEdgeNode.getEdge().vertexList.seek(gVertex3) != null) {
                    bl = true;
                    break;
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            if (!bl) {
                gVertexList.addToTail(gVertex3);
            }
            gVertexNode = gVertexNode.getNext();
        }
        return gVertexList;
    }

    public void auctionVertex(GVertex gVertex) {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(gVertex) == null && gEdge.passesThrough(gVertex.xyzCrds)) {
                gEdge.addVertex(gVertex);
                if (gEdge.twin != null) {
                    gEdge.twin.addVertex(gVertex);
                }
            }
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public void auctionEdge(GEdge gEdge) {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GEdge gEdge2 = gEdgeNode.getEdge();
            if (gEdge2.twin == null && gEdge2 != gEdge) {
                GVertexNode gVertexNode = gEdge2.vertexList.getHead();
                while (gVertexNode != null) {
                    GVertex gVertex = gVertexNode.getVertex();
                    if (gEdge.vertexList.seek(gVertex) == null && gEdge.passesThrough(gVertex.xyzCrds)) {
                        gEdge.addVertex(gVertex);
                    }
                    gVertexNode = gVertexNode.getNext();
                }
            }
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public void mergeEdges(GEdge gEdge) {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GVertexNode gVertexNode;
            GEdge gEdge2 = gEdgeNode.getEdge();
            if (gEdge2.twin != null || gEdge2 == gEdge) {
                gEdgeNode = gEdgeNode.getNext();
                continue;
            }
            GVertex gVertex = gEdge.getHead();
            GVertex gVertex2 = gEdge.getTail();
            GVertex gVertex3 = gEdge2.getHead();
            GVertex gVertex4 = gEdge2.getTail();
            GPoint3D gPoint3D = gVertex.xyzCrds;
            GPoint3D gPoint3D2 = gVertex2.xyzCrds;
            GPoint3D gPoint3D3 = gVertex3.xyzCrds;
            GPoint3D gPoint3D4 = gVertex4.xyzCrds;
            if (!GMath.areCollinear(gPoint3D, gPoint3D2, gPoint3D3) || !GMath.areCollinear(gPoint3D, gPoint3D2, gPoint3D4)) {
                gEdgeNode = gEdgeNode.getNext();
                continue;
            }
            if (gEdge.vertexList.seek(gVertex3) != null && gEdge.vertexList.seek(gVertex4) != null) {
                this.edgeList.remove(gEdgeNode);
                gEdgeNode = gEdgeNode.getNext();
                continue;
            }
            if (gEdge2.vertexList.seek(gVertex) != null && gEdge2.vertexList.seek(gVertex2) != null) {
                gEdge.vertexList = gEdge2.vertexList;
                this.edgeList.remove(gEdgeNode);
                gEdgeNode = gEdgeNode.getNext();
                continue;
            }
            if (gEdge.vertexList.seek(gVertex3) != null) {
                if (gEdge2.vertexList.seek(gVertex2) != null) {
                    gVertexNode = gEdge2.vertexList.getHead();
                    while (gVertexNode != null) {
                        if (gVertexNode.getVertex() == gVertex2) break;
                        gVertexNode = gVertexNode.getNext();
                    }
                    gVertexNode = gVertexNode.getNext();
                    while (gVertexNode != null) {
                        gEdge.vertexList.addToTail(gVertexNode.getVertex());
                        gVertexNode = gVertexNode.getNext();
                    }
                } else {
                    gVertexNode = gEdge2.vertexList.getHead();
                    while (gVertexNode != null) {
                        if (gVertexNode.getVertex() == gVertex) break;
                        gVertexNode = gVertexNode.getNext();
                    }
                    gVertexNode = gVertexNode.getNext();
                    while (gVertexNode != null) {
                        gEdge.vertexList.addToHead(gVertexNode.getVertex());
                        gVertexNode = gVertexNode.getNext();
                    }
                }
                this.edgeList.remove(gEdgeNode);
            } else if (gEdge.vertexList.seek(gVertex4) != null) {
                if (gEdge2.vertexList.seek(gVertex2) != null) {
                    gVertexNode = gEdge2.vertexList.getTail();
                    while (gVertexNode != null) {
                        if (gVertexNode.getVertex() == gVertex2) break;
                        gVertexNode = gVertexNode.getPrev();
                    }
                    gVertexNode = gVertexNode.getPrev();
                    while (gVertexNode != null) {
                        gEdge.vertexList.addToTail(gVertexNode.getVertex());
                        gVertexNode = gVertexNode.getPrev();
                    }
                } else {
                    gVertexNode = gEdge2.vertexList.getTail();
                    while (gVertexNode != null) {
                        if (gVertexNode.getVertex() == gVertex) break;
                        gVertexNode = gVertexNode.getPrev();
                    }
                    gVertexNode = gVertexNode.getPrev();
                    while (gVertexNode != null) {
                        gEdge.vertexList.addToHead(gVertexNode.getVertex());
                        gVertexNode = gVertexNode.getPrev();
                    }
                }
                this.edgeList.remove(gEdgeNode);
            }
            gEdgeNode = gEdgeNode.getNext();
        }
    }

    public GPointObject[] getIntercept(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        GPointObject[] gPointObjectArray = new GPointObject[2];
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.twin == null) break;
            GPointObject gPointObject = gEdge.intersectPlane(gPoint3D, gPoint3D2);
            if (gPointObject != null) {
                if (gPointObjectArray[0] == null) {
                    gPointObjectArray[0] = gPointObject;
                } else if (gPointObject != gPointObjectArray[0]) {
                    gPointObjectArray[1] = gPointObject;
                    break;
                }
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return gPointObjectArray;
    }

    public GVertex getIntercept(GVertex gVertex, GPoint3D gPoint3D, GLabelList gLabelList) {
        GLabelNode gLabelNode = gLabelList.getFirstUnmarked();
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.twin == null) break;
            GPointObject gPointObject = gEdge.intersectPlane(gVertex.xyzCrds, gPoint3D);
            if (gPointObject instanceof GVertex && gPointObject != gVertex) {
                GVertex gVertex2 = (GVertex)gPointObject;
                this.markedEdge = gEdge;
                return gVertex2;
            }
            if (gPointObject instanceof GPoint3D) {
                GVertex gVertex3 = new GVertex((GPoint3D)gPointObject, gLabelNode.getLabel(), false);
                gLabelNode.setMarked(true);
                gEdge.addVertex(gVertex3);
                gEdge.twin.addVertex(gVertex3);
                this.markedEdge = gEdge;
                return gVertex3;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public double measureDistance(GVertex gVertex, GVertex gVertex2, boolean bl) {
        if (this.edgeList.seek(gVertex) == null || this.edgeList.seek(gVertex2) == null) {
            return -1.0;
        }
        if (bl) {
            gVertex.setSelected(true);
            gVertex2.setSelected(true);
            this.tempEdges.addToTail(new GEdge(gVertex, gVertex2));
        }
        return GMath.dist(gVertex.xyzCrds, gVertex2.xyzCrds);
    }

    public double measureAngle(GVertex[] gVertexArray, boolean bl) {
        int n = 0;
        while (n < 3) {
            if (this.edgeList.seek(gVertexArray[n]) == null) {
                return -1.0;
            }
            ++n;
        }
        GEdge gEdge = new GEdge(gVertexArray[0], gVertexArray[1]);
        GEdge gEdge2 = new GEdge(gVertexArray[0], gVertexArray[2]);
        if (bl) {
            this.tempEdges.addToTail(gEdge);
            this.tempEdges.addToTail(gEdge2);
        }
        return GMath.angle(gEdge, gEdge2) * 180.0 / Math.PI;
    }

    public String drawLine(GVertex gVertex, GVertex gVertex2) {
        GEdge gEdge;
        boolean bl = false;
        boolean bl2 = false;
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            boolean bl3;
            gEdge = gEdgeNode.getEdge();
            boolean bl4 = gEdge.vertexList.seek(gVertex) != null;
            boolean bl5 = bl3 = gEdge.vertexList.seek(gVertex2) != null;
            if (bl4 && bl3) {
                return "Line " + gVertex.getLabel() + gVertex2.getLabel() + " already drawn";
            }
            bl = bl || bl4;
            bl2 = bl2 || bl3;
            gEdgeNode = gEdgeNode.getNext();
        }
        if (bl && bl2) {
            gEdge = new GEdge(gVertex, gVertex2, this);
            this.edgeList.addToTail(gEdge);
            this.auctionEdge(gEdge);
            this.mergeEdges(gEdge);
            return DRAW_OK;
        }
        return null;
    }

    public Object drawMidpoint(GVertex gVertex, GVertex gVertex2, String string) {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(gVertex) != null && gEdge.vertexList.seek(gVertex2) != null) {
                GPoint3D gPoint3D = GMath.midpoint(gVertex.xyzCrds, gVertex2.xyzCrds);
                GVertex gVertex3 = gEdge.vertexList.seek(gPoint3D, gEdge.getLength());
                if (gVertex3 != null) {
                    return "Point already drawn : " + gVertex3.getLabel();
                }
                gVertex3 = new GVertex(gPoint3D, string, false);
                gEdge.addVertex(gVertex3);
                if (gEdge.twin != null) {
                    gEdge.twin.addVertex(gVertex3);
                }
                this.auctionVertex(gVertex3);
                return gVertex3;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return null;
    }

    public Object drawIntersection(GVertex[] gVertexArray, String string) {
        int n = 0;
        while (n < 4) {
            if (this.edgeList.seek(gVertexArray[n]) == null) {
                return null;
            }
            ++n;
        }
        GEdge gEdge = this.edgeList.seek(gVertexArray[0], gVertexArray[1]);
        GEdge gEdge2 = this.edgeList.seek(gVertexArray[2], gVertexArray[3]);
        if (gEdge == null) {
            return "Line " + gVertexArray[0].getLabel() + gVertexArray[1].getLabel() + " not drawn";
        }
        if (gEdge2 == null) {
            return "Line " + gVertexArray[2].getLabel() + gVertexArray[3].getLabel() + " not drawn";
        }
        GPoint3D gPoint3D = GMath.intersect(gEdge, gEdge2);
        if (gPoint3D == null || !this.encircles(gPoint3D)) {
            return "Lines " + gVertexArray[0].getLabel() + gVertexArray[1].getLabel() + ", " + gVertexArray[2].getLabel() + gVertexArray[3].getLabel() + " do not intersect";
        }
        this.edgeList.getHead();
        GVertex gVertex = this.seek(gPoint3D);
        if (gVertex != null) {
            return "Point already drawn : " + gVertex.getLabel();
        }
        gVertex = new GVertex(gPoint3D, string, false);
        gEdge.addVertex(gVertex);
        gEdge2.addVertex(gVertex);
        this.auctionVertex(gVertex);
        this.auctionEdge(gEdge);
        this.auctionEdge(gEdge2);
        this.mergeEdges(gEdge);
        this.mergeEdges(gEdge2);
        GEdge gEdge3 = null;
        GFacet gFacet = null;
        if (gEdge.twin != null) {
            gEdge3 = gEdge.twin;
            gFacet = gEdge.wing2;
        } else if (gEdge2.twin != null) {
            gEdge3 = gEdge2.twin;
            gFacet = gEdge2.wing2;
        }
        if (gEdge3 != null) {
            gEdge3.addVertex(gVertex);
            gFacet.auctionVertex(gVertex);
        }
        return gVertex;
    }

    public Object drawBisector(GVertex[] gVertexArray, String string) {
        GVertex gVertex;
        GPointObject gPointObject;
        int n = 0;
        while (n < 3) {
            if (this.edgeList.seek(gVertexArray[n]) == null) {
                return null;
            }
            ++n;
        }
        GEdge gEdge = this.edgeList.seek(gVertexArray[0], gVertexArray[1]);
        GEdge gEdge2 = this.edgeList.seek(gVertexArray[0], gVertexArray[2]);
        if (gEdge == null) {
            return "Line " + gVertexArray[0].getLabel() + gVertexArray[1].getLabel() + " not drawn";
        }
        if (gEdge2 == null) {
            return "Line " + gVertexArray[0].getLabel() + gVertexArray[2].getLabel() + " not drawn";
        }
        if (gEdge == gEdge2) {
            return String.valueOf(gVertexArray[1].getLabel()) + gVertexArray[0].getLabel() + gVertexArray[2].getLabel() + " is no angle between 0 and 180 degrees";
        }
        GPoint3D gPoint3D = gVertexArray[0].xyzCrds;
        GPoint3D gPoint3D2 = GMath.toNorm(GMath.subtract(gVertexArray[1].xyzCrds, gPoint3D));
        GPoint3D gPoint3D3 = GMath.toNorm(GMath.subtract(gVertexArray[2].xyzCrds, gPoint3D));
        GPoint3D gPoint3D4 = GMath.add(gPoint3D2, gPoint3D3);
        GPoint3D gPoint3D5 = GMath.subtract(gPoint3D2, gPoint3D3);
        GPointObject[] gPointObjectArray = this.getIntercept(gPoint3D, gPoint3D5);
        GPointObject gPointObject2 = gPointObject = GMath.scalarP(GMath.subtract(gPointObjectArray[0].toPoint3D(), gPoint3D), gPoint3D4) > 0.0 ? gPointObjectArray[0] : gPointObjectArray[1];
        if (gPointObject instanceof GVertex) {
            gVertex = (GVertex)gPointObject;
            if (this.edgeList.seek(gVertexArray[0], gVertex) != null) {
                return "Bisector already drawn : " + gVertexArray[0].getLabel() + gVertex.getLabel();
            }
        } else {
            gVertex = new GVertex((GPoint3D)gPointObject, string, false);
            this.auctionVertex(gVertex);
        }
        GEdge gEdge3 = new GEdge(gVertexArray[0], gVertex, this);
        this.edgeList.addToTail(gEdge3);
        this.auctionEdge(gEdge3);
        this.mergeEdges(gEdge3);
        if (gPointObject instanceof GVertex) {
            return DRAW_OK;
        }
        return gVertex;
    }

    public Object drawPerpendicular(GVertex[] gVertexArray, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < 3) {
            if (this.edgeList.seek(gVertexArray[n]) == null) {
                return null;
            }
            ++n;
        }
        GEdge gEdge = this.edgeList.seek(gVertexArray[1], gVertexArray[2]);
        if (gEdge == null) {
            return "Line " + gVertexArray[1].getLabel() + gVertexArray[2].getLabel() + " not drawn";
        }
        if (gEdge.twin != null && gEdge.vertexList.seek(gVertexArray[0]) != null && !bl) {
            gEdge.setSelected(true);
            gVertexArray[0].setSelected(true);
            return "Facet Prompt";
        }
        GPoint3D gPoint3D = GMath.subtract(gEdge.getHead().xyzCrds, gEdge.getTail().xyzCrds);
        GPoint3D gPoint3D2 = gVertexArray[0].xyzCrds;
        GVertexList gVertexList = new GVertexList();
        GPointObject gPointObject = gEdge.intersectPlane(gPoint3D2, gPoint3D);
        if (gPointObject == null) {
            return "Perpendicular out of facet";
        }
        if (gEdge.vertexList.seek(gVertexArray[0]) == null) {
            GVertex gVertex;
            if (gPointObject instanceof GVertex) {
                gVertex = (GVertex)gPointObject;
                if (this.edgeList.seek(gVertexArray[0], gVertex) != null) {
                    return "Perpendicular already drawn : " + gVertexArray[0].getLabel() + gVertex.getLabel();
                }
            } else {
                gVertex = new GVertex((GPoint3D)gPointObject, stringArray[0], false);
                this.auctionVertex(gVertex);
                gVertexList.addToTail(gVertex);
            }
            GEdge gEdge2 = new GEdge(gVertexArray[0], gVertex, this);
            this.edgeList.addToTail(gEdge2);
            this.auctionEdge(gEdge2);
            this.mergeEdges(gEdge2);
            if (gVertexList.getDim() != 0) {
                return gVertexList;
            }
            return DRAW_OK;
        }
        GPointObject[] gPointObjectArray = this.getIntercept(gPoint3D2, gPoint3D);
        if (gPointObjectArray[1] == null) {
            return "Perpendicular out of facet";
        }
        GVertex[] gVertexArray2 = new GVertex[2];
        int n2 = 0;
        while (n2 < 2) {
            if (gPointObjectArray[n2] instanceof GVertex) {
                gVertexArray2[n2] = (GVertex)gPointObjectArray[n2];
            } else {
                gVertexArray2[n2] = new GVertex((GPoint3D)gPointObjectArray[n2], stringArray[n2], false);
                gVertexList.addToTail(gVertexArray2[n2]);
            }
            ++n2;
        }
        if (this.edgeList.seek(gVertexArray2[0], gVertexArray2[1]) != null) {
            return "Perpendicular already drawn : " + gVertexArray2[0].getLabel() + gVertexArray2[1].getLabel();
        }
        this.auctionVertex(gVertexArray2[0]);
        this.auctionVertex(gVertexArray2[1]);
        GEdge gEdge3 = new GEdge(gVertexArray2[0], gVertexArray2[1], this);
        this.edgeList.addToTail(gEdge3);
        this.auctionEdge(gEdge3);
        this.mergeEdges(gEdge3);
        if (gVertexList.getDim() != 0) {
            return gVertexList;
        }
        return DRAW_OK;
    }

    public GFacet cutOff(GVertex gVertex, GVertex gVertex2, GPoint3D gPoint3D, GLabelList gLabelList) {
        Serializable serializable;
        GEdge gEdge;
        GLabelNode gLabelNode = gLabelList.getFirstUnmarked();
        GEdgeList gEdgeList = new GEdgeList();
        GEdgeList gEdgeList2 = this.edgeList.toCycle();
        GEdge gEdge2 = null;
        GEdge gEdge3 = null;
        GEdgeNode gEdgeNode = gEdgeList2.getHead();
        while (true) {
            gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(gVertex) != null && gVertex != gEdge.getTail()) {
                if (!(GMath.scalarP(gEdge, gPoint3D) < 0.0)) break;
                serializable = gVertex;
                gVertex = gVertex2;
                gVertex2 = serializable;
                break;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        while (true) {
            gEdge = gEdgeNode.getEdge();
            if (gEdge.vertexList.seek(gVertex) != null && gVertex != gEdge.getTail()) {
                gEdge2 = gEdge;
                gEdgeList2.setHead(gEdgeNode);
            }
            if (gEdge.vertexList.seek(gVertex2) != null && gVertex2 != gEdge.getHead()) {
                gEdge3 = gEdge;
            }
            if (gEdge2 != null && gEdge3 != null) break;
            gEdgeNode = gEdgeNode.getNext();
        }
        gEdgeNode = gEdgeList2.getHead();
        gEdgeList.addToTail(gEdge2.cutOffTo(gVertex));
        gEdgeNode = gEdgeNode.getNext();
        while (gEdgeNode.getEdge() != gEdge3) {
            gEdgeList.addToTail(gEdgeNode.getEdge());
            gEdgeNode = gEdgeNode.getNext();
        }
        gEdgeList.addToTail(gEdge3.cutOffFrom(gVertex2));
        gEdge = new GEdge(gVertex2, gVertex);
        gEdgeList.addToTail(gEdge);
        serializable = new GFacet(gEdgeList, this.color);
        ((GFacet)serializable).markedEdge = gEdge;
        GPoint3D gPoint3D2 = gVertex.xyzCrds;
        gEdgeNode = this.edgeList.getParaHead();
        while (gEdgeNode != null) {
            GVertex gVertex3;
            Object object;
            GEdge gEdge4 = gEdgeNode.getEdge();
            GVertex gVertex4 = gEdge4.getHead();
            GVertex gVertex5 = gEdge4.getTail();
            int n = gVertex4.getAttitude(gPoint3D2, gPoint3D);
            int n2 = gVertex5.getAttitude(gPoint3D2, gPoint3D);
            if (n == 1 && n2 == 1) {
                ((GFacet)serializable).edgeList.addToTail(gEdge4);
            } else if (n == 0 && n2 == 0) {
                object = gEdge4.vertexList.getHead();
                while (object != null) {
                    gVertex3 = ((GVertexNode)object).getVertex();
                    if (gVertex3 != gVertex2 && gVertex3 != gVertex) {
                        gEdge.addVertex(gVertex3);
                    }
                    object = ((GVertexNode)object).getNext();
                }
            } else if (n == 0 && n2 == 1) {
                if (gVertex4 != gVertex2 && gVertex4 != gVertex) {
                    gEdge.addVertex(gVertex4);
                }
                ((GFacet)serializable).edgeList.addToTail(gEdge4);
            } else if (n2 == 0 && n == 1) {
                if (gVertex5 != gVertex2 && gVertex5 != gVertex) {
                    gEdge.addVertex(gVertex5);
                }
                ((GFacet)serializable).edgeList.addToTail(gEdge4);
            } else if (n == 1 || n2 == 1) {
                if (n2 == 1) {
                    gEdge4.reverse();
                }
                if ((object = gEdge4.intersectPlane(gPoint3D2, gPoint3D)) instanceof GVertex) {
                    gVertex3 = (GVertex)object;
                } else {
                    gVertex3 = new GVertex((GPoint3D)object, gLabelNode.getLabel(), false);
                    gLabelNode.setMarked(true);
                    gLabelNode = gLabelNode.getNext();
                    gEdge4.addVertex(gVertex3);
                }
                gEdge.addVertex(gVertex3);
                ((GFacet)serializable).edgeList.addToTail(gEdge4.cutOffFrom(gVertex3));
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return serializable;
    }

    public GEdgeList[] isSimilar(GFacet gFacet, boolean bl) {
        Serializable serializable;
        int n = this.getProperDim();
        if (n != gFacet.edgeList.getDim()) {
            return null;
        }
        GEdgeList gEdgeList = this.edgeList.toCycle();
        GEdgeList gEdgeList2 = gFacet.edgeList;
        gEdgeList2 = bl ? gEdgeList2.reverse().toCycle() : gEdgeList2.toCycle();
        GEdgeNode gEdgeNode = gEdgeList.getHead();
        GEdge gEdge = gEdgeNode.getPrev().getEdge();
        GEdge gEdge2 = gEdgeNode.getEdge();
        GEdgeList gEdgeList3 = new GEdgeList();
        GEdgeNode gEdgeNode2 = gEdgeList2.getHead();
        int n2 = 0;
        while (n2 < gEdgeList2.getDim()) {
            GEdge gEdge3 = gEdgeNode2.getPrev().getEdge();
            if (GMath.isSimilar(gEdge, gEdge2, gEdge3, (GEdge)(serializable = gEdgeNode2.getEdge()))) {
                gEdgeList3.addToTail(gEdgeNode2.getEdge());
            }
            gEdgeNode2 = gEdgeNode2.getNext();
            ++n2;
        }
        if (gEdgeList3.getDim() == 0) {
            return null;
        }
        int n3 = 0;
        serializable = gEdgeList3.getHead();
        while (serializable != null) {
            gEdgeList2.setHead(((GEdgeNode)serializable).getEdge());
            gEdgeNode = gEdgeList.getHead();
            gEdgeNode2 = gEdgeList2.getHead();
            int n4 = 0;
            while (n4 < gEdgeList2.getDim()) {
                GEdge gEdge4;
                GEdge gEdge5;
                gEdge = gEdgeNode.getPrev().getEdge();
                if (!GMath.isSimilar(gEdge, gEdge2 = gEdgeNode.getEdge(), gEdge5 = gEdgeNode2.getPrev().getEdge(), gEdge4 = gEdgeNode2.getEdge())) break;
                if (++n3 == n) {
                    GEdgeList[] gEdgeListArray = new GEdgeList[]{gEdgeList, gEdgeList2};
                    return gEdgeListArray;
                }
                gEdgeNode = gEdgeNode.getNext();
                gEdgeNode2 = gEdgeNode2.getNext();
                ++n4;
            }
            serializable = ((GEdgeNode)serializable).getNext();
        }
        return null;
    }

    public void join(GFacet gFacet, GEdge gEdge, GEdge gEdge2) {
        Serializable serializable;
        Serializable serializable2;
        double d = gEdge.getLength();
        GVertexNode gVertexNode = gEdge2.vertexList.getHead();
        while (gVertexNode != null) {
            serializable2 = gVertexNode.getVertex();
            serializable = ((GVertex)serializable2).xyzCrds;
            if (gEdge.vertexList.seek((GPoint3D)serializable, d) == null) {
                gEdge.addVertex(new GVertex((GPoint3D)serializable, ((GVertex)serializable2).getLabel(), ((GVertex)serializable2).isProper()));
            }
            gVertexNode = gVertexNode.getNext();
        }
        gEdge2.vertexList = gEdge.vertexList.reverse();
        serializable2 = gFacet.edgeList.getHead();
        while (serializable2 != null) {
            serializable = ((GEdgeNode)serializable2).getEdge();
            if (serializable != gEdge2) {
                GVertex gVertex = gEdge.vertexList.seek(((GEdge)serializable).getHead().xyzCrds, d);
                if (gVertex != null) {
                    ((GEdge)serializable).vertexList = ((GEdge)serializable).vertexList.replaceHead(gVertex);
                } else {
                    gVertex = gEdge.vertexList.seek(((GEdge)serializable).getTail().xyzCrds, d);
                    if (gVertex != null) {
                        ((GEdge)serializable).vertexList = ((GEdge)serializable).vertexList.replaceTail(gVertex);
                    }
                }
            }
            serializable2 = ((GEdgeNode)serializable2).getNext();
        }
    }

    public GFacet merge(GFacet gFacet, GEdge gEdge, GEdge gEdge2) {
        GEdgeList gEdgeList = new GEdgeList();
        GEdgeList gEdgeList2 = gFacet.edgeList.toCycle();
        gEdgeList2.setHead(gEdge2);
        GEdgeNode gEdgeNode = gEdgeList2.getHead().getNext();
        GEdge gEdge3 = gEdgeNode.getEdge();
        gEdge3.vertexList = gEdge3.vertexList.replaceHead(gEdge.getHead());
        gEdgeNode = gEdgeNode.getNext();
        GEdge gEdge4 = null;
        while (gEdgeNode != gEdgeList2.getHead()) {
            gEdge4 = gEdgeNode.getEdge();
            gEdgeList.addToTail(gEdge4);
            gEdgeNode = gEdgeNode.getNext();
        }
        gEdge4.vertexList = gEdge4.vertexList.replaceTail(gEdge.getTail());
        gEdgeList2 = this.edgeList.toCycle();
        gEdgeList2.setHead(gEdge);
        gEdgeNode = gEdgeList2.getHead().getNext();
        GEdge gEdge5 = gEdgeNode.getEdge();
        if (GMath.areCollinear(gEdge4, gEdge5)) {
            gEdge4.vertexList = new GVertexList(gEdge4.getHead(), gEdge5.getTail());
            gEdgeNode = gEdgeNode.getNext();
        }
        while (gEdgeNode != gEdgeList2.getHead()) {
            gEdge4 = gEdgeNode.getEdge();
            gEdgeList.addToTail(gEdge4);
            gEdgeNode = gEdgeNode.getNext();
        }
        if (GMath.areCollinear(gEdge4, gEdge3)) {
            gEdge4.vertexList = new GVertexList(gEdge4.getHead(), gEdge3.getTail());
        } else {
            gEdgeList.addToTail(gEdge3);
        }
        GFacet gFacet2 = new GFacet(gEdgeList, this.color);
        return gFacet2;
    }

    public Object layDistance(GVertex[] gVertexArray, double d, String[] stringArray) {
        int n = 0;
        while (n < 3) {
            if (this.edgeList.seek(gVertexArray[n]) == null) {
                return null;
            }
            ++n;
        }
        GEdge gEdge = this.edgeList.seek(gVertexArray[1], gVertexArray[2]);
        if (gEdge == null) {
            return "Line " + gVertexArray[1].getLabel() + gVertexArray[2].getLabel() + " not drawn";
        }
        GPoint3D gPoint3D = gVertexArray[0].xyzCrds;
        GPointObject[] gPointObjectArray = gEdge.intersectSphere(gPoint3D, d);
        if (gPointObjectArray[0] == null && gPointObjectArray[1] == null) {
            if (d > GMath.dist(gPoint3D, gEdge.getHead().xyzCrds) && d > GMath.dist(gPoint3D, gEdge.getTail().xyzCrds)) {
                return "Distance too large";
            }
            return "Line " + gVertexArray[1].getLabel() + gVertexArray[2].getLabel() + " out of reach";
        }
        GVertexList gVertexList = new GVertexList();
        int n2 = 0;
        while (n2 < 2) {
            if (gPointObjectArray[n2] instanceof GPoint3D) {
                GVertex gVertex = new GVertex((GPoint3D)gPointObjectArray[n2], stringArray[n2], false);
                this.auctionVertex(gVertex);
                gVertexList.addToTail(gVertex);
            }
            ++n2;
        }
        if (gVertexList.getDim() != 0) {
            return gVertexList;
        }
        return "Distance already laid : " + gVertexArray[0].getLabel() + ((GVertex)gPointObjectArray[0]).getLabel();
    }

    public Object layAngle(GVertex[] gVertexArray, double d, String[] stringArray, boolean bl) {
        int n = 0;
        while (n < 2) {
            if (this.edgeList.seek(gVertexArray[n]) == null) {
                return null;
            }
            ++n;
        }
        GEdge gEdge = this.edgeList.seek(gVertexArray[0], gVertexArray[1]);
        if (gEdge == null) {
            return "Line " + gVertexArray[0].getLabel() + gVertexArray[1].getLabel() + " not drawn";
        }
        if (gEdge.twin != null && !bl) {
            gEdge.setSelected(true);
            gVertexArray[0].setSelected(true);
            return "Facet Prompt";
        }
        GVertexList gVertexList = new GVertexList();
        int n2 = 0;
        String string = null;
        GPoint3D gPoint3D = gVertexArray[0].xyzCrds;
        GPoint3D gPoint3D2 = GMath.subtract(gVertexArray[1].xyzCrds, gVertexArray[0].xyzCrds);
        GPoint3D[] gPoint3DArray = GMath.layAngle(gPoint3D2, this.getXYZNormal(), d);
        int n3 = 0;
        while (n3 < 2) {
            block9: {
                GVertex gVertex;
                block13: {
                    GPointObject gPointObject;
                    block12: {
                        block11: {
                            GPointObject[] gPointObjectArray;
                            block10: {
                                GPointObject gPointObject2;
                                gPointObjectArray = this.getIntercept(gPoint3D, gPoint3DArray[n3]);
                                if (gPointObjectArray[1] == null) break block9;
                                if (gPointObjectArray[1] == gVertexArray[0]) {
                                    gPointObject2 = gPointObjectArray[0];
                                    gPointObjectArray[0] = gPointObjectArray[1];
                                    gPointObjectArray[1] = gPointObject2;
                                }
                                if (!GMath.areEqual(GMath.angle((GPoint3D)(gPointObject2 = GMath.subtract(gPointObjectArray[1].toPoint3D(), gPoint3D)), gPoint3D2), d * Math.PI / 180.0)) break block10;
                                gPointObject = gPointObjectArray[1];
                                break block11;
                            }
                            if (gPointObjectArray[0] == gVertexArray[0]) break block9;
                            gPointObject = gPointObjectArray[0];
                        }
                        if (!(gPointObject instanceof GVertex)) break block12;
                        gVertex = (GVertex)gPointObject;
                        if (this.edgeList.seek(gVertexArray[0], gVertex) == null) break block13;
                        string = String.valueOf(gVertexArray[1].getLabel()) + gVertexArray[0].getLabel() + gVertex.getLabel();
                        break block9;
                    }
                    gVertex = new GVertex((GPoint3D)gPointObject, stringArray[n3], false);
                    gVertexList.addToTail(gVertex);
                    this.auctionVertex(gVertex);
                }
                gEdge = new GEdge(gVertexArray[0], gVertex, this);
                this.edgeList.addToTail(gEdge);
                this.auctionEdge(gEdge);
                this.mergeEdges(gEdge);
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            if (string != null) {
                return "Angle already laid : " + string;
            }
            return "Angle too large";
        }
        if (gVertexList.getDim() != 0) {
            return gVertexList;
        }
        return DRAW_OK;
    }

    public GPoint3D computeCenter() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            GPoint3D gPoint3D = gEdgeNode.getEdge().getHead().xyzCrds;
            d += gPoint3D.X;
            d2 += gPoint3D.Y;
            d3 += gPoint3D.Z;
            ++n;
            gEdgeNode = gEdgeNode.getNext();
        }
        return new GPoint3D(d / (double)n, d2 / (double)n, d3 / (double)n);
    }

    public double computeArea() {
        double d = 0.0;
        GPoint3D gPoint3D = this.computeCenter();
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        while (gEdgeNode != null && gEdgeNode.getEdge().twin != null) {
            GEdge gEdge = gEdgeNode.getEdge();
            GPoint3D gPoint3D2 = gEdge.getHead().xyzCrds;
            GPoint3D gPoint3D3 = gEdge.getTail().xyzCrds;
            d += GMath.area(gPoint3D2, gPoint3D3, gPoint3D);
            gEdgeNode = gEdgeNode.getNext();
        }
        return d;
    }

    public boolean contains(GPoint3D gPoint3D) {
        GPoint3D gPoint3D2 = this.edgeList.getHead().getEdge().getHead().xyzCrds;
        return GMath.areOrthogonal(GMath.subtract(gPoint3D, gPoint3D2), this.getXYZNormal());
    }

    public boolean contains(GPoint3DList gPoint3DList) {
        GPoint3DNode gPoint3DNode = gPoint3DList.getHead();
        while (gPoint3DNode != null) {
            if (!this.contains(gPoint3DNode.getPoint3D())) {
                return false;
            }
            gPoint3DNode = gPoint3DNode.getNext();
        }
        return true;
    }

    public boolean isEquilateral() {
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        double d = gEdgeNode.getEdge().getLength();
        gEdgeNode = gEdgeNode.getNext();
        while (gEdgeNode != null) {
            if (!GMath.areEqual(gEdgeNode.getEdge().getLength(), d)) {
                return false;
            }
            gEdgeNode = gEdgeNode.getNext();
        }
        return true;
    }

    public boolean isIsoTriangle() {
        if (this.edgeList.getDim() != 3) {
            return false;
        }
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        double d = gEdgeNode.getEdge().getLength();
        gEdgeNode = gEdgeNode.getNext();
        double d2 = gEdgeNode.getEdge().getLength();
        gEdgeNode = gEdgeNode.getNext();
        double d3 = gEdgeNode.getEdge().getLength();
        return GMath.areEqual(d, d2) || GMath.areEqual(d2, d3) || GMath.areEqual(d3, d);
    }

    public boolean isRectTriangle() {
        if (this.edgeList.getDim() != 3) {
            return false;
        }
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GPoint3D gPoint3D = gEdgeNode.getEdge().toVector();
        gEdgeNode = gEdgeNode.getNext();
        GPoint3D gPoint3D2 = gEdgeNode.getEdge().toVector();
        gEdgeNode = gEdgeNode.getNext();
        GPoint3D gPoint3D3 = gEdgeNode.getEdge().toVector();
        return GMath.areOrthogonal(gPoint3D, gPoint3D2) || GMath.areOrthogonal(gPoint3D2, gPoint3D3) || GMath.areOrthogonal(gPoint3D, gPoint3D3);
    }

    public boolean isEquiTriangle() {
        return this.edgeList.getDim() == 3 && this.isEquilateral();
    }

    public boolean isParallelogram() {
        if (this.edgeList.getDim() != 4) {
            return false;
        }
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        double d = gEdgeNode.getEdge().getLength();
        gEdgeNode = gEdgeNode.getNext();
        double d2 = gEdgeNode.getEdge().getLength();
        gEdgeNode = gEdgeNode.getNext();
        double d3 = gEdgeNode.getEdge().getLength();
        gEdgeNode = gEdgeNode.getNext();
        double d4 = gEdgeNode.getEdge().getLength();
        return GMath.areEqual(d, d3) && GMath.areEqual(d2, d4);
    }

    public boolean isRhombus() {
        return this.edgeList.getDim() == 4 && this.isEquilateral();
    }

    public boolean isRectangle() {
        if (!this.isParallelogram()) {
            return false;
        }
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GPoint3D gPoint3D = gEdgeNode.getEdge().toVector();
        gEdgeNode = gEdgeNode.getNext();
        GPoint3D gPoint3D2 = gEdgeNode.getEdge().toVector();
        return GMath.areOrthogonal(gPoint3D, gPoint3D2);
    }

    public boolean isSquare() {
        GPoint3D gPoint3D;
        if (!this.isParallelogram()) {
            return false;
        }
        GEdgeNode gEdgeNode = this.edgeList.getHead();
        GPoint3D gPoint3D2 = gEdgeNode.getEdge().toVector();
        return GMath.areOrthogonal(gPoint3D2, gPoint3D = (gEdgeNode = gEdgeNode.getNext()).getEdge().toVector()) && GMath.areEqual(GMath.norm(gPoint3D2), GMath.norm(gPoint3D));
    }
}

