/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class GBasicColorDialog
extends GOkCancelHelpDialog
implements MouseListener {
    public static final int DEFAULT = 1;
    private int selected;
    private GSpectrum[] spectra;

    public GBasicColorDialog(GFrame gFrame, int n, String string) {
        super(gFrame, "Basic Color");
        this.helpTopic = "basic color";
        this.setTitle("Basic Color in " + string);
        this.selected = n;
        this.layComponents();
        this.spectra[this.selected].setSelected(true);
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        Color[] colorArray = GPalette.basicColors;
        this.spectra = new GSpectrum[colorArray.length];
        int n = 0;
        while (n < colorArray.length) {
            this.spectra[n] = new GSpectrum(n, colorArray[n], n == this.selected);
            this.spectra[n].addMouseListener(this);
            if (n == colorArray.length - 1) {
                gridBagConstraints.gridwidth = 0;
            }
            gridBagLayout.setConstraints(this.spectra[n], gridBagConstraints);
            this.dataPanel.add(this.spectra[n]);
            ++n;
        }
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected void init() {
    }

    protected boolean onOk() {
        return true;
    }

    public int getColor() {
        return this.selected;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        GSpectrum gSpectrum = (GSpectrum)mouseEvent.getSource();
        this.spectra[this.selected].setSelected(false);
        this.spectra[this.selected].repaint();
        gSpectrum.setSelected(true);
        gSpectrum.repaint();
        this.selected = gSpectrum.getPosition();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

