/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class GSolidCanvas
extends Canvas
implements ActionListener,
MouseListener,
KeyListener {
    public static final int SOLID_LINESTYLE = 0;
    public static final int THICK_LINESTYLE = 1;
    public static final int DASHED_LINESTYLE = 2;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int MIDDLE = 2;
    public static final int INSET = 30;
    public static final int BLOBWIDTH = 7;
    public static final double STROKELENGTH = 7.0;
    public static final int TOLERANCE = 4;
    public static final int DELAY = 50;
    private Font labelFont;
    private GProblem problem;
    private GSolidWindow window;
    private GSolid solid;
    private GXYGrid xyGrid;
    private GRectangle uvBounds;
    private double uMed;
    private double vMed;
    private double scale;
    private Dimension pureSize;
    private Dimension preferredSize;
    private Graphics graphics;
    private GPopupMenuSW popupMenu;
    private boolean zoomed;
    private boolean revolved;
    private boolean isRevolving;
    private boolean isLabeled;
    private long startTime;

    public GSolidCanvas(GFrame gFrame, GProblem gProblem, GSolidWindow gSolidWindow, GSolid gSolid, GXYGrid gXYGrid) {
        this.problem = gProblem;
        this.window = gSolidWindow;
        this.solid = gSolid;
        this.xyGrid = gXYGrid;
        this.popupMenu = new GPopupMenuSW(this.problem, this.xyGrid, this.solid, this);
        this.add(this.popupMenu);
        this.setBackground(Color.white);
        this.labelFont = gFrame.labelFont;
        this.pureSize = new Dimension(0, 0);
        this.preferredSize = new Dimension(0, 0);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.startTime = System.currentTimeMillis();
    }

    public void setSolid(GSolid gSolid) {
        this.solid = gSolid;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean wasZoomed() {
        return this.zoomed;
    }

    public boolean wasRevolved() {
        return this.revolved;
    }

    public void setRevolved(boolean bl) {
        this.revolved = bl;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    protected Point uvToScreen(GPoint3D gPoint3D) {
        Point point = new Point();
        if (!this.isRevolving) {
            this.uMed = (this.uvBounds.left + this.uvBounds.right) / 2.0;
            this.vMed = (this.uvBounds.bottom + this.uvBounds.top) / 2.0;
        }
        point.x = (int)Math.rint((double)(this.getSize().width / 2) + this.scale * (gPoint3D.X - this.uMed));
        point.y = (int)Math.rint((double)(this.getSize().height / 2) + this.scale * (this.vMed - gPoint3D.Y));
        return point;
    }

    protected GPoint3D screenToUV(Point point) {
        GPoint3D gPoint3D = new GPoint3D();
        double d = (this.uvBounds.left + this.uvBounds.right) / 2.0;
        double d2 = (this.uvBounds.bottom + this.uvBounds.top) / 2.0;
        gPoint3D.X = (double)(point.x - this.getSize().width / 2) / this.scale + d;
        gPoint3D.Y = (double)(this.getSize().height / 2 - point.y) / this.scale + d2;
        gPoint3D.Z = 0.0;
        return gPoint3D;
    }

    protected void fit(Dimension dimension) {
        double d;
        this.uvBounds = this.solid.uvBounds;
        if (this.xyGrid.isVisible()) {
            this.uvBounds = this.uvBounds.add(this.xyGrid.uvBounds);
        }
        double d2 = this.uvBounds.right - this.uvBounds.left;
        double d3 = this.uvBounds.top - this.uvBounds.bottom;
        if (d2 == 0.0 && d3 == 0.0) {
            this.scale = 0.0;
            return;
        }
        if (d2 == 0.0) {
            this.pureSize.height = dimension.height - 60;
            this.scale = (double)Math.max(1, this.pureSize.height) / d3;
            return;
        }
        if (d3 == 0.0) {
            this.pureSize.width = dimension.width - 60;
            this.scale = (double)Math.max(1, this.pureSize.width) / d2;
            return;
        }
        this.pureSize.width = dimension.width - 60;
        this.pureSize.height = dimension.height - 60;
        double d4 = (double)Math.max(1, this.pureSize.width) / d2;
        if (d4 < (d = (double)Math.max(1, this.pureSize.height) / d3)) {
            this.scale = d4;
            this.pureSize.height = (int)Math.rint(d3 * d4);
            return;
        }
        this.scale = d;
        this.pureSize.width = (int)Math.rint(d2 * d);
    }

    protected void adjustPreferredSize() {
        this.uvBounds = this.solid.uvBounds;
        if (this.xyGrid.isVisible()) {
            this.uvBounds = this.uvBounds.add(this.xyGrid.uvBounds);
        }
        double d = this.uvBounds.right - this.uvBounds.left;
        double d2 = this.uvBounds.top - this.uvBounds.bottom;
        this.preferredSize = new Dimension((int)Math.rint(this.scale * d) + 60, (int)Math.rint(this.scale * d2) + 60);
        this.getParent().doLayout();
    }

    public void zoomIn() {
        if (this.scale == 0.0) {
            return;
        }
        if (!this.zoomed) {
            this.preferredSize = new Dimension(this.pureSize.width + 90, this.pureSize.height + 90);
        }
        this.preferredSize = new Dimension(2 * this.preferredSize.width - 90, 2 * this.preferredSize.height - 90);
        this.scale *= 2.0;
        this.getParent().doLayout();
        this.repaint();
        this.window.toFront();
        this.requestFocus();
        this.zoomed = true;
    }

    public void zoomOut() {
        if (this.scale == 0.0) {
            return;
        }
        if (!this.zoomed) {
            this.preferredSize = new Dimension(this.pureSize.width + 90, this.pureSize.height + 90);
        }
        this.preferredSize = new Dimension((this.preferredSize.width + 90) / 2, (this.preferredSize.height + 90) / 2);
        this.scale /= 2.0;
        this.getParent().doLayout();
        this.repaint();
        this.window.toFront();
        this.requestFocus();
        this.zoomed = true;
    }

    public void bestFit() {
        this.zoomed = false;
        this.revolved = false;
        this.preferredSize = new Dimension(0, 0);
        this.repaint();
        this.getParent().doLayout();
        this.window.toFront();
        this.requestFocus();
    }

    public void paint(Graphics graphics) {
        this.graphics = graphics;
        if (!this.zoomed && !this.revolved || this.scale == 0.0) {
            this.fit(this.getSize());
        }
        if (!this.isRevolving) {
            this.adjustPreferredSize();
        }
        if (this.solid.vertexList.getDim() == 0) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
            if (this.xyGrid.isVisible()) {
                this.xyGrid.paint(this, this.solid);
            }
            return;
        }
        this.xyGrid.paint(this, this.solid);
        this.solid.paint(this);
    }

    protected void drawBlob(Point point, Color color) {
        this.graphics.setColor(color);
        this.graphics.fillOval(point.x - 3, point.y - 3, 7, 7);
    }

    protected void drawLine(Point point, Point point2, int n) {
        switch (n) {
            case 0: {
                this.graphics.drawLine(point.x, point.y, point2.x, point2.y);
                return;
            }
            case 1: {
                this.graphics.drawLine(point.x, point.y, point2.x, point2.y);
                int n2 = Math.abs(point2.x - point.x);
                int n3 = Math.abs(point2.y - point.y);
                if (n3 < 2 * n2) {
                    this.graphics.drawLine(point.x, point.y - 1, point2.x, point2.y - 1);
                    this.graphics.drawLine(point.x, point.y + 1, point2.x, point2.y + 1);
                }
                if (n2 >= 2 * n3) break;
                this.graphics.drawLine(point.x - 1, point.y, point2.x - 1, point2.y);
                this.graphics.drawLine(point.x + 1, point.y, point2.x + 1, point2.y);
                return;
            }
            case 2: {
                int n4 = point2.x - point.x;
                int n5 = point2.y - point.y;
                double d = Math.sqrt((double)n4 * (double)n4 + (double)(n5 * n5));
                if (d <= 7.0) {
                    this.graphics.drawLine(point.x, point.y, point2.x, point2.y);
                    return;
                }
                if (Math.abs(n4) >= Math.abs(n5)) {
                    int n6 = point.x;
                    double d2 = point.y;
                    double d3 = (double)n5 / (double)n4;
                    int n7 = (int)((double)n4 * 7.0 / d);
                    double d4 = d3 * (double)n7;
                    int n8 = n4 / n7;
                    int n9 = 0;
                    while (n9 < n8) {
                        if (n9 % 2 == 0) {
                            this.graphics.drawLine(n6, (int)Math.round(d2), n6 + n7, (int)Math.round(d2 + d4));
                        }
                        n6 += n7;
                        d2 += d4;
                        ++n9;
                    }
                    if (n8 % 2 != 0) break;
                    this.graphics.drawLine(n6, (int)Math.round(d2), point2.x, point2.y);
                    return;
                }
                int n10 = point.y;
                double d5 = point.x;
                double d6 = (double)n4 / (double)n5;
                int n11 = (int)((double)n5 * 7.0 / d);
                double d7 = d6 * (double)n11;
                int n12 = n5 / n11;
                int n13 = 0;
                while (n13 < n12) {
                    if (n13 % 2 == 0) {
                        this.graphics.drawLine((int)Math.round(d5), n10, (int)Math.round(d5 + d7), n10 + n11);
                    }
                    n10 += n11;
                    d5 += d7;
                    ++n13;
                }
                if (n12 % 2 != 0) break;
                this.graphics.drawLine((int)Math.round(d5), n10, point2.x, point2.y);
            }
        }
    }

    public void horizMark(GPoint3D gPoint3D, Color color) {
        Point point = this.uvToScreen(gPoint3D);
        this.graphics.setColor(color);
        this.graphics.drawLine(point.x - 3, point.y, point.x + 3, point.y);
    }

    public void paint(GPoint3D gPoint3D, Color color) {
        Point point = this.uvToScreen(gPoint3D);
        this.drawBlob(point, color);
    }

    public void paint(GVertex gVertex, Color color) {
        Point point = this.uvToScreen(gVertex.uvwCrds);
        this.drawBlob(point, color);
    }

    public void slapLabel(Point point, String string) {
        this.graphics.setFont(this.labelFont);
        this.graphics.setColor(Color.black);
        int n = this.graphics.getFontMetrics().getAscent();
        this.graphics.drawString(string, point.x + 4, point.y + n + 2);
    }

    public void fitLabel(GVertex gVertex, Color color) {
        this.graphics.setFont(this.labelFont);
        int n = this.graphics.getFontMetrics().getAscent() + 1;
        String string = gVertex.getLabel();
        int n2 = this.graphics.getFontMetrics().stringWidth(string) + 3;
        Point point = this.uvToScreen(gVertex.uvwCrds);
        int n3 = gVertex.edgeStar.getDim();
        double[] dArray = new double[n3 + 1];
        GEdgeNode gEdgeNode = gVertex.edgeStar.getHead();
        int n4 = 0;
        while (gEdgeNode != null) {
            Point point2 = this.uvToScreen(gEdgeNode.getEdge().getTail().uvwCrds);
            point2.translate(-point.x, -point.y);
            double d = Math.acos((double)point2.x / Math.sqrt(point2.x * point2.x + point2.y * point2.y));
            if (point2.y < 0) {
                d = Math.PI * 2 - d;
            }
            dArray[n4++] = d;
            gEdgeNode = gEdgeNode.getNext();
        }
        dArray[n3] = Math.PI * 2;
        GMath.sort(dArray);
        int n5 = n3;
        dArray[n5] = dArray[n5] + dArray[0];
        double d = 0.0;
        double d2 = Math.PI * 2;
        double d3 = 0.0;
        n4 = 0;
        while (n4 < n3) {
            if (dArray[n4 + 1] - dArray[n4] > d3) {
                d = dArray[n4];
                d2 = dArray[n4 + 1];
                d3 = d2 - d;
            }
            ++n4;
        }
        Point point3 = new Point(point.x + (int)((double)(n2 / 2 + 5) * Math.cos((d + d2) / 2.0)), point.y + (int)((double)(n / 2 + 5) * Math.sin((d + d2) / 2.0)));
        if (color != null) {
            this.graphics.setColor(color);
            this.graphics.fillRect(point3.x - n2 / 2, point3.y - n / 2, n2, n);
        }
        this.graphics.setColor(Color.black);
        this.graphics.drawString(string, point3.x - n2 / 2 + 1, point3.y + n / 2 - 2);
    }

    public void paint(GEdge gEdge, Color color, int n) {
        this.graphics.setColor(color);
        Point point = this.uvToScreen(gEdge.getHead().uvwCrds);
        Point point2 = this.uvToScreen(gEdge.getTail().uvwCrds);
        this.drawLine(point, point2, n);
    }

    public void paint(GSegment gSegment, Color color, int n) {
        this.graphics.setColor(color);
        Point point = this.uvToScreen(gSegment.end1);
        Point point2 = this.uvToScreen(gSegment.end2);
        this.drawLine(point, point2, n);
    }

    public void paint(GSegment gSegment, Color color, int n, String string, String string2) {
        this.graphics.setColor(color);
        Point point = this.uvToScreen(gSegment.end1);
        Point point2 = this.uvToScreen(gSegment.end2);
        this.drawLine(point, point2, n);
        if (string != null) {
            this.slapLabel(point, string);
        }
        if (string2 != null) {
            this.slapLabel(point2, string2);
        }
    }

    public void paint(GFacet gFacet) {
        this.paint(gFacet, null);
    }

    public void paint(GFacet gFacet, Color color) {
        if (color != null) {
            this.graphics.setColor(color);
        } else {
            this.graphics.setColor(gFacet.getColor());
        }
        int n = this.solid.isRipe() ? gFacet.getProperDim() : gFacet.edgeList.getDim();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
        int n2 = 0;
        while (n2 < n) {
            GEdge gEdge = gEdgeNode.getEdge();
            if (gEdge.twin == null && this.solid.isRipe()) break;
            Point point = this.uvToScreen(gEdgeNode.getEdge().getHead().uvwCrds);
            nArray[n2] = point.x;
            nArray2[n2] = point.y;
            gEdgeNode = gEdgeNode.getNext();
            ++n2;
        }
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void clearSelections() {
        this.solid.clearSelection(true, true, true);
        this.xyGrid.clearSelection(this.solid);
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if ((n == 37 || n == 39 || n == 38 || n == 40) && this.isRevolving) {
            this.solid.setLabeled(this.isLabeled);
            this.isRevolving = false;
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37 || n == 39 || n == 38 || n == 40) {
            this.revolved = true;
            if (!this.isRevolving) {
                this.startTime = System.currentTimeMillis();
                this.isLabeled = this.solid.isLabeled();
                this.isRevolving = true;
            }
            this.solid.revolve(n);
            this.xyGrid.project(this.solid);
            this.solid.setLabeled(false);
            this.repaint();
            while (System.currentTimeMillis() < this.startTime + 50L) {
            }
            return;
        }
        if (n == 33) {
            this.zoomIn();
            return;
        }
        if (n == 34) {
            this.zoomOut();
            return;
        }
        if (n == 32) {
            this.bestFit();
            return;
        }
        if (n == 36) {
            this.problem.initAttitude(this.window);
            return;
        }
        this.problem.keyPressed(keyEvent);
    }

    public int whichButton(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            return 1;
        }
        if (mouseEvent.isAltDown()) {
            return 2;
        }
        return 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block10: {
            block7: {
                block9: {
                    GPoint3D gPoint3D;
                    block8: {
                        if (this.whichButton(mouseEvent) != 0) break block7;
                        Point point = mouseEvent.getPoint();
                        gPoint3D = this.screenToUV(point);
                        if (!this.xyGrid.isVisible()) break block8;
                        GPoint3D gPoint3D2 = this.xyGrid.selectZ(gPoint3D, this.solid, 4.0 / this.scale);
                        if (gPoint3D2 != null) {
                            this.repaint();
                            ((GCProblem)this.problem).addVertex(this.window, gPoint3D2);
                            return;
                        }
                        if (this.xyGrid.selectXY(gPoint3D, this.solid, 4.0 / this.scale)) {
                            this.repaint();
                            return;
                        }
                        break block9;
                    }
                    if (this.solid.select(gPoint3D, 4.0 / this.scale, mouseEvent.isControlDown()) == null) break block10;
                    this.repaint();
                }
                return;
            }
            if (this.whichButton(mouseEvent) == 1) {
                Point point = mouseEvent.getPoint();
                this.xyGrid.getXYSelection();
                this.popupMenu = new GPopupMenuSW(this.problem, this.xyGrid, this.solid, this);
                this.add(this.popupMenu);
                if (this.popupMenu.getItemCount() > 0) {
                    this.popupMenu.show(this, point.x, point.y);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        if (gMenuItem == this.popupMenu.addVertexPMenuItem) {
            this.xyGrid.buildVertical(this.solid);
            this.repaint();
            return;
        }
        if (gMenuItem == this.popupMenu.bestFitPMenuItem) {
            this.bestFit();
            return;
        }
        if (gMenuItem == this.popupMenu.clearSelectionPMenuItem) {
            this.clearSelections();
            return;
        }
        if (gMenuItem == this.popupMenu.distancePMenuItem) {
            this.problem.distance(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.anglePMenuItem) {
            this.problem.angle(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.linePMenuItem) {
            this.problem.drawLine(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.midpointPMenuItem) {
            this.problem.drawMidpoint(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.perpPMenuItem) {
            this.problem.drawPerpendicular(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.intersectPMenuItem) {
            this.problem.drawIntersection(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.eraseLinePMenuItem || gMenuItem == this.popupMenu.erasePointPMenuItem) {
            this.problem.erase(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.bisectorPMenuItem) {
            this.problem.drawBisector(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.cutPMenuItem) {
            this.problem.cut(this.window, 1, null);
            return;
        }
        if (gMenuItem == this.popupMenu.vertexPropsPMenuItem) {
            ((GCProblem)this.problem).vertexProperties(this.window);
            return;
        }
        if (gMenuItem == this.popupMenu.facetColorPMenuItem) {
            ((GCProblem)this.problem).setFacetColor(this.window);
        }
    }
}

