/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class GSaveShapeDialog
extends GShapeDialog
implements ItemListener {
    protected TextField nameInput;

    public GSaveShapeDialog(GFrame gFrame, String string) {
        super(gFrame, string, "Save Shape As");
        this.helpTopic = "save shape";
        this.shapes.addItemListener(this);
        this.pack();
        this.positionLeft();
        this.show();
    }

    protected void layShapeInput(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        Label label = new Label("Save shape as:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.top = 5;
        this.nameInput = new TextField(10);
        this.nameInput.setFont(GDialog.frame.labelFont);
        gridBagLayout.setConstraints(this.nameInput, gridBagConstraints);
        this.dataPanel.add(this.nameInput);
    }

    protected void layButtons(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        this.okButton.setLabel("Save");
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        return this.checkShapeName(this.nameInput.getText().trim());
    }

    public String getShapeName() {
        return this.nameInput.getText().trim();
    }

    public boolean checkShapeName(String string) {
        if (string.length() == 0) {
            return false;
        }
        String string2 = null;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == ' ') {
                string2 = "Shape name cannot contain blank spaces";
            } else if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9')) {
                string2 = "Only alphanumeric names are accepted";
            }
            ++n;
        }
        if (string2 != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Bad Shape Name", string2);
            return false;
        }
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10 || n == 32) {
            ActionEvent actionEvent = new ActionEvent(this.okButton, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            ActionEvent actionEvent = new ActionEvent(this.okButton, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ((TextComponent)this.nameInput).setText(this.shapes.getSelectedItem());
    }
}

